/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.client.render;

import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.client.render.LayerSkinsuit;
import the_fireplace.overlord.client.render.ModelSkeletonWarrior;
import the_fireplace.overlord.entity.EntitySkeletonWarrior;
import the_fireplace.overlord.network.PacketDispatcher;
import the_fireplace.overlord.network.packets.RequestAugmentMessage;
import the_fireplace.overlord.tools.RenderTools;

@SideOnly(value=Side.CLIENT)
public class RenderSkeletonWarrior
extends RenderBiped<EntitySkeletonWarrior> {
    public static final ResourceLocation SKELETON_TEXTURES = new ResourceLocation("textures/entity/skeleton/skeleton.png");
    public static final ResourceLocation WITHER_SKELETON_TEXTURES = new ResourceLocation("textures/entity/skeleton/wither_skeleton.png");
    public static final ResourceLocation IRON_SKELETON_TEXTURES = new ResourceLocation("overlord", "textures/entity/iron_skeleton.png");
    public static final ResourceLocation OBSIDIAN_SKELETON_TEXTURES = new ResourceLocation("overlord", "textures/entity/obsidian_skeleton.png");
    public static final ResourceLocation ANVIL_SKELETON_TEXTURES = new ResourceLocation("overlord", "textures/entity/anvil_skeleton.png");
    public static final ResourceLocation BRAINSTONE_SKELETON_TEXTURES = new ResourceLocation("overlord", "textures/entity/brainstone_skeleton.png");

    public RenderSkeletonWarrior(RenderManager renderManagerIn) {
        super(renderManagerIn, (ModelBiped)new ModelSkeletonWarrior(), 0.5f);
        this.func_177094_a(new LayerSkinsuit((RenderLivingBase<?>)this, new ModelSkeletonWarrior(0.0f, true, true, 2)));
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this){

            protected void func_177177_a() {
                this.field_177189_c = new ModelSkeletonWarrior(0.5f, true, false, 1);
                this.field_177186_d = new ModelSkeletonWarrior(1.0f, true, false, 1);
            }
        });
    }

    public void func_82422_c() {
        GlStateManager.func_179109_b((float)0.09375f, (float)0.1875f, (float)0.0f);
    }

    protected ResourceLocation getEntityTexture(@Nonnull EntitySkeletonWarrior entity) {
        if (!entity.cachedClientAugment) {
            PacketDispatcher.sendToServer(new RequestAugmentMessage(entity));
        }
        if (entity.getAugment() != null) {
            switch (entity.getAugment().augmentId()) {
                case "wither": {
                    return WITHER_SKELETON_TEXTURES;
                }
                case "iron": {
                    return IRON_SKELETON_TEXTURES;
                }
                case "iron_anvil": {
                    return ANVIL_SKELETON_TEXTURES;
                }
                case "obsidian": {
                    return OBSIDIAN_SKELETON_TEXTURES;
                }
                case "pulsatingbrainstone": {
                    return BRAINSTONE_SKELETON_TEXTURES;
                }
            }
        }
        return SKELETON_TEXTURES;
    }

    public void doRender(@Nonnull EntitySkeletonWarrior entitySkeletonWarrior, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((EntityLiving)entitySkeletonWarrior, x, y, z, entityYaw, partialTicks);
        if (Minecraft.func_71410_x().field_71439_g.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == Overlord.crown) {
            if (!entitySkeletonWarrior.cachedClientAugment) {
                PacketDispatcher.sendToServer(new RequestAugmentMessage(entitySkeletonWarrior));
            }
            RenderTools.renderItemStackOverEntity((Entity)entitySkeletonWarrior, entitySkeletonWarrior.getAugmentDisplayStack(), (Render)this, partialTicks, x, y, z);
        }
    }
}

