/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.entity;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.advancements.CriterionRegistry;
import the_fireplace.overlord.config.ConfigValues;
import the_fireplace.overlord.entity.EntityArmyMember;
import the_fireplace.overlord.entity.ai.EntityAIArmyBow;
import the_fireplace.overlord.network.PacketDispatcher;
import the_fireplace.overlord.network.packets.RequestAugmentMessage;
import the_fireplace.overlord.registry.AugmentRegistry;
import the_fireplace.overlord.tools.Augment;
import the_fireplace.overlord.tools.ISkinsuitWearer;
import the_fireplace.overlord.tools.SkinType;

public class EntityConvertedSkeleton
extends EntityArmyMember
implements ISkinsuitWearer {
    private static final DataParameter<String> SKINSUIT_NAME = EntityDataManager.func_187226_a(EntityConvertedSkeleton.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Byte> SKINSUIT_TYPE = EntityDataManager.func_187226_a(EntityConvertedSkeleton.class, (DataSerializer)DataSerializers.field_187191_a);
    private EntityAIArmyBow aiArrowAttack = null;
    public final InventoryBasic inventory;
    public final InventoryBasic equipInventory;
    public EntityConvertedSkeleton instance = this;
    static ItemStack bucket = new ItemStack(Items.field_151133_ar);
    static ItemStack bottle = new ItemStack(Items.field_151069_bo);
    boolean sally = false;
    boolean armed = false;
    boolean crusader = false;

    public EntityConvertedSkeleton(World world) {
        this(world, null);
    }

    public EntityConvertedSkeleton(final World world, @Nullable UUID owner) {
        super(world, owner);
        this.inventory = new InventoryBasic("Items", false, 9);
        this.equipInventory = new InventoryBasic("Equipment", false, 7){

            public boolean func_94041_b(int index, ItemStack stack) {
                return index >= 4 && index < 6 || index == 6 && AugmentRegistry.getAugment(stack) != null || !stack.func_190926_b() && stack.func_77973_b().isValidArmor(stack, EntityEquipmentSlot.values()[index], null);
            }

            public void func_70299_a(int index, ItemStack stack) {
                super.func_70299_a(index, stack);
                if (world.field_72995_K && index == 6) {
                    PacketDispatcher.sendToServer(new RequestAugmentMessage(EntityConvertedSkeleton.this.instance));
                }
            }

            @Nonnull
            public ItemStack func_70304_b(int index) {
                ItemStack stack = super.func_70304_b(index);
                if (world.field_72995_K && index == 6) {
                    PacketDispatcher.sendToServer(new RequestAugmentMessage(EntityConvertedSkeleton.this.instance));
                }
                return stack;
            }

            @Nonnull
            public ItemStack func_70298_a(int index, int count) {
                ItemStack stack = super.func_70298_a(index, count);
                if (world.field_72995_K && index == 6) {
                    PacketDispatcher.sendToServer(new RequestAugmentMessage(EntityConvertedSkeleton.this.instance));
                }
                return stack;
            }
        };
        this.func_98053_h(true);
    }

    @Override
    public void addAttackTasks() {
        if (this.aiAttackOnCollide == null) {
            this.aiAttackOnCollide = new EntityAIAttackMelee(this, 1.2, false){

                public void func_75251_c() {
                    super.func_75251_c();
                    EntityConvertedSkeleton.this.setSwingingArms(false);
                }

                public void func_75249_e() {
                    super.func_75249_e();
                    EntityConvertedSkeleton.this.raiseArmTicks = 0;
                }

                public void func_75246_d() {
                    if (!this.field_75441_b.func_184614_ca().func_190926_b() && !this.field_75441_b.func_184592_cb().func_190926_b() && this.field_75441_b.func_184614_ca().func_77973_b() instanceof ItemBow && this.field_75441_b.func_184592_cb().func_77973_b() instanceof ItemArrow) {
                        ((EntityArmyMember)this.field_75441_b).func_184651_r();
                        return;
                    }
                    if (this.func_75253_b()) {
                        ++EntityConvertedSkeleton.this.raiseArmTicks;
                        if (EntityConvertedSkeleton.this.raiseArmTicks >= 5 && this.field_75439_d < 10) {
                            EntityConvertedSkeleton.this.setSwingingArms(true);
                        } else {
                            EntityConvertedSkeleton.this.setSwingingArms(false);
                        }
                        super.func_75246_d();
                    }
                }
            };
        }
        if (this.aiArrowAttack == null) {
            this.aiArrowAttack = new EntityAIArmyBow(this, 1.0, 20, 15.0f);
        }
        if (!this.func_184614_ca().func_190926_b() && this.func_184614_ca().func_77973_b() instanceof ItemBow) {
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiArrowAttack);
            return;
        }
        if ((Byte)this.field_70180_af.func_187225_a(MOVEMENT_MODE) > 0) {
            this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiAttackOnCollide);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.getOwner() != null && this.getOwner().equals((Object)player)) {
            ItemStack stack;
            if (!player.func_70093_af()) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)Overlord.instance, (int)this.hashCode(), (World)this.field_70170_p, (int)((int)this.field_70165_t), (int)((int)this.field_70163_u), (int)((int)this.field_70161_v));
                return true;
            }
            if (!this.field_70170_p.field_72995_K && !(stack = player.func_184586_b(hand)).func_190926_b() && stack.func_77973_b() == Overlord.converted_spawner) {
                NBTTagCompound compound = new NBTTagCompound();
                this.func_70014_b(compound);
                stack.func_77982_d(compound);
            }
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SKINSUIT_TYPE, (Object)((byte)SkinType.NONE.ordinal()));
        this.field_70180_af.func_187214_a(SKINSUIT_NAME, (Object)String.valueOf(""));
    }

    @Override
    public Augment getAugment() {
        if (this.equipInventory == null) {
            return null;
        }
        if (AugmentRegistry.getAugment(this.getAugmentStack()) == null && this.field_70170_p.field_72995_K) {
            return this.getClientAugment();
        }
        return AugmentRegistry.getAugment(this.getAugmentStack());
    }

    @Nonnull
    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    public void func_70636_d() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                if (this.inventory.func_70301_a(i).func_190926_b() || !(this.func_110143_aJ() < this.func_110138_aP())) continue;
                if (this.inventory.func_70301_a(i).func_77973_b() == Items.field_151117_aB) {
                    this.func_70691_i(1.0f);
                    if (this.inventory.func_70301_a(i).func_190916_E() > 1) {
                        this.inventory.func_70301_a(i).func_190918_g(1);
                    } else {
                        this.inventory.func_70299_a(i, ItemStack.field_190927_a);
                    }
                    this.inventory.func_174894_a(bucket);
                    continue;
                }
                if (this.inventory.func_70301_a(i).func_77973_b() != Overlord.milk_bottle) continue;
                this.func_70691_i(1.0f);
                if (this.inventory.func_70301_a(i).func_190916_E() > 1) {
                    this.inventory.func_70301_a(i).func_190918_g(1);
                } else {
                    this.inventory.func_70299_a(i, ItemStack.field_190927_a);
                }
                this.inventory.func_174894_a(bottle);
            }
            if (this.field_70170_p.func_72935_r()) {
                BlockPos blockpos;
                float f = this.func_70013_c();
                BlockPos blockPos = blockpos = this.func_184187_bx() instanceof EntityBoat ? new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v).func_177984_a() : new BlockPos(this.field_70165_t, (double)Math.round(this.field_70163_u), this.field_70161_v);
                if (!this.getSkinType().protectsFromSun() && f > 0.5f && this.field_70146_Z.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && this.field_70170_p.func_175678_i(blockpos)) {
                    boolean flag = true;
                    ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.HEAD);
                    if (!itemstack.func_190926_b()) {
                        if (ConfigValues.HELMETDAMAGE && itemstack.func_77984_f()) {
                            itemstack.func_77964_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                            if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                                this.func_70669_a(itemstack);
                                this.func_184201_a(EntityEquipmentSlot.HEAD, ItemStack.field_190927_a);
                            }
                        }
                        flag = false;
                    }
                    if (flag) {
                        this.func_70015_d(6);
                    }
                }
            }
            this.field_70170_p.func_72872_a(EntityItem.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0)).stream().filter(entityitem -> !entityitem.field_70128_L && !entityitem.func_92059_d().func_190926_b() && !entityitem.func_174874_s()).forEach(entityitem -> {
                ItemStack stack2 = this.inventory.func_174894_a(entityitem.func_92059_d());
                if (!stack2.func_190926_b()) {
                    if (stack2.func_190916_E() != entityitem.func_92059_d().func_190916_E()) {
                        this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    }
                    entityitem.func_92059_d().func_190920_e(stack2.func_190916_E());
                    if (stack2.func_77973_b() == Items.field_151117_aB || stack2.func_77973_b() == Overlord.milk_bottle) {
                        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                            if (this.inventory.func_70301_a(i).func_190926_b() || this.inventory.func_70301_a(i).func_77973_b() != Items.field_151133_ar && this.inventory.func_70301_a(i).func_77973_b() != Items.field_151069_bo) continue;
                            this.func_70099_a(this.inventory.func_70301_a(i), 0.1f);
                            this.inventory.func_70299_a(i, ItemStack.field_190927_a);
                        }
                    }
                } else {
                    entityitem.func_70106_y();
                    this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
            });
            if (!this.func_184614_ca().func_190926_b() && this.func_184614_ca().func_77973_b() instanceof ItemBow && (!this.func_184592_cb().func_190926_b() && !(this.func_184592_cb().func_77973_b() instanceof ItemArrow) || this.func_184592_cb().func_190926_b())) {
                int i;
                boolean swapWeapon = true;
                for (i = 0; i < this.inventory.func_70302_i_(); ++i) {
                    if (this.inventory.func_70301_a(i).func_190926_b() || !(this.inventory.func_70301_a(i).func_77973_b() instanceof ItemArrow)) continue;
                    ItemStack offhand = ItemStack.field_190927_a;
                    if (!this.func_184592_cb().func_190926_b()) {
                        offhand = this.func_184592_cb().func_77946_l();
                    }
                    ItemStack arrows = this.inventory.func_70301_a(i).func_77946_l();
                    this.func_184611_a(EnumHand.OFF_HAND, arrows);
                    this.inventory.func_70299_a(i, offhand);
                    swapWeapon = false;
                    break;
                }
                if (swapWeapon) {
                    for (i = 0; i < this.inventory.func_70302_i_(); ++i) {
                        if (this.inventory.func_70301_a(i).func_190926_b() || !(this.inventory.func_70301_a(i).func_77973_b() instanceof ItemSword)) continue;
                        ItemStack clone = this.inventory.func_70301_a(i).func_77946_l();
                        this.inventory.func_70299_a(i, this.func_184614_ca());
                        this.func_184611_a(EnumHand.MAIN_HAND, clone);
                        break;
                    }
                }
            }
            if (!this.func_184614_ca().func_190926_b()) {
                if (this.getOwner() != null && this.getOwner() instanceof EntityPlayerMP && !this.armed) {
                    CriterionRegistry.instance.SKELETON_STATUS_UPDATE.trigger((EntityPlayerMP)this.getOwner(), (Entity)this, Items.field_151041_m, 0);
                    this.armed = true;
                }
            } else if (this.armed) {
                this.armed = false;
            }
            if (this.getSkinType().equals(SkinType.PLAYER)) {
                if (this.getOwner() != null && this.getOwner() instanceof EntityPlayerMP && !this.sally) {
                    CriterionRegistry.instance.SKELETON_STATUS_UPDATE.trigger((EntityPlayerMP)this.getOwner(), (Entity)this, Overlord.skinsuit, 0);
                    this.sally = true;
                }
            } else if (this.sally) {
                this.sally = false;
            }
            if (!(this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() || this.func_184582_a(EntityEquipmentSlot.CHEST).func_190926_b() || this.func_184582_a(EntityEquipmentSlot.LEGS).func_190926_b() || this.func_184582_a(EntityEquipmentSlot.FEET).func_190926_b())) {
                if (this.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == Items.field_151020_U && this.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == Items.field_151023_V && this.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == Items.field_151022_W && this.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == Items.field_151029_X) {
                    if (!this.func_184592_cb().func_190926_b() && this.func_184592_cb().func_77978_p() != null && this.func_184592_cb().func_77973_b() instanceof ItemShield && this.func_184592_cb().func_77978_p().equals((Object)Overlord.crusaderShield().func_77978_p()) && this.getOwner() != null && this.getOwner() instanceof EntityPlayerMP && !this.crusader) {
                        CriterionRegistry.instance.SKELETON_STATUS_UPDATE.trigger((EntityPlayerMP)this.getOwner(), (Entity)this, Items.field_185159_cQ, 0);
                        this.crusader = true;
                    }
                } else if (this.crusader) {
                    this.crusader = false;
                }
            }
        }
        this.func_70105_a(0.6f, 1.99f);
        float f = this.func_70013_c();
        if (f > 0.5f && !this.getSkinType().protectsFromSun()) {
            ++this.field_70708_bq;
        }
        super.func_70636_d();
    }

    @Override
    public void func_70645_a(@Nonnull DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76346_g() instanceof EntityCreeper && ((EntityCreeper)cause.func_76346_g()).func_70830_n() && !((EntityCreeper)cause.func_76346_g()).func_175446_cd()) {
            ((EntityCreeper)cause.func_76346_g()).func_175493_co();
            this.func_70099_a(new ItemStack(Items.field_151144_bL), 0.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            EntityItem entityitem;
            int i;
            for (i = 0; i < this.inventory.func_70302_i_(); ++i) {
                if (this.inventory.func_70301_a(i).func_190926_b()) continue;
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.inventory.func_70301_a(i));
                entityitem.func_174869_p();
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            for (i = 0; i < this.equipInventory.func_70302_i_(); ++i) {
                if (this.equipInventory.func_70301_a(i).func_190926_b()) continue;
                entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.equipInventory.func_70301_a(i));
                entityitem.func_174869_p();
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        NBTTagList mainInv;
        super.func_70037_a(compound);
        if (compound.func_74764_b("SkinsuitName")) {
            String s = compound.func_74779_i("SkinsuitName");
            this.field_70180_af.func_187227_b(SKINSUIT_NAME, (Object)s);
        }
        if (compound.func_74764_b("HasSkinsuit")) {
            boolean b = compound.func_74767_n("HasSkinsuit");
            this.field_70180_af.func_187227_b(SKINSUIT_TYPE, (Object)((byte)(b ? 1 : 0)));
        }
        if (compound.func_74764_b("SkinsuitType")) {
            byte b = compound.func_74771_c("SkinsuitType");
            this.field_70180_af.func_187227_b(SKINSUIT_TYPE, (Object)b);
        }
        if ((mainInv = (NBTTagList)compound.func_74781_a("SkeletonInventory")) != null) {
            for (int i = 0; i < mainInv.func_74745_c(); ++i) {
                NBTTagCompound item = (NBTTagCompound)mainInv.func_179238_g(i);
                byte slot = item.func_74771_c("SlotSkeletonInventory");
                if (slot < 0 || slot >= this.inventory.func_70302_i_()) continue;
                this.inventory.func_70299_a((int)slot, new ItemStack(item));
            }
        } else {
            Overlord.logWarn("List was null when reading Converted Skeleton's Inventory", new Object[0]);
        }
        NBTTagList armorInv = (NBTTagList)compound.func_74781_a("SkeletonEquipment");
        if (armorInv != null) {
            for (int i = 0; i < armorInv.func_74745_c(); ++i) {
                NBTTagCompound item = (NBTTagCompound)armorInv.func_179238_g(i);
                byte slot = item.func_74771_c("SlotSkeletonEquipment");
                if (slot < 0 || slot >= this.equipInventory.func_70302_i_()) continue;
                this.equipInventory.func_70299_a((int)slot, new ItemStack(item));
            }
        } else {
            Overlord.logWarn("List was null when reading Converted Skeleton's Equipment", new Object[0]);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("SkinsuitType", ((Byte)this.field_70180_af.func_187225_a(SKINSUIT_TYPE)).byteValue());
        compound.func_74778_a("SkinsuitName", (String)this.field_70180_af.func_187225_a(SKINSUIT_NAME));
        NBTTagList mainInv = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack is = this.inventory.func_70301_a(i);
            if (is.func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("SlotSkeletonInventory", (byte)i);
            is.func_77955_b(item);
            mainInv.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("SkeletonInventory", (NBTBase)mainInv);
        NBTTagList armorInv = new NBTTagList();
        for (int i = 0; i < this.equipInventory.func_70302_i_(); ++i) {
            ItemStack is = this.equipInventory.func_70301_a(i);
            if (is.func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("SlotSkeletonEquipment", (byte)i);
            is.func_77955_b(item);
            armorInv.func_74742_a((NBTBase)item);
        }
        compound.func_74782_a("SkeletonEquipment", (NBTBase)armorInv);
    }

    public float func_70047_e() {
        return 1.74f;
    }

    public double func_70033_W() {
        return -0.35;
    }

    @Override
    public void attackEntityWithRangedAttack(EntityLivingBase target, float distanceFactor) {
        ItemStack itemstack = this.func_184592_cb();
        if (itemstack.func_190926_b() || !(itemstack.func_77973_b() instanceof ItemArrow)) {
            return;
        }
        EntityArrow entityarrow = this.getArrow(distanceFactor);
        double d0 = target.field_70165_t - this.field_70165_t;
        double d1 = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - entityarrow.field_70163_u;
        double d2 = target.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        entityarrow.func_70186_c(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.field_70170_p.func_175659_aa().func_151525_a() * 4));
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185312_x, (EntityLivingBase)this) <= 0) {
            if (itemstack.func_190916_E() > 1) {
                itemstack.func_190918_g(1);
            } else {
                this.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            }
            entityarrow.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        }
        if (!this.func_184614_ca().func_190926_b()) {
            this.func_184614_ca().func_77972_a(1, (EntityLivingBase)this);
        }
        this.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)entityarrow);
    }

    protected EntityArrow getArrow(float distanceFactor) {
        ItemStack itemstack = this.func_184582_a(EntityEquipmentSlot.OFFHAND);
        if (itemstack.func_77973_b() == Items.field_185166_h) {
            EntitySpectralArrow entityspectralarrow = new EntitySpectralArrow(this.field_70170_p, (EntityLivingBase)this);
            entityspectralarrow.func_190547_a((EntityLivingBase)this, distanceFactor);
            return entityspectralarrow;
        }
        EntityTippedArrow entityarrow = new EntityTippedArrow(this.field_70170_p, (EntityLivingBase)this);
        entityarrow.func_190547_a((EntityLivingBase)this, distanceFactor);
        if (itemstack.func_77973_b() == Items.field_185167_i) {
            entityarrow.func_184555_a(itemstack);
        }
        return entityarrow;
    }

    @Nonnull
    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.MAINHAND ? this.equipInventory.func_70301_a(4) : (slotIn == EntityEquipmentSlot.OFFHAND ? this.equipInventory.func_70301_a(5) : (slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR ? this.equipInventory.func_70301_a(slotIn.func_188454_b()) : ItemStack.field_190927_a));
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, @Nonnull ItemStack stack) {
        if (slotIn == EntityEquipmentSlot.MAINHAND) {
            this.func_184606_a_(stack);
            this.equipInventory.func_70299_a(4, stack);
            this.func_184651_r();
        } else if (slotIn == EntityEquipmentSlot.OFFHAND) {
            this.func_184606_a_(stack);
            this.equipInventory.func_70299_a(5, stack);
        } else if (slotIn.func_188453_a() == EntityEquipmentSlot.Type.ARMOR) {
            this.func_184606_a_(stack);
            this.equipInventory.func_70299_a(slotIn.func_188454_b(), stack);
        }
    }

    @Nonnull
    public Iterable<ItemStack> func_184214_aD() {
        return Lists.newArrayList((Object[])new ItemStack[]{this.func_184614_ca(), this.func_184592_cb()});
    }

    @Nonnull
    public Iterable<ItemStack> func_184193_aE() {
        return Arrays.asList(this.equipInventory.func_70301_a(0), this.equipInventory.func_70301_a(1), this.equipInventory.func_70301_a(2), this.equipInventory.func_70301_a(3));
    }

    @Nonnull
    public ItemStack func_184614_ca() {
        if (this.equipInventory == null) {
            return ItemStack.field_190927_a;
        }
        return this.equipInventory.func_70301_a(4);
    }

    @Nonnull
    public ItemStack func_184592_cb() {
        if (this.equipInventory == null) {
            return ItemStack.field_190927_a;
        }
        return this.equipInventory.func_70301_a(5);
    }

    public boolean func_70684_aJ() {
        return true;
    }

    @Override
    @Nonnull
    public ItemStack getAugmentStack() {
        return this.equipInventory.func_70301_a(6);
    }

    @Nonnull
    public ItemStack func_184586_b(EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            return this.func_184614_ca();
        }
        if (hand == EnumHand.OFF_HAND) {
            return this.func_184592_cb();
        }
        throw new IllegalArgumentException("Invalid hand " + hand);
    }

    public void func_184611_a(EnumHand hand, @Nonnull ItemStack stack) {
        if (hand == EnumHand.MAIN_HAND) {
            this.func_184201_a(EntityEquipmentSlot.MAINHAND, stack);
        } else {
            if (hand != EnumHand.OFF_HAND) {
                throw new IllegalArgumentException("Invalid hand " + hand);
            }
            this.func_184201_a(EntityEquipmentSlot.OFFHAND, stack);
        }
    }

    public float func_180484_a(BlockPos pos) {
        if (!this.getSkinType().protectsFromSun()) {
            return 0.5f - this.field_70170_p.func_175724_o(pos);
        }
        return super.func_180484_a(pos);
    }

    @Override
    public boolean willBeAttackedBy(@Nonnull EntityLiving mob) {
        return this.getSkinType().equals(SkinType.PLAYER) && (this.func_184582_a(EntityEquipmentSlot.HEAD).func_190926_b() || this.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() != Items.field_151144_bL || this.func_184582_a(EntityEquipmentSlot.HEAD).func_77960_j() == 3);
    }

    @Override
    @Nonnull
    public SkinType getSkinType() {
        return SkinType.get(((Byte)this.field_70180_af.func_187225_a(SKINSUIT_TYPE)).byteValue());
    }

    @Override
    @Nonnull
    public String getSkinName() {
        return (String)this.field_70180_af.func_187225_a(SKINSUIT_NAME);
    }

    @Override
    public void setSkinsuit(@Nonnull ItemStack stack, @Nonnull SkinType type) {
        if (type.isNone()) {
            ItemStack dropStack;
            ItemStack itemStack = dropStack = this.getSkinType().equals(SkinType.PLAYER) ? new ItemStack(Overlord.skinsuit) : new ItemStack(Overlord.skinsuit_mummy);
            if (ConfigValues.SKINSUITNAMETAGS && this.func_145818_k_() && this.func_95999_t().equals(this.getSkinName())) {
                dropStack.func_151001_c(this.getSkinName());
                this.func_96094_a("");
            }
            this.func_70099_a(dropStack, 0.1f);
        }
        this.field_70180_af.func_187227_b(SKINSUIT_TYPE, (Object)((byte)type.ordinal()));
        if (stack.func_82837_s() && !type.isNone()) {
            this.field_70180_af.func_187227_b(SKINSUIT_NAME, (Object)String.valueOf(stack.func_82833_r()));
            if (ConfigValues.SKINSUITNAMETAGS && !this.func_145818_k_()) {
                this.func_96094_a(stack.func_82833_r());
            }
        } else {
            this.field_70180_af.func_187227_b(SKINSUIT_NAME, (Object)String.valueOf(""));
        }
    }
}

