/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.entity.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemBow;
import net.minecraft.util.EnumHand;
import the_fireplace.overlord.entity.EntityArmyMember;

public class EntityAIArmyBow
extends EntityAIBase {
    private final EntityArmyMember armyMember;
    private final double moveSpeedAmp;
    private int attackCooldown;
    private final float maxAttackDistance;
    private int attackTime = -1;
    private int seeTime;
    private boolean strafingClockwise;
    private boolean strafingBackwards;
    private int strafingTime = -1;

    public EntityAIArmyBow(EntityArmyMember armyMember, double speedAmplifier, int delay, float maxDistance) {
        this.armyMember = armyMember;
        this.moveSpeedAmp = speedAmplifier;
        this.attackCooldown = delay;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        return this.armyMember.func_70638_az() != null && this.isBowInMainhand() && this.isArrowInOffhand();
    }

    protected boolean isBowInMainhand() {
        return !this.armyMember.func_184614_ca().func_190926_b() && this.armyMember.func_184614_ca().func_77973_b() instanceof ItemBow;
    }

    protected boolean isArrowInOffhand() {
        return !this.armyMember.func_184592_cb().func_190926_b() && this.armyMember.func_184592_cb().func_77973_b() instanceof ItemArrow;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.armyMember.func_70661_as().func_75500_f() && this.isBowInMainhand() && this.isArrowInOffhand();
    }

    public void func_75249_e() {
        super.func_75249_e();
        this.armyMember.setSwingingArms(true);
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.armyMember.setSwingingArms(false);
        this.seeTime = 0;
        this.attackTime = -1;
        this.armyMember.func_184602_cy();
    }

    public void func_75246_d() {
        EntityLivingBase attackTarget = this.armyMember.func_70638_az();
        if (attackTarget != null) {
            boolean targetWithinVisibleTime;
            double distanceSq = this.armyMember.func_70092_e(attackTarget.field_70165_t, attackTarget.func_174813_aQ().field_72338_b, attackTarget.field_70161_v);
            boolean canSee = this.armyMember.func_70635_at().func_75522_a((Entity)attackTarget);
            boolean bl = targetWithinVisibleTime = this.seeTime > 0;
            if (canSee != targetWithinVisibleTime) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (this.armyMember.getMovementMode() > 0) {
                if (distanceSq <= (double)this.maxAttackDistance && this.seeTime >= 20) {
                    this.armyMember.func_70661_as().func_75499_g();
                    ++this.strafingTime;
                } else {
                    this.armyMember.func_70661_as().func_75497_a((Entity)attackTarget, this.moveSpeedAmp);
                    this.strafingTime = -1;
                }
            }
            if (this.armyMember.getMovementMode() > 0 && this.strafingTime >= 20) {
                if ((double)this.armyMember.func_70681_au().nextFloat() < 0.3) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if ((double)this.armyMember.func_70681_au().nextFloat() < 0.3) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (this.armyMember.getMovementMode() > 0) {
                    if (distanceSq > (double)(this.maxAttackDistance * 0.75f)) {
                        this.strafingBackwards = false;
                    } else if (distanceSq < (double)(this.maxAttackDistance * 0.25f)) {
                        this.strafingBackwards = true;
                    }
                }
                if (this.armyMember.getMovementMode() > 0) {
                    this.armyMember.func_70605_aq().func_188488_a(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                }
                this.armyMember.func_70625_a((Entity)attackTarget, 30.0f, 30.0f);
            } else {
                this.armyMember.func_70671_ap().func_75651_a((Entity)attackTarget, 30.0f, 30.0f);
            }
            if (this.armyMember.func_184587_cr()) {
                int i;
                if (!canSee && this.seeTime < -60) {
                    this.armyMember.func_184602_cy();
                } else if (canSee && (i = this.armyMember.func_184612_cw()) >= 20) {
                    this.armyMember.func_184602_cy();
                    this.armyMember.attackEntityWithRangedAttack(attackTarget, ItemBow.func_185059_b((int)i));
                    this.attackTime = this.attackCooldown;
                }
            } else if (--this.attackTime <= 0 && this.seeTime >= -60) {
                this.armyMember.func_184598_c(EnumHand.MAIN_HAND);
            }
        }
    }
}

