/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.entity.ai;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.scoreboard.Team;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import the_fireplace.overlord.entity.EntityArmyMember;

public class EntityAIFindEntityNearestSkins
extends EntityAIBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EntityLiving taskOwner;
    private final Predicate<Entity> predicate;
    private final EntityAINearestAttackableTarget.Sorter sorter;
    private EntityLivingBase entityTarget;
    public final Predicate<EntityArmyMember> CAN_ATTACK_ARMY_MEMBER = new Predicate<EntityArmyMember>(){

        @Override
        public boolean test(@Nullable EntityArmyMember p_apply_1_) {
            return p_apply_1_ != null && p_apply_1_.willBeAttackedBy(EntityAIFindEntityNearestSkins.this.taskOwner);
        }
    };

    public EntityAIFindEntityNearestSkins(EntityLiving entityLivingIn) {
        this.taskOwner = entityLivingIn;
        if (entityLivingIn instanceof EntityCreature) {
            LOGGER.warn("Use NearestAttackableTargetGoal.class for PathfinderMob mobs!");
        }
        this.predicate = p_apply_1_ -> {
            if (!(p_apply_1_ instanceof EntityArmyMember)) {
                return false;
            }
            if (p_apply_1_.func_190530_aW()) {
                return false;
            }
            double maxTargetRange = this.maxTargetRange();
            return !((double)p_apply_1_.func_70032_d((Entity)this.taskOwner) > maxTargetRange) && EntityAITarget.func_179445_a((EntityLiving)this.taskOwner, (EntityLivingBase)((EntityLivingBase)p_apply_1_), (boolean)false, (boolean)true) && this.CAN_ATTACK_ARMY_MEMBER.test((EntityArmyMember)((Object)p_apply_1_));
        };
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)entityLivingIn);
    }

    public boolean func_75250_a() {
        double maxTargetRange = this.maxTargetRange();
        List players = this.taskOwner.field_70170_p.func_175647_a(EntityPlayer.class, this.taskOwner.func_174813_aQ().func_72314_b(maxTargetRange, 4.0, maxTargetRange), this.predicate::test);
        players.sort(this.sorter);
        if (players.isEmpty()) {
            return false;
        }
        this.entityTarget = (EntityLivingBase)players.get(0);
        return true;
    }

    public boolean func_75253_b() {
        EntityLivingBase attackTarget = this.taskOwner.func_70638_az();
        if (attackTarget == null) {
            return false;
        }
        if (!attackTarget.func_70089_S()) {
            return false;
        }
        if (attackTarget instanceof EntityPlayer && ((EntityPlayer)attackTarget).field_71075_bZ.field_75102_a) {
            return false;
        }
        Team ownerTeam = this.taskOwner.func_96124_cp();
        Team targetTeam = attackTarget.func_96124_cp();
        if (ownerTeam != null && targetTeam == ownerTeam) {
            return false;
        }
        double maxTargetRange = this.maxTargetRange();
        return !(this.taskOwner.func_70068_e((Entity)attackTarget) > maxTargetRange * maxTargetRange || attackTarget instanceof EntityPlayerMP && ((EntityPlayerMP)attackTarget).field_71134_c.func_73083_d());
    }

    public void func_75249_e() {
        this.taskOwner.func_70624_b(this.entityTarget);
        super.func_75249_e();
    }

    public void func_75251_c() {
        this.taskOwner.func_70624_b(null);
        super.func_75249_e();
    }

    protected double maxTargetRange() {
        IAttributeInstance iattributeinstance = this.taskOwner.func_110148_a(SharedMonsterAttributes.field_111265_b);
        return iattributeinstance == null ? 16.0 : iattributeinstance.func_111126_e();
    }
}

