/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.entity.ai;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import the_fireplace.overlord.entity.EntityArmyMember;

public class EntityAIFollowMaster
extends EntityAIBase {
    private final EntityArmyMember armyMember;
    private EntityLivingBase theOwner;
    World theWorld;
    private final double followSpeed;
    private final PathNavigate armyMemberPathfinder;
    private int timeToRecalcPath;
    float maxDist;
    float minDist;
    private float oldWaterCost;

    public EntityAIFollowMaster(EntityArmyMember armyMember, double followSpeedIn, float minDistIn, float maxDistIn) {
        this.armyMember = armyMember;
        this.theWorld = armyMember.field_70170_p;
        this.followSpeed = followSpeedIn;
        this.armyMemberPathfinder = armyMember.func_70661_as();
        this.minDist = minDistIn;
        this.maxDist = maxDistIn;
        this.func_75248_a(3);
        if (!(armyMember.func_70661_as() instanceof PathNavigateGround)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
        }
    }

    public boolean func_75250_a() {
        EntityLivingBase owner = this.armyMember.getOwner();
        if (owner == null || owner instanceof EntityPlayer && ((EntityPlayer)owner).func_175149_v() || this.armyMember.func_70068_e((Entity)owner) < (double)(this.minDist * this.minDist) || this.armyMember.func_70638_az() != null) {
            return false;
        }
        this.theOwner = owner;
        return true;
    }

    public boolean func_75253_b() {
        return !this.armyMemberPathfinder.func_75500_f() && this.armyMember.func_70638_az() == null && this.armyMember.func_70068_e((Entity)this.theOwner) > (double)(this.maxDist * this.maxDist);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.armyMember.func_184643_a(PathNodeType.WATER);
        this.armyMember.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.theOwner = null;
        this.armyMemberPathfinder.func_75499_g();
        this.armyMember.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
    }

    private boolean isEmptyBlock(BlockPos pos) {
        IBlockState iblockstate = this.theWorld.func_180495_p(pos);
        return iblockstate.func_185904_a() == Material.field_151579_a;
    }

    public void func_75246_d() {
        this.armyMember.func_70671_ap().func_75651_a((Entity)this.theOwner, 10.0f, (float)this.armyMember.func_70646_bf());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.armyMemberPathfinder.func_75497_a((Entity)this.theOwner, this.followSpeed) && !this.armyMember.func_110167_bD() && this.armyMember.field_70143_R <= 0.0f && this.armyMember.func_70068_e((Entity)this.theOwner) >= 144.0) {
                int ownerX = MathHelper.func_76128_c((double)this.theOwner.field_70165_t) - 2;
                int ownerY = MathHelper.func_76128_c((double)this.theOwner.func_174813_aQ().field_72338_b);
                int ownerZ = MathHelper.func_76128_c((double)this.theOwner.field_70161_v) - 2;
                for (int xOffset = 0; xOffset <= 4; ++xOffset) {
                    for (int zOffset = 0; zOffset <= 4; ++zOffset) {
                        if (xOffset >= 1 && zOffset >= 1 && xOffset <= 3 && zOffset <= 3 || !this.theWorld.func_180495_p(new BlockPos(ownerX + xOffset, ownerY - 1, ownerZ + zOffset)).func_185914_p() || !this.isEmptyBlock(new BlockPos(ownerX + xOffset, ownerY, ownerZ + zOffset)) || !this.isEmptyBlock(new BlockPos(ownerX + xOffset, ownerY + 1, ownerZ + zOffset))) continue;
                        this.armyMember.func_70012_b((float)(ownerX + xOffset) + 0.5f, ownerY, (float)(ownerZ + zOffset) + 0.5f, this.armyMember.field_70177_z, this.armyMember.field_70125_A);
                        this.armyMemberPathfinder.func_75499_g();
                        return;
                    }
                }
            }
        }
    }
}

