/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.handlers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.registry.MilkRegistry;

public class MilkBottleWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    @Nonnull
    protected ItemStack container;

    public MilkBottleWrapper(@Nonnull ItemStack container) {
        this.container = container;
    }

    protected void setFluid(@Nullable FluidStack fluidStack) {
        this.container = fluidStack == null ? new ItemStack(Items.field_151069_bo) : new ItemStack(Overlord.milk_bottle);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return MilkRegistry.isMilkRegistered() && capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (MilkRegistry.isMilkRegistered() && capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)this);
        }
        return null;
    }

    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 1000)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 1000 || this.getFluid() != null || !resource.getFluid().getName().toLowerCase().equals("milk")) {
            return 0;
        }
        if (doFill) {
            this.setFluid(resource);
        }
        return 1000;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null && fluidStack.isFluidEqual(resource)) {
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || maxDrain < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }
        return null;
    }

    @Nullable
    public FluidStack getFluid() {
        Item item = this.container.func_77973_b();
        if (MilkRegistry.isMilkRegistered() && item == Overlord.milk_bottle) {
            return FluidRegistry.getFluidStack((String)"milk", (int)1000);
        }
        return null;
    }
}

