/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.network.packets;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import the_fireplace.overlord.network.packets.AbstractClientMessageHandler;
import the_fireplace.overlord.tools.Squads;

public class SetSquadsMessage
implements IMessage {
    public ArrayList<String> squads;

    public SetSquadsMessage() {
    }

    public SetSquadsMessage(ArrayList<String> squadData) {
        this.squads = squadData;
    }

    public void fromBytes(ByteBuf buf) {
        this.squads = Lists.newArrayList();
        while (buf.isReadable()) {
            this.squads.add(ByteBufUtils.readUTF8String((ByteBuf)buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        for (String s : this.squads) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)s);
        }
    }

    public static class Handler
    extends AbstractClientMessageHandler<SetSquadsMessage> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, SetSquadsMessage message, MessageContext ctx) {
            Squads.makeClientInstance(player, message.squads);
            return null;
        }
    }
}

