/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.registry;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.item.ItemStack;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.tools.Augment;

@ParametersAreNonnullByDefault
public final class AugmentRegistry {
    private static HashMap<ItemStack, String> augments = Maps.newHashMap();
    private static HashMap<String, Augment> augmentIDs = Maps.newHashMap();

    public static boolean registerAugment(ItemStack item, Augment augment) {
        if (augment.augmentId().isEmpty()) {
            Overlord.logError("Augment " + augment.getClass() + " has no ID, skipping...", new Object[0]);
            return false;
        }
        if (augments.containsKey(item)) {
            Overlord.logError("Augment already exists for " + item.func_77973_b() + ", skipping...", new Object[0]);
            return false;
        }
        item.func_190920_e(1);
        augments.put(item, augment.augmentId());
        if (!augmentIDs.keySet().contains(augment.augmentId())) {
            augmentIDs.put(augment.augmentId(), augment);
        } else {
            Overlord.logWarn("Augment already exists for ID " + augment.augmentId() + ", skipping " + augment.getClass() + "...", new Object[0]);
        }
        return true;
    }

    @Nullable
    public static Augment getAugment(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        ItemStack stack1 = stack.func_77946_l();
        stack1.func_190920_e(1);
        for (ItemStack augmentItem : augments.keySet()) {
            if (!ItemStack.func_77989_b((ItemStack)stack1, (ItemStack)augmentItem)) continue;
            return AugmentRegistry.getAugment(augments.get(augmentItem));
        }
        return null;
    }

    @Nullable
    public static Augment getAugment(@Nullable String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        return augmentIDs.get(id);
    }
}

