/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.registry;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import the_fireplace.overlord.Overlord;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class MilkRegistry {
    private static MilkRegistry instance;
    private HashMap<ItemStack, ItemStack> milks = Maps.newHashMap();
    public static final IFluidHandler FLUID_BLACK_HOLE;

    private MilkRegistry() {
    }

    public static MilkRegistry getInstance() {
        if (instance == null) {
            instance = new MilkRegistry();
        }
        return instance;
    }

    public static boolean isMilkRegistered() {
        return Overlord.instance.isMilkRegistered;
    }

    @Nullable
    public static Fluid getMilk() {
        return MilkRegistry.isMilkRegistered() ? Overlord.instance.milk : null;
    }

    private static boolean stackContainsMilk(ItemStack stack) {
        FluidStack f = FluidUtil.getFluidContained((ItemStack)stack);
        return MilkRegistry.isMilkRegistered() && f != null && f.getFluid().equals(MilkRegistry.getMilk());
    }

    public void registerMilk(ItemStack inputItem, ItemStack emptyItem) {
        ItemStack emptyCopy;
        ItemStack inputCopy = new ItemStack(inputItem.func_77973_b(), 1, inputItem.func_77960_j());
        ItemStack itemStack = emptyCopy = !emptyItem.func_190926_b() ? new ItemStack(emptyItem.func_77973_b(), 1, emptyItem.func_77960_j()) : ItemStack.field_190927_a;
        if (!this.milks.containsKey(inputCopy)) {
            this.milks.put(inputCopy, emptyCopy);
        } else {
            Overlord.logError("ItemStack was already registered as Milk: " + inputCopy.toString() + ", skipping...", new Object[0]);
        }
    }

    public boolean isMilk(ItemStack stackToCheck) {
        if (MilkRegistry.isMilkRegistered()) {
            return MilkRegistry.stackContainsMilk(stackToCheck);
        }
        for (ItemStack milk : this.milks.keySet()) {
            if (milk.func_77973_b() != stackToCheck.func_77973_b() || milk.func_77960_j() != Short.MAX_VALUE && milk.func_77960_j() != stackToCheck.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public ItemStack getEmptiedStack(ItemStack inputStack) {
        if (MilkRegistry.isMilkRegistered()) {
            FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)inputStack, (IFluidHandler)FLUID_BLACK_HOLE, (int)1000, null, (boolean)false);
            return result.getResult();
        }
        if (inputStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        for (ItemStack milk : this.milks.keySet()) {
            if (milk.func_77973_b() != inputStack.func_77973_b() || milk.func_77960_j() != Short.MAX_VALUE && milk.func_77960_j() != inputStack.func_77960_j()) continue;
            return this.milks.get(milk);
        }
        return ItemStack.field_190927_a;
    }

    static {
        FLUID_BLACK_HOLE = new IFluidHandler(){

            public IFluidTankProperties[] getTankProperties() {
                return new IFluidTankProperties[0];
            }

            public int fill(FluidStack stack, boolean b) {
                return Integer.MAX_VALUE;
            }

            @Nullable
            public FluidStack drain(FluidStack stack, boolean b) {
                return null;
            }

            @Nullable
            public FluidStack drain(int i, boolean b) {
                return null;
            }
        };
    }
}

