/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.tileentity;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.config.ConfigValues;
import the_fireplace.overlord.entity.EntitySkeletonWarrior;
import the_fireplace.overlord.items.ItemOverlordsSeal;
import the_fireplace.overlord.registry.AugmentRegistry;
import the_fireplace.overlord.registry.MilkRegistry;
import the_fireplace.overlord.tileentity.ISkeletonMaker;
import the_fireplace.overlord.tools.SkinType;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TileEntitySkeletonMaker
extends TileEntity
implements ITickable,
ISidedInventory,
ISkeletonMaker,
IFluidHandler,
IFluidTank {
    private ItemStack[] inventory;
    private int heldMilkAmount;
    public static final int heldMilkAmountMax = 2000;
    public static final int[] clearslots = new int[]{6, 7, 8, 9, 10, 11, 12};
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSide = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

    public TileEntitySkeletonMaker() {
        this.inventory = new ItemStack[13];
    }

    public void func_73660_a() {
        if (!this.func_70301_a(4).func_190926_b() && MilkRegistry.getInstance().isMilk(this.func_70301_a(4)) && this.heldMilkAmount < 2000) {
            if (!this.func_70301_a(5).func_190926_b() && !MilkRegistry.getInstance().getEmptiedStack(this.func_70301_a(4)).func_190926_b() && this.func_70301_a(5).func_77973_b() == MilkRegistry.getInstance().getEmptiedStack(this.func_70301_a(4)).func_77973_b() && this.func_70301_a(5).func_190916_E() < this.func_70301_a(5).func_77976_d()) {
                this.setMilk(this.heldMilkAmount + 1000);
                this.func_70301_a(5).func_190917_f(1);
                if (this.func_70301_a(4).func_190916_E() > 1) {
                    this.func_70301_a(4).func_190918_g(1);
                } else {
                    this.func_70299_a(4, ItemStack.field_190927_a);
                }
            } else if (this.func_70301_a(5).func_190926_b()) {
                this.setMilk(this.heldMilkAmount + 1000);
                this.func_70299_a(5, MilkRegistry.getInstance().getEmptiedStack(this.func_70301_a(4)));
                if (this.func_70301_a(4).func_190916_E() > 1) {
                    this.func_70301_a(4).func_190918_g(1);
                } else {
                    this.func_70299_a(4, ItemStack.field_190927_a);
                }
            }
        }
    }

    @Override
    public void spawnSkeleton(@Nullable EntityPlayer player) {
        if (!this.canSpawnSkeleton() || this.field_145850_b.field_72995_K) {
            return;
        }
        UUID owner = null;
        if (!this.func_70301_a(0).func_190926_b() && this.func_70301_a(0).func_77978_p() != null) {
            owner = UUID.fromString(this.func_70301_a(0).func_77978_p().func_74779_i("Owner"));
            if (this.func_70301_a(0).func_77973_b() instanceof ItemOverlordsSeal && ((ItemOverlordsSeal)this.func_70301_a(0).func_77973_b()).isConsumable()) {
                this.func_70301_a(0).func_190918_g(1);
            }
        }
        EntitySkeletonWarrior skeletonWarrior = new EntitySkeletonWarrior(this.field_145850_b, owner);
        skeletonWarrior.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o() + 1, (double)this.field_174879_c.func_177952_p() + 0.5, 1.0f, 0.0f);
        skeletonWarrior.func_184201_a(EntityEquipmentSlot.HEAD, this.func_70301_a(9));
        skeletonWarrior.func_184201_a(EntityEquipmentSlot.CHEST, this.func_70301_a(8));
        skeletonWarrior.func_184201_a(EntityEquipmentSlot.LEGS, this.func_70301_a(7));
        skeletonWarrior.func_184201_a(EntityEquipmentSlot.FEET, this.func_70301_a(6));
        skeletonWarrior.func_184201_a(EntityEquipmentSlot.MAINHAND, this.func_70301_a(10));
        skeletonWarrior.func_184201_a(EntityEquipmentSlot.OFFHAND, this.func_70301_a(11));
        if (!this.func_70301_a(3).func_190926_b()) {
            ItemStack augment = this.func_70301_a(3).func_77946_l();
            augment.func_190920_e(1);
            skeletonWarrior.equipInventory.func_70299_a(6, augment);
            if (this.func_70301_a(3).func_190916_E() > 1) {
                this.func_70301_a(3).func_190918_g(1);
            } else {
                this.func_70299_a(3, ItemStack.field_190927_a);
            }
        }
        this.field_145850_b.func_72838_d((Entity)skeletonWarrior);
        if (player != null && player instanceof EntityPlayerMP) {
            CriteriaTriggers.field_192133_m.func_192229_a((EntityPlayerMP)player, (Entity)skeletonWarrior);
        }
        this.field_145850_b.func_184133_a(null, this.field_174879_c, Overlord.CREATE_SKELETON_SOUND, SoundCategory.BLOCKS, 1.0f, 0.5f + this.field_145850_b.field_73012_v.nextFloat());
        if (!this.func_70301_a(12).func_190926_b()) {
            skeletonWarrior.setSkinsuit(this.func_70301_a(12), SkinType.getSkinTypeFromStack(this.func_70301_a(12)));
        }
        this.setMilk(0);
        for (int i : clearslots) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
        if (!this.func_70301_a(1).func_190926_b()) {
            if (this.func_70301_a(1).func_190916_E() == ConfigValues.BONEREQ_WARRIOR) {
                this.func_70299_a(1, ItemStack.field_190927_a);
            } else if (this.func_70301_a(1).func_190916_E() < ConfigValues.BONEREQ_WARRIOR) {
                this.func_70299_a(1, ItemStack.field_190927_a);
                if (!this.func_70301_a(2).func_190926_b()) {
                    if (this.func_70301_a(2).func_190916_E() <= ConfigValues.BONEREQ_WARRIOR) {
                        this.func_70299_a(2, ItemStack.field_190927_a);
                    } else {
                        this.func_70301_a(2).func_190918_g(ConfigValues.BONEREQ_WARRIOR);
                    }
                }
            } else {
                this.func_70301_a(1).func_190918_g(ConfigValues.BONEREQ_WARRIOR);
            }
        } else if (!this.func_70301_a(2).func_190926_b()) {
            if (this.func_70301_a(2).func_190916_E() <= ConfigValues.BONEREQ_WARRIOR) {
                this.func_70299_a(2, ItemStack.field_190927_a);
            } else {
                this.func_70301_a(2).func_190918_g(ConfigValues.BONEREQ_WARRIOR);
            }
        }
    }

    @Override
    public boolean canSpawnSkeleton() {
        if (this.func_70301_a(1).func_190926_b() && this.func_70301_a(2).func_190926_b()) {
            return false;
        }
        int s1 = 0;
        int s2 = 0;
        if (!this.func_70301_a(1).func_190926_b()) {
            s1 = this.func_70301_a(1).func_190916_E();
        }
        if (!this.func_70301_a(2).func_190926_b()) {
            s2 = this.func_70301_a(2).func_190916_E();
        }
        return this.heldMilkAmount >= 2000 && s1 + s2 >= ConfigValues.SERVER_BONEREQ_WARRIOR;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public String func_70005_c_() {
        return Overlord.proxy.translateToLocal("tile.skeleton_maker.name", new Object[0]);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.skeleton_maker.name", new Object[0]);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public boolean func_191420_l() {
        for (ItemStack itemStack : this.inventory) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        if (this.inventory[index] != null) {
            return this.inventory[index];
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack is = this.func_70301_a(index);
        if (!is.func_190926_b()) {
            if (is.func_190916_E() <= count) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            } else {
                is = is.func_77979_a(count);
                this.func_70296_d();
            }
        }
        return is;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack is = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return is;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory[index] = stack;
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && stack.func_77973_b() instanceof ItemOverlordsSeal || (index == 1 || index == 2) && stack.func_77973_b() == Items.field_151103_aS || index == 3 && AugmentRegistry.getAugment(stack) != null || index == 4 && (stack.func_77973_b() == Items.field_151117_aB || stack.func_77973_b() == Overlord.milk_bottle) || index > 5 && index < 10 && stack.func_77973_b().isValidArmor(stack, this.getSlotEquipmentType(index), null) || index == 12 && stack.func_77973_b() == Overlord.skinsuit;
    }

    private EntityEquipmentSlot getSlotEquipmentType(int index) {
        if (index == 6) {
            return EntityEquipmentSlot.FEET;
        }
        if (index == 7) {
            return EntityEquipmentSlot.LEGS;
        }
        if (index == 8) {
            return EntityEquipmentSlot.CHEST;
        }
        if (index == 9) {
            return EntityEquipmentSlot.HEAD;
        }
        if (index == 10) {
            return EntityEquipmentSlot.MAINHAND;
        }
        return EntityEquipmentSlot.OFFHAND;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.heldMilkAmount;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.heldMilkAmount = value;
                break;
            }
        }
    }

    public int func_174890_g() {
        return 1;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = ItemStack.field_190927_a;
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack is = this.func_70301_a(i);
            if (is.func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("SlotSkeletonMaker", (byte)i);
            is.func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        compound.func_74768_a("HeldMilk", this.heldMilkAmount);
        compound.func_74782_a("ItemsSkeletonMaker", (NBTBase)list);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList list = (NBTTagList)compound.func_74781_a("ItemsSkeletonMaker");
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound item = (NBTTagCompound)list.func_179238_g(i);
                byte slot = item.func_74771_c("SlotSkeletonMaker");
                if (slot < 0 || slot >= this.func_70302_i_()) continue;
                this.func_70299_a(slot, new ItemStack(item));
            }
        } else {
            Overlord.logWarn("List was null when reading TileEntitySkeletonMaker NBTTagCompound", new Object[0]);
        }
        this.heldMilkAmount = compound.func_74771_c("Milk") != 0 ? compound.func_74771_c("Milk") * 1000 : compound.func_74762_e("HeldMilk");
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.EAST || side == EnumFacing.WEST || side == EnumFacing.NORTH || side == EnumFacing.SOUTH || side == EnumFacing.UP) {
            return new int[]{1, 2, 3, 4, 6, 7, 8, 9, 12};
        }
        if (side == EnumFacing.DOWN) {
            return new int[]{5};
        }
        throw new IllegalArgumentException("Invalid side: " + side);
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return !stack.func_190926_b() && (index >= 1 && index < 5 || index >= 6 && index < 10 || index == 12) && this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return !stack.func_190926_b() && index == 5;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.handlerBottom;
            }
            if (facing == EnumFacing.UP) {
                return (T)this.handlerTop;
            }
            return (T)this.handlerSide;
        }
        if (MilkRegistry.isMilkRegistered() && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void setMilk(int milk) {
        this.heldMilkAmount = milk;
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(this.getFluid(), this.getFluidAmount()), this.getCapacity())};
    }

    @Nullable
    public FluidStack getFluid() {
        Fluid milk = MilkRegistry.getMilk();
        if (milk != null && this.getFluidAmount() > 0) {
            return new FluidStack(milk, this.getFluidAmount());
        }
        return null;
    }

    public int getFluidAmount() {
        return this.heldMilkAmount;
    }

    public int getCapacity() {
        return 2000;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (MilkRegistry.isMilkRegistered()) {
            Fluid milk = MilkRegistry.getMilk();
            int maxFillAmount = this.getCapacity() - this.getFluidAmount();
            if (milk != null && resource.getFluid().equals(milk) && maxFillAmount > 0) {
                if (maxFillAmount < resource.amount) {
                    if (doFill) {
                        this.heldMilkAmount += maxFillAmount;
                    }
                    return maxFillAmount;
                }
                if (doFill) {
                    this.heldMilkAmount += resource.amount;
                }
                return resource.amount;
            }
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (MilkRegistry.isMilkRegistered()) {
            Fluid milk = MilkRegistry.getMilk();
            if (resource.amount > 0 && milk != null && resource.getFluid().equals(milk)) {
                if (resource.amount < this.getFluidAmount()) {
                    if (doDrain) {
                        this.heldMilkAmount -= resource.amount;
                    }
                    return new FluidStack(milk, resource.amount);
                }
                int prevHeldMilk = this.getFluidAmount();
                if (doDrain) {
                    this.heldMilkAmount = 0;
                }
                return new FluidStack(milk, prevHeldMilk);
            }
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        Fluid milk;
        if (MilkRegistry.isMilkRegistered() && (milk = MilkRegistry.getMilk()) != null && maxDrain > 0) {
            if (maxDrain < this.getFluidAmount()) {
                if (doDrain) {
                    this.heldMilkAmount -= maxDrain;
                }
                return new FluidStack(milk, maxDrain);
            }
            int prevHeldWater = this.getFluidAmount();
            if (doDrain) {
                this.heldMilkAmount = 0;
            }
            return new FluidStack(milk, prevHeldWater);
        }
        return null;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return MilkRegistry.isMilkRegistered() && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

