/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.overlord.tools;

import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;
import the_fireplace.overlord.Overlord;
import the_fireplace.overlord.items.ItemSkinsuit;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SkinType {
    private static final LinkedHashMap<SkinType, ResourceLocation> skintypes = Maps.newLinkedHashMap();
    public static final SkinType NONE = new SkinType(new ResourceLocation("missing"));
    public static final SkinType PLAYER = new SkinType(new ResourceLocation("textures/entity/steve.png"));
    public static final SkinType MUMMY = new SkinType(new ResourceLocation("textures/entity/zombie/husk.png"));

    public SkinType(ResourceLocation texLoc) {
        if (!skintypes.containsKey(this)) {
            skintypes.put(this, texLoc);
        } else {
            Overlord.logError("Skin type " + this.toString() + " is already registered! Skipping...", new Object[0]);
        }
    }

    public final boolean isNone() {
        return this.equals(NONE);
    }

    public boolean protectsFromSun() {
        return !this.isNone();
    }

    public final int ordinal() {
        return ArrayUtils.indexOf((Object[])skintypes.keySet().toArray(), (Object)this);
    }

    public static final SkinType get(int index) {
        return (SkinType)skintypes.keySet().toArray()[index];
    }

    public final ResourceLocation getTexture() {
        return skintypes.get(this);
    }

    public static final SkinType getSkinTypeFromStack(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemSkinsuit) {
            return ((ItemSkinsuit)stack.func_77973_b()).getType();
        }
        return NONE;
    }
}

