/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.LostWorldFilteredBiomeProvider;
import mcjty.lostcities.gui.GuiLostCityConfiguration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LostWorldType
extends WorldType {
    public LostWorldType() {
        super("lostcities");
    }

    public LostWorldType(String name) {
        super(name);
    }

    public static LostCityProfile getProfile(World world) {
        LostCityProfile p;
        LostCityProfile profile;
        if (world.field_73011_w.getDimension() == LostCityConfiguration.DIMENSION_ID && (profile = LostCityConfiguration.profiles.get(LostCityConfiguration.DIMENSION_PROFILE)) != null) {
            return profile;
        }
        String generatorOptions = world.func_72912_H().func_82571_y();
        if (generatorOptions == null || generatorOptions.trim().isEmpty()) {
            p = LostCityConfiguration.profiles.get(LostCityConfiguration.DEFAULT_PROFILE);
            if (p == null) {
                throw new RuntimeException("Something went wrong! Profile '" + LostCityConfiguration.DEFAULT_PROFILE + "' is missing!");
            }
        } else {
            JsonParser parser = new JsonParser();
            JsonElement parsed = parser.parse(generatorOptions);
            String profileName = parsed.getAsJsonObject().has("profile") ? parsed.getAsJsonObject().get("profile").getAsString() : LostCityConfiguration.DEFAULT_PROFILE;
            p = LostCityConfiguration.profiles.get(profileName);
            if (p == null) {
                throw new RuntimeException("Something went wrong! Profile '" + profileName + "' is missing!");
            }
        }
        return p;
    }

    public IChunkGenerator getChunkGenerator(World world, String generatorOptions) {
        return new LostCityChunkGenerator(world, world.func_72905_C());
    }

    public BiomeProvider getBiomeProvider(World world) {
        LostCityProfile profile = LostWorldType.getProfile(world);
        if (profile.ALLOWED_BIOME_FACTORS.length == 0) {
            return super.getBiomeProvider(world);
        }
        return new LostWorldFilteredBiomeProvider(super.getBiomeProvider(world), profile.ALLOWED_BIOME_FACTORS);
    }

    public boolean isCustomizable() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onCustomizeButton(Minecraft mc, GuiCreateWorld guiCreateWorld) {
        mc.func_147108_a((GuiScreen)new GuiLostCityConfiguration(guiCreateWorld));
    }
}

