/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mcjty.lostcities.dimensions.world.LostCitiesTerrainGenerator;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.lost.BuildingInfo;
import mcjty.lostcities.dimensions.world.lost.Explosion;
import mcjty.lostcities.dimensions.world.lost.cityassets.CompiledPalette;
import mcjty.lostcities.varia.GeometryTools;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class DamageArea {
    public static final float BLOCK_DAMAGE_CHANCE = 0.7f;
    private final long seed;
    private final int chunkX;
    private final int chunkZ;
    private final List<Explosion> explosions = new ArrayList<Explosion>();
    private final AxisAlignedBB chunkBox;

    public DamageArea(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        this.seed = provider.seed;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.chunkBox = new AxisAlignedBB((double)(chunkX * 16), 0.0, (double)(chunkZ * 16), (double)(chunkX * 16 + 15), 256.0, (double)(chunkZ * 16 + 15));
        Random rand = new Random(this.seed + (long)chunkZ * 295075153L + (long)chunkX * 899826547L);
        rand.nextFloat();
        rand.nextFloat();
        int offset = (Math.max(provider.profile.EXPLOSION_MAXRADIUS, provider.profile.MINI_EXPLOSION_MAXRADIUS) + 15) / 16;
        for (int cx = chunkX - offset; cx <= chunkX + offset; ++cx) {
            for (int cz = chunkZ - offset; cz <= chunkZ + offset; ++cz) {
                Float chance;
                if (provider.profile.EXPLOSIONS_IN_CITIES_ONLY && !BuildingInfo.isCity(cx, cz, provider)) continue;
                Explosion explosion = this.getExplosionAt(cx, cz, provider);
                if (explosion != null && this.intersectsWith(explosion.getCenter(), explosion.getRadius())) {
                    BuildingInfo.getBuildingInfo(cx, cz, provider);
                    chance = BuildingInfo.getChunkCharacteristics((int)cx, (int)cz, (LostCityChunkGenerator)provider).cityStyle.getExplosionChance();
                    if (chance == null || rand.nextFloat() < chance.floatValue()) {
                        this.explosions.add(explosion);
                    }
                }
                if ((explosion = this.getMiniExplosionAt(cx, cz, provider)) == null || !this.intersectsWith(explosion.getCenter(), explosion.getRadius())) continue;
                BuildingInfo.getBuildingInfo(cx, cz, provider);
                chance = BuildingInfo.getChunkCharacteristics((int)cx, (int)cz, (LostCityChunkGenerator)provider).cityStyle.getExplosionChance();
                if (chance != null && !(rand.nextFloat() < chance.floatValue())) continue;
                this.explosions.add(explosion);
            }
        }
    }

    public Character damageBlock(Character b, LostCityChunkGenerator provider, int y, float damage, CompiledPalette palette) {
        if (b.charValue() == LostCitiesTerrainGenerator.bedrockChar || b.charValue() == LostCitiesTerrainGenerator.endportalChar || b.charValue() == LostCitiesTerrainGenerator.endportalFrameChar) {
            return b;
        }
        if (LostCitiesTerrainGenerator.getGlassChars().contains(b)) {
            damage *= 2.5f;
        }
        if (provider.rand.nextFloat() <= damage) {
            Character damaged = palette.canBeDamagedToIronBars(b);
            b = damage < 0.7f && damaged != null ? (provider.rand.nextFloat() < 0.7f ? damaged : Character.valueOf(y < provider.profile.WATERLEVEL ? LostCitiesTerrainGenerator.liquidChar : LostCitiesTerrainGenerator.airChar)) : Character.valueOf(y < provider.profile.WATERLEVEL ? LostCitiesTerrainGenerator.liquidChar : LostCitiesTerrainGenerator.airChar);
        }
        return b;
    }

    private boolean intersectsWith(BlockPos center, int radius) {
        double dmin = GeometryTools.squaredDistanceBoxPoint(this.chunkBox, center);
        return dmin <= (double)(radius * radius);
    }

    private Explosion getExplosionAt(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        Random rand = new Random(this.seed + (long)chunkZ * 295075153L + (long)chunkX * 797003437L);
        rand.nextFloat();
        rand.nextFloat();
        if (rand.nextFloat() < provider.profile.EXPLOSION_CHANCE) {
            return new Explosion(provider.profile.EXPLOSION_MINRADIUS + rand.nextInt(provider.profile.EXPLOSION_MAXRADIUS - provider.profile.EXPLOSION_MINRADIUS), new BlockPos(chunkX * 16 + rand.nextInt(16), BuildingInfo.getBuildingInfo((int)chunkX, (int)chunkZ, (LostCityChunkGenerator)provider).cityLevel * 6 + provider.profile.EXPLOSION_MINHEIGHT + rand.nextInt(provider.profile.EXPLOSION_MAXHEIGHT - provider.profile.EXPLOSION_MINHEIGHT), chunkZ * 16 + rand.nextInt(16)));
        }
        return null;
    }

    private Explosion getMiniExplosionAt(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        Random rand = new Random(this.seed + (long)chunkZ * 1400305337L + (long)chunkX * 573259391L);
        rand.nextFloat();
        rand.nextFloat();
        if (rand.nextFloat() < provider.profile.MINI_EXPLOSION_CHANCE) {
            return new Explosion(provider.profile.MINI_EXPLOSION_MINRADIUS + rand.nextInt(provider.profile.MINI_EXPLOSION_MAXRADIUS - provider.profile.MINI_EXPLOSION_MINRADIUS), new BlockPos(chunkX * 16 + rand.nextInt(16), BuildingInfo.getBuildingInfo((int)chunkX, (int)chunkZ, (LostCityChunkGenerator)provider).cityLevel * 6 + provider.profile.MINI_EXPLOSION_MINHEIGHT + rand.nextInt(provider.profile.MINI_EXPLOSION_MAXHEIGHT - provider.profile.MINI_EXPLOSION_MINHEIGHT), chunkZ * 16 + rand.nextInt(16)));
        }
        return null;
    }

    public boolean hasExplosions() {
        return !this.explosions.isEmpty();
    }

    public List<Explosion> getExplosions() {
        return this.explosions;
    }

    public boolean hasExplosions(int y) {
        AxisAlignedBB box = new AxisAlignedBB((double)(this.chunkX * 16), (double)(y * 16), (double)(this.chunkZ * 16), (double)(this.chunkX * 16 + 15), (double)(y * 16 + 15), (double)(this.chunkZ * 16 + 15));
        for (Explosion explosion : this.explosions) {
            double dmin = GeometryTools.squaredDistanceBoxPoint(box, explosion.getCenter());
            if (!(dmin <= (double)(explosion.getRadius() * explosion.getRadius()))) continue;
            return true;
        }
        return false;
    }

    public boolean isCompletelyDestroyed(int y) {
        AxisAlignedBB box = new AxisAlignedBB((double)(this.chunkX * 16), (double)(y * 16), (double)(this.chunkZ * 16), (double)(this.chunkX * 16 + 15), (double)(y * 16 + 15), (double)(this.chunkZ * 16 + 15));
        for (Explosion explosion : this.explosions) {
            int sqdist;
            double dmax = GeometryTools.maxSquaredDistanceBoxPoint(box, explosion.getCenter());
            if (!(dmax <= (double)(sqdist = explosion.getRadius() * explosion.getRadius()))) continue;
            double dist = ((double)explosion.getRadius() - 3.0 * (double)explosion.getRadius()) / -3.0;
            if (!(dmax <= (dist *= dist))) continue;
            return true;
        }
        return false;
    }

    public int getLowestExplosionHeight() {
        for (int yy = 0; yy < 16; ++yy) {
            if (!this.hasExplosions(yy)) continue;
            return yy * 16;
        }
        return -1;
    }

    public int getHighestExplosionHeight() {
        for (int yy = 15; yy >= 0; --yy) {
            if (!this.hasExplosions(yy)) continue;
            return yy * 16 + 15;
        }
        return -1;
    }

    public float getDamageFactor() {
        float damage = 0.0f;
        for (Explosion explosion : this.explosions) {
            double sq = explosion.getCenter().func_177954_c((double)(this.chunkX * 16), (double)explosion.getCenter().func_177956_o(), (double)(this.chunkZ * 16));
            if (!(sq < (double)explosion.getSqradius())) continue;
            double d = Math.sqrt(sq);
            damage = (float)((double)damage + 3.0 * ((double)explosion.getRadius() - d) / (double)explosion.getRadius());
        }
        return damage;
    }

    public float getDamage(int x, int y, int z) {
        float damage = 0.0f;
        for (Explosion explosion : this.explosions) {
            double sq = explosion.getCenter().func_177954_c((double)x, (double)y, (double)z);
            if (!(sq < (double)explosion.getSqradius())) continue;
            double d = Math.sqrt(sq);
            damage = (float)((double)damage + 3.0 * ((double)explosion.getRadius() - d) / (double)explosion.getRadius());
        }
        return damage;
    }
}

