/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.lost.BuildingInfo;
import mcjty.lostcities.dimensions.world.lost.Orientation;
import mcjty.lostcities.varia.ChunkCoord;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class Highway {
    private static NoiseGeneratorPerlin perlinX = null;
    private static NoiseGeneratorPerlin perlinZ = null;
    private static Map<ChunkCoord, Integer> xHighwayLevelCache = new HashMap<ChunkCoord, Integer>();
    private static Map<ChunkCoord, Integer> zHighwayLevelCache = new HashMap<ChunkCoord, Integer>();

    private static void makePerlin(long seed) {
        Random random;
        if (perlinX == null) {
            random = new Random(seed);
            perlinX = new NoiseGeneratorPerlin(random, 4);
        }
        if (perlinZ == null) {
            random = new Random(seed ^ 0x346762DBL);
            perlinZ = new NoiseGeneratorPerlin(random, 4);
        }
    }

    public static void cleanCache() {
        perlinX = null;
        perlinZ = null;
        xHighwayLevelCache.clear();
        zHighwayLevelCache.clear();
    }

    public static int getXHighwayLevel(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        return Highway.getHighwayLevel(provider, xHighwayLevelCache, cp -> Highway.hasXHighway(cp, provider), Orientation.X, new ChunkCoord(provider.dimensionId, chunkX, chunkZ));
    }

    public static int getZHighwayLevel(int chunkX, int chunkZ, LostCityChunkGenerator provider) {
        return Highway.getHighwayLevel(provider, zHighwayLevelCache, cp -> Highway.hasZHighway(cp, provider), Orientation.Z, new ChunkCoord(provider.dimensionId, chunkX, chunkZ));
    }

    private static int getHighwayLevel(LostCityChunkGenerator provider, Map<ChunkCoord, Integer> cache, Function<ChunkCoord, Boolean> hasHighway, Orientation orientation, ChunkCoord cp) {
        if (cache.containsKey(cp)) {
            return cache.get(cp);
        }
        if ((cp.getCoord(orientation.getOpposite()) & 7) != 0) {
            cache.put(cp, -1);
            return -1;
        }
        Highway.makePerlin(provider.seed);
        if (hasHighway.apply(cp).booleanValue()) {
            ChunkCoord lower = cp.lower(orientation);
            while (hasHighway.apply(lower).booleanValue()) {
                lower = lower.lower(orientation);
            }
            lower = lower.higher(orientation);
            ChunkCoord higher = cp.higher(orientation);
            while (hasHighway.apply(higher).booleanValue()) {
                higher = higher.higher(orientation);
            }
            higher = higher.lower(orientation);
            int level = -1;
            if (higher.getCoord(orientation) - lower.getCoord(orientation) >= 5) {
                boolean valid;
                if (provider.profile.HIGHWAY_REQUIRES_TWO_CITIES) {
                    valid = BuildingInfo.isCityRaw(lower.getChunkX(), lower.getChunkZ(), provider) && BuildingInfo.isCityRaw(higher.getChunkX(), higher.getChunkZ(), provider);
                } else {
                    boolean bl = valid = BuildingInfo.isCityRaw(lower.getChunkX(), lower.getChunkZ(), provider) || BuildingInfo.isCityRaw(higher.getChunkX(), higher.getChunkZ(), provider);
                }
                if (valid) {
                    switch (provider.profile.HIGHWAY_LEVEL_FROM_CITIES_MODE) {
                        case 0: {
                            level = BuildingInfo.getCityLevel(lower.getChunkX(), lower.getChunkZ(), provider);
                            break;
                        }
                        case 1: {
                            level = Math.min(BuildingInfo.getCityLevel(lower.getChunkX(), lower.getChunkZ(), provider), BuildingInfo.getCityLevel(higher.getChunkX(), higher.getChunkZ(), provider));
                            break;
                        }
                        case 2: {
                            level = Math.max(BuildingInfo.getCityLevel(lower.getChunkX(), lower.getChunkZ(), provider), BuildingInfo.getCityLevel(higher.getChunkX(), higher.getChunkZ(), provider));
                            break;
                        }
                        case 3: {
                            level = (BuildingInfo.getCityLevel(lower.getChunkX(), lower.getChunkZ(), provider) + BuildingInfo.getCityLevel(higher.getChunkX(), higher.getChunkZ(), provider)) / 2;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Bad value for 'highwayLevelFromCities'!");
                        }
                    }
                    ChunkCoord cc = lower;
                    while (cc.getCoord(orientation) <= higher.getCoord(orientation)) {
                        cache.put(cc, level);
                        cc = cc.higher(orientation);
                    }
                }
            }
            return level;
        }
        cache.put(cp, -1);
        return -1;
    }

    private static boolean hasXHighway(ChunkCoord cp, LostCityChunkGenerator provider) {
        return perlinX.func_151601_a((double)((float)cp.getChunkX() / provider.profile.HIGHWAY_MAINPERLIN_SCALE), (double)((float)cp.getChunkZ() / provider.profile.HIGHWAY_SECONDARYPERLIN_SCALE)) > (double)provider.profile.HIGHWAY_PERLIN_FACTOR;
    }

    private static boolean hasZHighway(ChunkCoord cp, LostCityChunkGenerator provider) {
        return perlinZ.func_151601_a((double)((float)cp.getChunkX() / provider.profile.HIGHWAY_SECONDARYPERLIN_SCALE), (double)((float)cp.getChunkZ() / provider.profile.HIGHWAY_MAINPERLIN_SCALE)) > (double)provider.profile.HIGHWAY_PERLIN_FACTOR;
    }
}

