/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost.cityassets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import mcjty.lostcities.api.ILostCityAsset;
import mcjty.lostcities.dimensions.world.lost.BuildingInfo;
import mcjty.lostcities.dimensions.world.lost.cityassets.Palette;
import org.apache.commons.lang3.StringUtils;

public class BuildingPart
implements ILostCityAsset {
    private String name;
    private String[] slices;
    private int xSize;
    private int zSize;
    private char[][] vslices = null;
    private Palette localPalette = null;
    private Map<String, Object> metadata = new HashMap<String, Object>();

    public BuildingPart(JsonObject object) {
        this.readFromJSon(object);
    }

    public BuildingPart(String name, int xSize, int zSize, String[] slices) {
        this.name = name;
        this.slices = slices;
        this.xSize = xSize;
        this.zSize = zSize;
    }

    public Character getMetaChar(String key) {
        return (Character)this.metadata.get(key);
    }

    public Integer getMetaInteger(String key) {
        return (Integer)this.metadata.get(key);
    }

    public boolean getMetaBoolean(String key) {
        Object o = this.metadata.get(key);
        return o instanceof Boolean ? (Boolean)o : false;
    }

    public Float getMetaFloat(String key) {
        return (Float)this.metadata.get(key);
    }

    public String getMetaString(String key) {
        return (String)this.metadata.get(key);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public char[][] getVslices() {
        if (this.vslices == null) {
            this.vslices = new char[this.xSize * this.zSize][];
            for (int x = 0; x < this.xSize; ++x) {
                for (int z = 0; z < this.zSize; ++z) {
                    String vs = "";
                    boolean empty = true;
                    for (int y = 0; y < this.slices.length; ++y) {
                        Character c = this.getC(x, y, z);
                        vs = vs + c;
                        if (c.charValue() == ' ') continue;
                        empty = false;
                    }
                    this.vslices[z * this.xSize + x] = (char[])(empty ? null : vs.toCharArray());
                }
            }
        }
        return this.vslices;
    }

    public char[] getVSlice(int x, int z) {
        return this.getVslices()[z * this.xSize + x];
    }

    public Palette getLocalPalette() {
        return this.localPalette;
    }

    @Override
    public void readFromJSon(JsonObject object) {
        this.name = object.get("name").getAsString();
        this.xSize = object.get("xsize").getAsInt();
        this.zSize = object.get("zsize").getAsInt();
        JsonArray sliceArray = object.get("slices").getAsJsonArray();
        this.slices = new String[sliceArray.size()];
        int i = 0;
        for (JsonElement element : sliceArray) {
            JsonArray a = element.getAsJsonArray();
            String slice = "";
            for (JsonElement el : a) {
                slice = slice + el.getAsString();
            }
            this.slices[i++] = slice;
        }
        if (object.has("palette")) {
            JsonArray palette = object.get("palette").getAsJsonArray();
            this.localPalette = new Palette();
            this.localPalette.parsePaletteArray(palette);
        }
        if (object.has("meta")) {
            JsonArray metaArray = object.get("meta").getAsJsonArray();
            for (JsonElement element : metaArray) {
                JsonObject o = element.getAsJsonObject();
                String key = o.get("key").getAsString();
                if (o.has("integer")) {
                    this.metadata.put(key, o.get("integer").getAsInt());
                    continue;
                }
                if (o.has("float")) {
                    this.metadata.put(key, Float.valueOf(o.get("float").getAsFloat()));
                    continue;
                }
                if (o.has("boolean")) {
                    this.metadata.put(key, o.get("boolean").getAsBoolean());
                    continue;
                }
                if (o.has("char")) {
                    this.metadata.put(key, Character.valueOf(o.get("char").getAsCharacter()));
                    continue;
                }
                if (o.has("character")) {
                    this.metadata.put(key, Character.valueOf(o.get("character").getAsCharacter()));
                    continue;
                }
                if (!o.has("string")) continue;
                this.metadata.put(key, o.get("string").getAsString());
            }
        }
    }

    public JsonObject writeToJSon() {
        JsonObject object = new JsonObject();
        object.add("type", (JsonElement)new JsonPrimitive("part"));
        object.add("name", (JsonElement)new JsonPrimitive(this.name));
        object.add("xsize", (JsonElement)new JsonPrimitive((Number)this.xSize));
        object.add("zsize", (JsonElement)new JsonPrimitive((Number)this.zSize));
        JsonArray sliceArray = new JsonArray();
        for (String slice : this.slices) {
            JsonArray a = new JsonArray();
            while (!slice.isEmpty()) {
                String left = StringUtils.left((String)slice, (int)this.xSize);
                a.add((JsonElement)new JsonPrimitive(left));
                slice = slice.substring(left.length());
            }
            sliceArray.add((JsonElement)a);
        }
        object.add("slices", (JsonElement)sliceArray);
        JsonArray metaArray = new JsonArray();
        for (Map.Entry<String, Object> entry : this.metadata.entrySet()) {
            JsonObject o = new JsonObject();
            o.add("key", (JsonElement)new JsonPrimitive(entry.getKey()));
            Object v = entry.getValue();
            if (v instanceof Integer) {
                o.add("integer", (JsonElement)new JsonPrimitive((Number)((Integer)v)));
            } else if (v instanceof Float) {
                o.add("float", (JsonElement)new JsonPrimitive((Number)((Float)v)));
            } else if (v instanceof Boolean) {
                o.add("boolean", (JsonElement)new JsonPrimitive((Boolean)v));
            } else if (v instanceof String) {
                o.add("string", (JsonElement)new JsonPrimitive((String)v));
            }
            metaArray.add((JsonElement)o);
        }
        object.add("meta", (JsonElement)metaArray);
        return object;
    }

    public int getSliceCount() {
        return this.slices.length;
    }

    public String getSlice(int i) {
        return this.slices[i];
    }

    public String[] getSlices() {
        return this.slices;
    }

    public int getXSize() {
        return this.xSize;
    }

    public int getZSize() {
        return this.zSize;
    }

    public Character get(BuildingInfo info, int x, int y, int z) {
        return info.getCompiledPalette().get(this.slices[y].charAt(z * this.xSize + x));
    }

    public String getMobID(BuildingInfo info, int x, int y, int z) {
        return info.getCompiledPalette().getMobId(Character.valueOf(this.slices[y].charAt(z * this.xSize + x)));
    }

    public String getLootTable(BuildingInfo info, int x, int y, int z) {
        return info.getCompiledPalette().getLootTable(Character.valueOf(this.slices[y].charAt(z * this.xSize + x)));
    }

    public Character getC(int x, int y, int z) {
        return Character.valueOf(this.slices[y].charAt(z * this.xSize + x));
    }
}

