/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.dimensions.world.lost.cityassets;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mcjty.lostcities.dimensions.world.LostCitiesTerrainGenerator;
import mcjty.lostcities.dimensions.world.lost.cityassets.Palette;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import org.apache.commons.lang3.tuple.Pair;

public class CompiledPalette {
    private final Map<Character, Object> palette = new HashMap<Character, Object>();
    private final Map<Character, Character> damagedToBlock = new HashMap<Character, Character>();
    private final Map<Character, String> mobIds = new HashMap<Character, String>();
    private final Map<Character, String> lootTables = new HashMap<Character, String>();

    public CompiledPalette(CompiledPalette other, Palette ... palettes) {
        this.palette.putAll(other.palette);
        this.damagedToBlock.putAll(other.damagedToBlock);
        this.mobIds.putAll(other.mobIds);
        this.lootTables.putAll(other.lootTables);
        this.addPalettes(palettes);
    }

    public CompiledPalette(Palette ... palettes) {
        this.addPalettes(palettes);
    }

    private int addEntries(char[] randomBlocks, int idx, char c, int cnt) {
        for (int i = 0; i < cnt; ++i) {
            if (idx >= randomBlocks.length) {
                return idx;
            }
            randomBlocks[idx++] = c;
        }
        return idx;
    }

    public void addPalettes(Palette[] palettes) {
        for (Palette p : palettes) {
            for (Map.Entry<Character, Object> entry : p.palette.entrySet()) {
                Object object = entry.getValue();
                if (object instanceof IBlockState) {
                    this.palette.put(entry.getKey(), Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)((IBlockState)object))));
                    continue;
                }
                if (object instanceof Pair[]) {
                    Pair pair;
                    Pair[] r = (Pair[])object;
                    char[] randomBlocks = new char[128];
                    int idx = 0;
                    Pair[] pairArray = r;
                    int n = pairArray.length;
                    for (int i = 0; i < n && (idx = this.addEntries(randomBlocks, idx, (char)Block.field_176229_d.func_148747_b((pair = pairArray[i]).getRight()), (Integer)pair.getLeft())) < randomBlocks.length; ++i) {
                    }
                    this.palette.put(entry.getKey(), randomBlocks);
                    continue;
                }
                if (object instanceof String) continue;
                if (object == null) {
                    throw new RuntimeException("Invalid palette entry for '" + entry.getKey() + "'!");
                }
                this.palette.put(entry.getKey(), object);
            }
        }
        boolean dirty = true;
        while (dirty) {
            dirty = false;
            for (Palette p : palettes) {
                for (Map.Entry<Object, Object> entry : p.palette.entrySet()) {
                    char c;
                    Object value = entry.getValue();
                    if (!(value instanceof String) || !this.palette.containsKey(Character.valueOf(c = ((String)value).charAt(0))) || this.palette.containsKey(entry.getKey())) continue;
                    Object s = this.palette.get(Character.valueOf(c));
                    if (s instanceof IBlockState) {
                        s = Character.valueOf((char)Block.field_176229_d.func_148747_b((Object)((IBlockState)value)));
                    }
                    this.palette.put((Character)entry.getKey(), s);
                    dirty = true;
                }
            }
        }
        for (Palette p : palettes) {
            Object c;
            for (Map.Entry<Object, Object> entry : p.getDamaged().entrySet()) {
                c = (IBlockState)entry.getKey();
                this.damagedToBlock.put(Character.valueOf((char)Block.field_176229_d.func_148747_b(c)), Character.valueOf((char)Block.field_176229_d.func_148747_b(entry.getValue())));
            }
            for (Map.Entry<Object, Object> entry : p.getMobIds().entrySet()) {
                c = (Character)entry.getKey();
                this.mobIds.put((Character)c, (String)entry.getValue());
            }
            for (Map.Entry<Object, Object> entry : p.getLootTables().entrySet()) {
                c = (Character)entry.getKey();
                this.lootTables.put((Character)c, (String)entry.getValue());
            }
        }
    }

    public Set<Character> getCharacters() {
        return this.palette.keySet();
    }

    public IBlockState getStraight(char c) {
        try {
            Object o = this.palette.get(Character.valueOf(c));
            if (o instanceof IBlockState) {
                return (IBlockState)o;
            }
            if (o instanceof Character) {
                return (IBlockState)Block.field_176229_d.func_148745_a((int)((Character)o).charValue());
            }
            char[] randomBlocks = (char[])o;
            return (IBlockState)Block.field_176229_d.func_148745_a((int)randomBlocks[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isSimple(char c) {
        Object o = this.palette.get(Character.valueOf(c));
        return o instanceof Character;
    }

    public Character get(char c) {
        try {
            Object o = this.palette.get(Character.valueOf(c));
            if (o instanceof Character) {
                return (Character)o;
            }
            if (o == null) {
                return null;
            }
            char[] randomBlocks = (char[])o;
            return Character.valueOf(randomBlocks[LostCitiesTerrainGenerator.fastrand128()]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Character canBeDamagedToIronBars(Character b) {
        return this.damagedToBlock.get(b);
    }

    public String getMobId(Character c) {
        return this.mobIds.get(c);
    }

    public String getLootTable(Character c) {
        return this.lootTables.get(c);
    }
}

