/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.gui.GuiMutableLabel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiCreateWorld;
import net.minecraft.client.gui.GuiLabel;
import net.minecraft.client.gui.GuiScreen;

public class GuiLostCityConfiguration
extends GuiScreen {
    private final GuiCreateWorld parent;
    private Map<Integer, Runnable> actionHandler = new HashMap<Integer, Runnable>();
    private int page = 0;
    private int numpages;
    private GuiMutableLabel pagelabel;

    public GuiLostCityConfiguration(GuiCreateWorld parent) {
        this.parent = parent;
    }

    public void func_73866_w_() {
        JsonElement parsed;
        JsonParser parser = new JsonParser();
        String profileName = LostCityConfiguration.DEFAULT_PROFILE;
        if (this.parent.field_146334_a != null && !this.parent.field_146334_a.trim().isEmpty() && (parsed = parser.parse(this.parent.field_146334_a)).getAsJsonObject().has("profile")) {
            profileName = parsed.getAsJsonObject().get("profile").getAsString();
        }
        this.page = 0;
        this.numpages = (LostCityConfiguration.profiles.size() + 7) / 8;
        this.setupGui(profileName);
    }

    private void setupGui(String profileName) {
        this.actionHandler.clear();
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        int id = 301;
        int y = 8;
        int num = -1;
        int cnt = 0;
        ArrayList<String> profileKeys = new ArrayList<String>(LostCityConfiguration.profiles.keySet());
        profileKeys.sort(new Comparator<String>(){

            @Override
            public int compare(String s, String t1) {
                return s.compareTo(t1);
            }
        });
        for (String key : profileKeys) {
            LostCityProfile profile = LostCityConfiguration.profiles.get(key);
            if (++num < this.page * 8) continue;
            if (cnt >= 8) break;
            ++cnt;
            GuiButton button = new GuiButton(id, 10, y, 90, 20, key);
            if (profileName.equals(profile.getName())) {
                button.packedFGColour = -256;
            }
            this.field_146292_n.add(button);
            this.actionHandler.put(id, () -> this.setProfile(profile));
            int n = ++id;
            ++id;
            GuiLabel label = new GuiLabel(Minecraft.func_71410_x().field_71466_p, n, 110, y, 230, 20, -1);
            label.func_175202_a(profile.getDescription());
            this.field_146293_o.add(label);
            y += 22;
        }
        y = 200;
        GuiLabel label = new GuiLabel(Minecraft.func_71410_x().field_71466_p, id++, 20, y, 340, 20, -1);
        label.func_175202_a("(note, you can create your own profiles and many more");
        label.func_175202_a("configuration options in 'lostcities.cfg')");
        this.field_146293_o.add(label);
        if (this.numpages > 1) {
            GuiButton prev = new GuiButton(id, 330, y, 20, 19, "<");
            this.field_146292_n.add(prev);
            this.actionHandler.put(id, () -> {
                this.page = this.page > 0 ? this.page - 1 : this.page;
                this.setupGui(profileName);
            });
            int n = ++id;
            this.pagelabel = new GuiMutableLabel(Minecraft.func_71410_x().field_71466_p, n, 360, y, 30, 20, -1);
            this.pagelabel.addLine("" + (this.page + 1) + "/" + this.numpages);
            GuiButton next = new GuiButton(++id, 390, y, 20, 19, ">");
            this.field_146292_n.add(next);
            this.actionHandler.put(id, () -> {
                this.page = this.page < this.numpages - 1 ? this.page + 1 : this.page;
                this.setupGui(profileName);
            });
            ++id;
        }
    }

    private void setProfile(LostCityProfile profile) {
        this.parent.field_146334_a = "{ \"profile\": \"" + profile.getName() + "\" }";
        this.field_146297_k.func_147108_a((GuiScreen)this.parent);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (this.actionHandler.containsKey(button.field_146127_k)) {
            this.actionHandler.get(button.field_146127_k).run();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.numpages > 1) {
            this.pagelabel.clearLines();
            this.pagelabel.addLine("" + (this.page + 1) + "/" + this.numpages);
            this.pagelabel.drawLabel(Minecraft.func_71410_x(), mouseX, mouseY);
        }
    }
}

