/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.proxy;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import mcjty.lostcities.ForgeEventHandlers;
import mcjty.lostcities.LostCities;
import mcjty.lostcities.config.LostCityConfiguration;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.dimensions.ModDimensions;
import mcjty.lostcities.dimensions.world.lost.cityassets.AssetRegistries;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.apache.logging.log4j.Level;

public abstract class CommonProxy {
    public static File modConfigDir;
    private Configuration mainConfig;
    private List<Configuration> profileConfigs = new ArrayList<Configuration>();

    public void preInit(FMLPreInitializationEvent e) {
        modConfigDir = e.getModConfigurationDirectory();
        this.mainConfig = new Configuration(new File(modConfigDir.getPath() + File.separator + "lostcities", "general.cfg"));
        this.readMainConfig();
        ModDimensions.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readMainConfig() {
        Configuration cfg = this.mainConfig;
        try {
            String[] profileList;
            cfg.load();
            for (String name : profileList = LostCityConfiguration.init(cfg)) {
                LostCityProfile profile = new LostCityProfile(name, LostCityConfiguration.standardProfiles.get(name));
                Configuration profileCfg = new Configuration(new File(modConfigDir.getPath() + File.separator + "lostcities", "profile_" + name + ".cfg"));
                profileCfg.load();
                profile.init(profileCfg);
                LostCityConfiguration.profiles.put(name, profile);
                this.profileConfigs.add(profileCfg);
            }
        }
        catch (Exception e1) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e1, (String)"Problem loading config file!", (Object[])new Object[0]);
        }
        finally {
            this.saveConfigs();
        }
    }

    private void saveConfigs() {
        if (this.mainConfig.hasChanged()) {
            this.mainConfig.save();
        }
        for (Configuration config : this.profileConfigs) {
            if (!config.hasChanged()) continue;
            config.save();
        }
    }

    public void init(FMLInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new ForgeEventHandlers());
    }

    public void postInit(FMLPostInitializationEvent e) {
        this.saveConfigs();
        this.mainConfig = null;
        this.profileConfigs.clear();
        AssetRegistries.reset();
        for (String path : LostCityConfiguration.ASSETS) {
            if (path.startsWith("/")) {
                InputStream inputstream = LostCities.class.getResourceAsStream(path);
                AssetRegistries.load(inputstream, path);
                continue;
            }
            if (path.startsWith("$")) {
                File file = new File(modConfigDir.getPath() + File.separator + path.substring(1));
                AssetRegistries.load(file);
                continue;
            }
            throw new RuntimeException("Invalid path for lostcity resource in 'assets' config!");
        }
        System.out.println("Asset parts loaded: " + AssetRegistries.PARTS.getCount());
    }
}

