/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum;

import blusunrize.immersiveengineering.common.Config;
import flaxbeard.immersivepetroleum.api.crafting.DistillationRecipe;
import flaxbeard.immersivepetroleum.api.crafting.PumpjackHandler;
import flaxbeard.immersivepetroleum.api.energy.FuelHandler;
import flaxbeard.immersivepetroleum.common.CommonProxy;
import flaxbeard.immersivepetroleum.common.Config;
import flaxbeard.immersivepetroleum.common.IPContent;
import flaxbeard.immersivepetroleum.common.IPSaveData;
import flaxbeard.immersivepetroleum.common.network.IPPacketHandler;
import flaxbeard.immersivepetroleum.common.util.CommandHandler;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="immersivepetroleum", version="1.1.3", dependencies="required-after:immersiveengineering;", acceptedMinecraftVersions="[1.12]")
public class ImmersivePetroleum {
    public static final String MODID = "immersivepetroleum";
    public static final String VERSION = "1.1.3";
    @SidedProxy(clientSide="flaxbeard.immersivepetroleum.client.ClientProxy", serverSide="flaxbeard.immersivepetroleum.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="immersivepetroleum")
    public static ImmersivePetroleum INSTANCE;
    public static CreativeTabs creativeTab;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        IPContent.preInit();
        proxy.preInit();
        proxy.preInitEnd();
        IPPacketHandler.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        DistillationRecipe.energyModifier = Config.IPConfig.Refining.distillationTower_energyModifier;
        DistillationRecipe.timeModifier = Config.IPConfig.Refining.distillationTower_timeModifier;
        PumpjackHandler.oilChance = Config.IPConfig.Extraction.reservoir_chance;
        Config.manual_int.put("distillationTower_operationCost", (int)(2048.0f * Config.IPConfig.Refining.distillationTower_energyModifier));
        Config.manual_int.put("pumpjack_consumption", Config.IPConfig.Extraction.pumpjack_consumption);
        Config.manual_int.put("pumpjack_speed", Config.IPConfig.Extraction.pumpjack_speed);
        int oil_min = 1000000;
        int oil_max = 5000000;
        for (PumpjackHandler.ReservoirType type : PumpjackHandler.reservoirList.keySet()) {
            if (!type.name.equals("oil")) continue;
            oil_min = type.minSize;
            oil_max = type.maxSize;
            break;
        }
        Config.manual_int.put("pumpjack_days", ((oil_max + oil_min) / 2 + oil_min) / (Config.IPConfig.Extraction.pumpjack_speed * 24000));
        Config.manual_double.put("autoLubricant_speedup", 1.25);
        IPContent.init();
        HashMap<String, Integer> map = FuelHandler.getFuelFluxesPerTick();
        if (map.size() > 0 && map.containsKey("gasoline")) {
            Config.manual_int.put("portableGenerator_flux", map.get("gasoline"));
        } else {
            Config.manual_int.put("portableGenerator_flux", -1);
        }
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, (IGuiHandler)proxy);
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        PumpjackHandler.recalculateChances(true);
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            World world = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
            if (!world.field_72995_K) {
                IPSaveData worldData = (IPSaveData)world.func_72943_a(IPSaveData.class, "ImmersivePetroleum-SaveData");
                if (worldData == null) {
                    worldData = new IPSaveData("ImmersivePetroleum-SaveData");
                    world.func_72823_a("ImmersivePetroleum-SaveData", (WorldSavedData)worldData);
                }
                IPSaveData.setInstance(world.field_73011_w.getDimension(), worldData);
            }
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandHandler());
    }

    static {
        FluidRegistry.enableUniversalBucket();
        creativeTab = new CreativeTabs(MODID){

            public ItemStack func_78016_d() {
                return ItemStack.field_190927_a;
            }

            public ItemStack func_151244_d() {
                UniversalBucket bucket = ForgeModContainer.getInstance().universalBucket;
                ItemStack stack = new ItemStack((Item)bucket);
                FluidBucketWrapper fluidHandler = new FluidBucketWrapper(stack);
                FluidStack fs = new FluidStack(IPContent.fluidCrudeOil, bucket.getCapacity());
                if (fluidHandler.fill(fs, true) == fs.amount) {
                    return fluidHandler.getContainer();
                }
                return new ItemStack((Block)IPContent.blockFluidDiesel, 1, 0);
            }

            @SideOnly(value=Side.CLIENT)
            public void func_78018_a(NonNullList<ItemStack> list) {
                UniversalBucket bucket = ForgeModContainer.getInstance().universalBucket;
                ItemStack stack = new ItemStack((Item)bucket);
                FluidBucketWrapper fluidHandler = new FluidBucketWrapper(stack);
                FluidStack fs = new FluidStack(IPContent.fluidCrudeOil, bucket.getCapacity());
                if (fluidHandler.fill(fs, true) == fs.amount) {
                    list.add((Object)fluidHandler.getContainer());
                }
                if ((fluidHandler = new FluidBucketWrapper(stack = new ItemStack((Item)bucket))).fill(fs = new FluidStack(IPContent.fluidDiesel, bucket.getCapacity()), true) == fs.amount) {
                    list.add((Object)fluidHandler.getContainer());
                }
                if ((fluidHandler = new FluidBucketWrapper(stack = new ItemStack((Item)bucket))).fill(fs = new FluidStack(IPContent.fluidGasoline, bucket.getCapacity()), true) == fs.amount) {
                    list.add((Object)fluidHandler.getContainer());
                }
                if ((fluidHandler = new FluidBucketWrapper(stack = new ItemStack((Item)bucket))).fill(fs = new FluidStack(IPContent.fluidLubricant, bucket.getCapacity()), true) == fs.amount) {
                    list.add((Object)fluidHandler.getContainer());
                }
                super.func_78018_a(list);
            }
        };
    }
}

