/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.backend.entries;

import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.backend.XUItemBlock;
import com.rwtema.extrautils2.backend.entries.Entry;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.ItemEntry;
import com.rwtema.extrautils2.compatibility.CompatHelper112;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.tile.tesr.ITESRHook;
import com.rwtema.extrautils2.tile.tesr.ITESRHookSimple;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BlockEntry<T extends XUBlock>
extends Entry<T>
implements IItemStackMaker {
    public static final HashMap<Class<? extends TileEntity>, XUBlock> tileToBlockMap = new HashMap();
    public static final HashMultimap<Class<? extends TileEntity>, Block> tileToBlocksMap = HashMultimap.create();
    public Class<? extends TileEntity>[] teClazzes;
    public Class<? extends ItemBlock> itemClass = XUItemBlock.class;
    public static HashMap<ResourceLocation, Block> blockMap = new HashMap();

    @SafeVarargs
    public BlockEntry(String name, Class<? extends TileEntity> ... teClazzes) {
        super(name);
        this.teClazzes = teClazzes;
    }

    public static void registerTile(Class<? extends TileEntity> teClazz) {
        if (ITESRHookSimple.class.isAssignableFrom(teClazz)) {
            ExtraUtils2.proxy.registerTESROther(teClazz);
        } else if (ITESRHook.class.isAssignableFrom(teClazz)) {
            ExtraUtils2.proxy.registerTESR(teClazz);
        }
        GameRegistry.registerTileEntity(teClazz, (String)("XU2:" + teClazz.getSimpleName()));
    }

    public static <T extends XUBlock> Pair<T, ItemBlock> registerBlockItemCombo(T value, Class<? extends ItemBlock> itemClass, String name) {
        ResourceLocation location = new ResourceLocation("extrautils2:" + name.toLowerCase(Locale.ENGLISH));
        value.setRegistryName(location);
        CompatHelper112.register(value);
        blockMap.put(location, value);
        if (itemClass != null) {
            try {
                ItemBlock itemBlock = itemClass.getConstructor(Block.class).newInstance(value);
                itemBlock.setRegistryName(location);
                CompatHelper112.register(itemBlock);
                ItemEntry.itemMap.put(location, (Item)itemBlock);
                return Pair.of(value, (Object)itemBlock);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return Pair.of(value, null);
    }

    public <K extends BlockEntry<T>> K setItemClass(Class<? extends ItemBlock> clazz) {
        this.itemClass = clazz;
        return (K)this;
    }

    @Override
    public void preInitRegister() {
        ((XUBlock)this.value).setBlockName("extrautils2:" + this.name.toLowerCase(Locale.ENGLISH));
        BlockEntry.registerBlockItemCombo((XUBlock)this.value, this.itemClass, this.name);
        for (Class<? extends TileEntity> teClazz : this.teClazzes) {
            tileToBlockMap.putIfAbsent(teClazz, (XUBlock)this.value);
            tileToBlocksMap.put(teClazz, this.value);
            BlockEntry.registerTile(teClazz);
        }
    }

    @Override
    public ItemStack newStack(int amount, int meta) {
        if (this.value == null || this.itemClass == null) {
            return StackHelper.empty();
        }
        return new ItemStack((Block)this.value, amount, meta);
    }

    public ItemStack newStack(int amount, IBlockState state) {
        if (this.value == null || this.itemClass == null) {
            return StackHelper.empty();
        }
        return this.newStack(amount, ((XUBlock)this.value).xuBlockState.getDropMetaFromState(state));
    }

    public ItemStack newStack(int amount, Object ... properties) {
        if (this.value == null || this.itemClass == null) {
            return StackHelper.empty();
        }
        IBlockState state = ((XUBlock)this.value).func_176223_P();
        for (int i = 0; i < properties.length; i += 2) {
            state = state.func_177226_a((IProperty)properties[i], (Comparable)properties[i + 1]);
        }
        return this.newStack(amount, state);
    }
}

