/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.crafting.jei;

import com.rwtema.extrautils2.compatibility.CompatClientHelper;
import com.rwtema.extrautils2.crafting.jei.PatternRecipe;
import com.rwtema.extrautils2.crafting.jei.XUJEIPlugin;
import com.rwtema.extrautils2.render.IVertexBuffer;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.MCTimer;
import com.rwtema.extrautils2.utils.client.GLStateAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeCategory;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;

public class BlockPatternHandler {
    public static final String uid = "extrautils2.blockPatterns";
    public static IRecipeCategory category = new BlankRecipeCategory(){
        public static final int recipeWidth = 160;
        public static final int recipeHeight = 160;
        IDrawable background = XUJEIPlugin.jeiHelpers.getGuiHelper().createBlankDrawable(160, 160);

        @Nonnull
        public String getUid() {
            return BlockPatternHandler.uid;
        }

        @Nonnull
        public String getTitle() {
            return Lang.translate("Blocks");
        }

        @Nonnull
        public String getModName() {
            return "extrautils2";
        }

        @Nonnull
        public IDrawable getBackground() {
            return this.background;
        }

        @Nullable
        public IDrawable getIcon() {
            return null;
        }

        public void drawExtras(@Nonnull Minecraft minecraft) {
        }

        public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull IRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
        }
    };
    public static IRecipeHandler<PatternRecipe> handler = new IRecipeHandler<PatternRecipe>(){

        @Nonnull
        public Class<PatternRecipe> getRecipeClass() {
            return PatternRecipe.class;
        }

        @Nonnull
        public String getRecipeCategoryUid() {
            return BlockPatternHandler.uid;
        }

        @Nonnull
        public String getRecipeCategoryUid(@Nonnull PatternRecipe recipe) {
            return BlockPatternHandler.uid;
        }

        @Nonnull
        public IRecipeWrapper getRecipeWrapper(final @Nonnull PatternRecipe recipe) {
            return new BlankRecipeWrapper(){

                public void getIngredients(@Nonnull IIngredients ingredients) {
                    ingredients.setInputs(ItemStack.class, recipe.stacks);
                    ingredients.setOutputs(ItemStack.class, recipe.stacks);
                }

                public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
                    ArrayList<BlockPos> toRender = new ArrayList<BlockPos>(recipe.toRender);
                    if (toRender.isEmpty()) {
                        return;
                    }
                    float angle = MCTimer.renderTimer * 45.0f / 12.0f;
                    double c = MathHelper.func_76134_b((float)((float)(Math.PI * (double)angle / 180.0)));
                    double s = MathHelper.func_76126_a((float)((float)(Math.PI * (double)angle / 180.0)));
                    Collections.sort(toRender, (o1, o2) -> -Double.compare((double)o1.func_177952_p() * c - (double)o1.func_177958_n() * s, (double)o2.func_177958_n() * c - (double)o2.func_177958_n() * s));
                    BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
                    GLStateAttributes states = GLStateAttributes.loadStates();
                    TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
                    textureManager.func_110577_a(TextureMap.field_110575_b);
                    textureManager.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
                    GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
                    GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179092_a((int)516, (float)0.1f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179106_n();
                    GlStateManager.func_179140_f();
                    RenderHelper.func_74518_a();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179141_d();
                    if (Minecraft.func_71379_u()) {
                        GlStateManager.func_179103_j((int)7425);
                    } else {
                        GlStateManager.func_179103_j((int)7424);
                    }
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)(recipeWidth / 2), (float)(recipeHeight / 2), (float)100.0f);
                    GlStateManager.func_179114_b((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179152_a((float)16.0f, (float)-16.0f, (float)16.0f);
                    Tessellator tessellator = Tessellator.func_178181_a();
                    IVertexBuffer buffer = IVertexBuffer.getVertexBuffer(tessellator);
                    BlockPos mn = recipe.min;
                    BlockPos mx = recipe.max;
                    GlStateManager.func_179089_o();
                    GlStateManager.func_179137_b((double)((double)(-(mn.func_177958_n() + mx.func_177958_n() + 1)) / 2.0), (double)((double)(-(mn.func_177956_o() + mx.func_177956_o() + 1)) / 2.0), (double)((double)(-(mn.func_177952_p() + mx.func_177952_p() + 1)) / 2.0));
                    buffer.begin(7, DefaultVertexFormats.field_176600_a);
                    GlStateManager.func_179118_c();
                    this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.SOLID, toRender);
                    GlStateManager.func_179141_d();
                    this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT_MIPPED, toRender);
                    this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.CUTOUT, toRender);
                    GlStateManager.func_179103_j((int)7425);
                    this.renderLayer(blockrendererdispatcher, buffer, BlockRenderLayer.TRANSLUCENT, toRender);
                    tessellator.func_78381_a();
                    GlStateManager.func_179121_F();
                    states.restore();
                }

                public void renderLayer(BlockRendererDispatcher blockrendererdispatcher, IVertexBuffer buffer, BlockRenderLayer renderLayer, List<BlockPos> toRender) {
                    for (BlockPos pos : toRender) {
                        IBlockState state = recipe.posMap.get(pos);
                        if (!state.func_177230_c().canRenderInLayer(state, renderLayer)) continue;
                        ForgeHooksClient.setRenderLayer((BlockRenderLayer)renderLayer);
                        try {
                            blockrendererdispatcher.func_175018_a(state, pos, recipe.blockAccess, CompatClientHelper.unwrap(buffer));
                        }
                        catch (Exception err) {
                            err.printStackTrace();
                        }
                        ForgeHooksClient.setRenderLayer(null);
                    }
                }

                @Nullable
                public List<String> getTooltipStrings(int mouseX, int mouseY) {
                    return Collections.emptyList();
                }

                public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
                    return false;
                }
            };
        }

        public boolean isRecipeValid(@Nonnull PatternRecipe recipe) {
            return true;
        }
    };
}

