/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.dimensions.deep_dark;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.compatibility.ChunkGeneratorCompat;
import com.rwtema.extrautils2.utils.helpers.BlockStates;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ChunkProviderDeepDark
implements ChunkGeneratorCompat {
    public static final int FLOOR_HEIGHT = 62;
    public static final int CEILING_HEIGHT = 120;
    static ImmutableSet<OreGenEvent.GenerateMinable.EventType> bannedOres = ImmutableSet.of((Object)OreGenEvent.GenerateMinable.EventType.DIRT, (Object)OreGenEvent.GenerateMinable.EventType.GRAVEL, (Object)OreGenEvent.GenerateMinable.EventType.ANDESITE, (Object)OreGenEvent.GenerateMinable.EventType.DIORITE, (Object)OreGenEvent.GenerateMinable.EventType.GRANITE);
    private final World world;
    private final List<MapGenStructure> structureGenerators = Lists.newArrayList();
    private final List<MapGenBase> generators = Lists.newArrayList();
    final ThreadLocal<Integer> seedOffset = ThreadLocal.withInitial(() -> 0);
    Random random = new Random();
    GenStates[] nextState;
    Biome[] biomes = null;
    private WorldGenLakes waterLakeGenerator;
    private WorldGenLakes lavaLakeGenerator;

    public ChunkProviderDeepDark(World worldIn, long seed) {
        int length = GenStates.values().length;
        this.nextState = new GenStates[length - 1];
        System.arraycopy(GenStates.values(), 1, this.nextState, 0, length - 1);
        this.world = worldIn;
        this.structureGenerators.add((MapGenStructure)new MapGenScatteredFeature());
        this.structureGenerators.add((MapGenStructure)new MapGenMineshaft());
        this.generators.add(TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE));
        this.generators.add(TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavine(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE));
        this.waterLakeGenerator = new WorldGenLakes((Block)Blocks.field_150355_j);
        this.lavaLakeGenerator = new WorldGenLakes((Block)Blocks.field_150353_l);
    }

    @SubscribeEvent
    public static void preventOres(OreGenEvent.GenerateMinable event) {
        OreGenEvent.GenerateMinable.EventType type = event.getType();
        if (bannedOres.contains((Object)type) && event.getWorld().field_73011_w.func_186058_p() == XU2Entries.deep_dark.value) {
            event.setResult(Event.Result.DENY);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nonnull
    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.random.setSeed(this.world.func_72905_C() + (long)((x >> 2) * 65535) + (long)(z >> 2));
        int spire_x = (x >> 2) * 64 + (8 + this.random.nextInt(48)) - x * 16;
        int spire_z = (z >> 2) * 64 + (8 + this.random.nextInt(48)) - z * 16;
        this.random.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        GenStates[] values = GenStates.values();
        for (int dx = 0; dx < 16; ++dx) {
            for (int i = 0; i < 16; ++i) {
                int rs = (spire_x - dx) * (spire_x - dx) + (spire_z - i) * (spire_z - i);
                double spire_dist = rs < 256 ? Math.sqrt(rs) : Double.MAX_VALUE;
                GenStates curState = GenStates.FLOOR_BEDROCK;
                for (int dy = 0; dy < 256; ++dy) {
                    boolean advance;
                    IBlockState state = curState.state;
                    if (curState == GenStates.AIR && rs < 256) {
                        int m = Math.min(dy - 62, 120 - dy);
                        double t = spire_dist;
                        if (m < 9) {
                            t -= Math.sqrt(9 - m);
                        }
                        if (t <= 4.0 || t <= 5.0 && this.random.nextBoolean()) {
                            state = BlockStates.COBBLESTONE;
                        }
                    }
                    if (dy >= 253) {
                        state = BlockStates.BEDROCK;
                    }
                    chunkprimer.func_177855_a(dx, dy, i, state);
                    switch (curState) {
                        case FLOOR_BEDROCK: {
                            advance = dy > 2 || dy > 0 && this.random.nextBoolean();
                            break;
                        }
                        case GROUND: {
                            advance = dy >= 64 || dy >= 62 && this.random.nextInt(4) != 0;
                            break;
                        }
                        case AIR: {
                            advance = dy >= 90 && (dy >= 120 || this.random.nextInt(1 + 2 * (120 - dy) * (120 - dy)) == 0);
                            break;
                        }
                        case CEILING: {
                            advance = dy >= 120 && this.random.nextInt(40) == 0;
                            break;
                        }
                        case CEILING_STONE: {
                            advance = dy >= 253;
                            break;
                        }
                        case CEILING_BEDROCK: {
                            advance = false;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid State " + (Object)((Object)curState));
                        }
                    }
                    if (!advance) continue;
                    curState = values[curState.ordinal() + 1];
                }
            }
        }
        for (MapGenBase mapGenBase : this.generators) {
            mapGenBase.func_186125_a(this.world, x, z, chunkprimer);
        }
        for (MapGenBase mapGenBase : this.structureGenerators) {
            mapGenBase.func_186125_a(this.world, x, z, chunkprimer);
        }
        for (int dx = 0; dx < 16; ++dx) {
            void var8_16;
            boolean bl = false;
            while (var8_16 < 16) {
                for (int dy = 62; dy < 65; ++dy) {
                    if (chunkprimer.func_177856_a(dx, dy, (int)var8_16) != BlockStates.STONE) continue;
                    chunkprimer.func_177855_a(dx, dy, (int)var8_16, BlockStates.COBBLESTONE);
                }
                ++var8_16;
            }
        }
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        this.biomes = this.world.func_72959_q().func_76937_a(this.biomes, x * 16, z * 16, 16, 16);
        byte[] byArray = chunk.func_76605_m();
        for (int l = 0; l < byArray.length; ++l) {
            byArray[l] = (byte)Biome.func_185362_a((Biome)this.biomes[l]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void func_185931_b(int x, int z) {
        BlockPos blockpos1;
        BlockFalling.field_149832_M = true;
        int i = x * 16;
        int j = z * 16;
        BlockPos blockpos = new BlockPos(i, 0, j);
        Biome biome = this.world.getBiomeForCoordsBody(new BlockPos(i + 16, 0, j + 16));
        boolean flag = false;
        this.random.setSeed(this.world.func_72905_C());
        long k = this.random.nextLong() / 2L * 2L + 1L;
        long l = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
        ChunkPos chunkpos = new ChunkPos(x, z);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false);
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            boolean flag1 = mapgenstructure.func_175794_a(this.world, this.random, chunkpos);
            if (!(mapgenstructure instanceof MapGenVillage)) continue;
            flag |= flag1;
        }
        if (this.waterLakeGenerator != null && !flag && this.random.nextInt(4) == 0) {
            this.waterLakeGenerator.func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, this.random.nextInt(256), this.random.nextInt(16) + 8));
        }
        if (!(this.lavaLakeGenerator == null || flag || this.random.nextInt(8) != 0 || (blockpos1 = blockpos.func_177982_a(this.random.nextInt(16) + 8, this.random.nextInt(this.random.nextInt(248) + 8), this.random.nextInt(16) + 8)).func_177956_o() >= this.world.func_181545_F() && this.random.nextInt(10) != 0)) {
            this.lavaLakeGenerator.func_180709_b(this.world, this.random, blockpos1);
        }
        for (int i1 = 0; i1 < 8; ++i1) {
            new WorldGenDungeons().func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, this.random.nextInt(256), this.random.nextInt(16) + 8));
        }
        if (this.seedOffset.get() != 0) {
            return;
        }
        this.seedOffset.set(1);
        biome.func_180624_a(this.world, this.random, blockpos);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)flag);
        BlockFalling.field_149832_M = false;
        GameRegistry.generateWorld((int)x, (int)z, (World)this.world, (IChunkGenerator)this, (IChunkProvider)this.world.func_72863_F());
        this.seedOffset.set(0);
    }

    public boolean func_185933_a(@Nonnull Chunk chunkIn, int x, int z) {
        return false;
    }

    @Nonnull
    public List<Biome.SpawnListEntry> func_177458_a(@Nonnull EnumCreatureType creatureType, @Nonnull BlockPos pos) {
        Biome biome = this.world.getBiomeForCoordsBody(pos);
        return biome.func_76747_a(creatureType);
    }

    public void func_180514_a(@Nonnull Chunk chunkIn, int x, int z) {
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            mapgenstructure.func_186125_a(this.world, x, z, null);
        }
    }

    static {
        MinecraftForge.ORE_GEN_BUS.register(ChunkProviderDeepDark.class);
    }

    static enum GenStates {
        FLOOR_BEDROCK(BlockStates.BEDROCK),
        GROUND(BlockStates.STONE),
        AIR(BlockStates.AIR),
        CEILING(BlockStates.COBBLESTONE),
        CEILING_STONE(BlockStates.STONE),
        CEILING_BEDROCK(BlockStates.BEDROCK);

        final IBlockState state;

        private GenStates(IBlockState state) {
            this.state = state;
        }
    }
}

