/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.items.ItemAngelRing;
import com.rwtema.extrautils2.items.PlayerPowerFlightBase;
import com.rwtema.extrautils2.network.NetworkHandler;
import com.rwtema.extrautils2.power.ClientPower;
import com.rwtema.extrautils2.power.player.IPlayerPowerCreator;
import com.rwtema.extrautils2.power.player.PlayerPower;
import com.rwtema.extrautils2.power.player.PlayerPowerManager;
import com.rwtema.extrautils2.utils.Lang;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemChickenRing
extends XUItemFlatMetadata
implements IPlayerPowerCreator {
    public ItemChickenRing() {
        super("chickenring", "flyingsquidring");
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Override
    public boolean shouldOverride(PlayerPower playerPower, EntityPlayer player, ItemStack stack, boolean isSelected) {
        return playerPower instanceof PlayerPowerChicken && stack.func_77960_j() == 1;
    }

    @Override
    public PlayerPower createPower(EntityPlayer player, ItemStack params) {
        int metadata = params.func_77960_j();
        if (metadata == 1) {
            return new PlayerPowerSquid(player, params);
        }
        return new PlayerPowerChicken(player, params);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, playerIn, tooltip, advanced);
        if (stack.func_77960_j() == 1) {
            tooltip.add(Lang.translate("Jet propulsion at your fingertips!"));
        } else {
            tooltip.add(Lang.translate("Flight of the majestic beast!"));
        }
        tooltip.add(Lang.translateArgs("Uses %s GP", stack.func_77960_j() == 1 ? 16 : 1));
        tooltip.add(ClientPower.powerStatusString());
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() == 1) {
            return super.func_77667_c(stack) + ".squid";
        }
        return super.func_77667_c(stack);
    }

    public static class PlayerPowerChicken
    extends PlayerPowerFlightBase {
        public static final int POWER = 1;
        boolean hasHadBreakTime = false;

        public PlayerPowerChicken(@Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
            super(player, stack);
        }

        @Override
        public int getMaxFlightTime() {
            return 100;
        }

        @Override
        public boolean isValid(double y, double motion_y) {
            return this.tickFlight >= this.getMaxFlightTime() + 20 && motion_y < 0.0;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void tickClient() {
            EntityPlayer player = this.getPlayer();
            if (PlayerPowerManager.getClient((Item)XU2Entries.angelRing.value) != null) {
                this.tickFlight = 0;
                return;
            }
            boolean isJumping = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
            if (!player.field_70122_E) {
                if (!isJumping) {
                    this.hasHadBreakTime = true;
                }
                if (!this.hasHadBreakTime && this.tickFlight > 0) {
                    this.tickFlight = MathHelper.func_76125_a((int)(this.tickFlight - 4), (int)0, (int)this.getMaxFlightTime());
                }
                if (ClientPower.isPowered() && isJumping && this.hasHadBreakTime && player.field_70181_x < 0.0 && this.tickFlight < this.getMaxFlightTime()) {
                    ++this.tickFlight;
                    player.field_70181_x = Math.min(player.field_70181_x + 0.1, player.field_70181_x * 0.5);
                    player.field_70143_R = 0.0f;
                    NetworkHandler.sendPacketToServer(new PlayerPowerFlightBase.PacketFlightData(player));
                }
            } else if (!isJumping) {
                if (this.tickFlight > 0) {
                    this.tickFlight = MathHelper.func_76125_a((int)(this.tickFlight - 4), (int)0, (int)this.getMaxFlightTime());
                }
                this.hasHadBreakTime = false;
            }
        }

        @Override
        public void tick() {
            if (this.getPlayer().field_70122_E && this.tickFlight > 0) {
                this.tickFlight = MathHelper.func_76125_a((int)(this.tickFlight - 4), (int)0, (int)this.getMaxFlightTime());
            }
            ItemAngelRing.updateWingsDisplay(this.getPlayer().func_146103_bH().getName(), 6, false);
        }

        @Override
        public float power(EntityPlayer playerMP) {
            return 1.0f;
        }

        @Override
        public void onAdd() {
            ItemAngelRing.updateWingsDisplay(this.getPlayer().func_146103_bH().getName(), 6, false);
        }

        @Override
        public void onRemove() {
            ItemAngelRing.updateWingsDisplay(this.getPlayer().func_146103_bH().getName(), 0, true);
        }
    }

    public static class PlayerPowerSquid
    extends PlayerPowerFlightBase {
        public static final int POWER = 16;
        boolean hasHadBreakTime = false;

        public PlayerPowerSquid(EntityPlayer player, @Nonnull ItemStack stack) {
            super(player, stack);
        }

        @Override
        public int getMaxFlightTime() {
            return 200;
        }

        @Override
        public float power(EntityPlayer playerMP) {
            return 16.0f;
        }

        @Override
        public void tickClient() {
            EntityPlayer player = this.getPlayer();
            if (PlayerPowerManager.getClient((Item)XU2Entries.angelRing.value) != null) {
                this.tickFlight = 0;
                return;
            }
            boolean isJumping = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
            if (ClientPower.isPowered()) {
                boolean onGround = player.field_70122_E;
                if (onGround && !isJumping) {
                    this.hasHadBreakTime = false;
                }
                if (!onGround && !isJumping) {
                    this.hasHadBreakTime = true;
                }
                if (!onGround && isJumping && this.tickFlight < this.getMaxFlightTime()) {
                    ++this.tickFlight;
                    player.field_70181_x = player.field_70181_x * 0.9 + 0.1;
                    NetworkHandler.sendPacketToServer(new PlayerPowerFlightBase.PacketFlightData(player));
                }
                if (!isJumping && this.tickFlight > 0) {
                    --this.tickFlight;
                }
            }
        }

        @Override
        public void tick() {
            --this.tickFlight;
        }

        @Override
        public boolean isValid(double y, double motion_y) {
            return this.tickFlight >= this.getMaxFlightTime() + 20;
        }
    }
}

