/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.items;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.achievements.AchievementHelper;
import com.rwtema.extrautils2.api.machine.XUMachineEnchanter;
import com.rwtema.extrautils2.backend.ISidedFunction;
import com.rwtema.extrautils2.backend.XUItemFlatMetadata;
import com.rwtema.extrautils2.backend.entries.IItemStackMaker;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.backend.model.Textures;
import com.rwtema.extrautils2.blocks.BlockCursedEarth;
import com.rwtema.extrautils2.blocks.BlockSimpleDecorative;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.crafting.CraftingHelper;
import com.rwtema.extrautils2.eventhandlers.DropsHandler;
import com.rwtema.extrautils2.items.DemonicIngotHandler;
import com.rwtema.extrautils2.power.ClientPower;
import com.rwtema.extrautils2.power.Freq;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.power.energy.EnergyTransfer;
import com.rwtema.extrautils2.power.energy.TilePowerBattery;
import com.rwtema.extrautils2.tile.TileResonator;
import com.rwtema.extrautils2.transfernodes.IUpgradeProvider;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.RandomChanceWithLooting;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemIngredients
extends XUItemFlatMetadata
implements IUpgradeProvider {
    public static final int RED_COAL_MULTIPLIER = 8;
    public static TIntObjectHashMap<Type> metaMap = new TIntObjectHashMap();

    public ItemIngredients() {
        super(ItemIngredients.getTextureArray());
        this.func_77627_a(true);
    }

    public static String[] getTextureArray() {
        int maxMeta = 0;
        for (Type type : Type.values()) {
            maxMeta = Math.max(maxMeta, type.meta);
        }
        String[] strings = new String[maxMeta + 1];
        for (Type type : Type.values()) {
            if (type.meta < 0) continue;
            strings[type.meta] = type.texture;
        }
        return strings;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getType(stack).getMaxStackSize(stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        this.getType(stack).onUpdate(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    @Override
    @Nonnull
    public EnumActionResult onItemUseBase(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return this.getType(stack).onItemUse(stack, playerIn, worldIn, pos, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerTextures() {
        super.registerTextures();
        for (Type type : Type.values()) {
            Textures.register(type.texture);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public String getTexture(@Nullable ItemStack itemStack, int renderPass) {
        return this.getType((ItemStack)itemStack).texture;
    }

    @Override
    public void getSubItemsBase(@Nonnull Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (Type type : Type.values()) {
            if (type.meta < 0) continue;
            type.addsubitems(subItems);
        }
    }

    public Type getType(ItemStack stack) {
        Type type = (Type)metaMap.get(stack.func_77952_i());
        return type == null ? Type.SYMBOL_ERROR : type;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + "." + this.getType(stack).name().toLowerCase();
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return this.getType(entityItem.func_92059_d()).onEntityItemUpdate(entityItem);
    }

    @Override
    @Nonnull
    public String func_77653_i(@Nonnull ItemStack stack) {
        return Lang.translate(this.func_77657_g(stack) + ".name", this.getType(stack).defaultName());
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        return this.getType(itemStack).getContainerItem(itemStack);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.getType(stack).hasContainerItem(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        this.getType(stack).addInformation(stack, playerIn, tooltip, advanced);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return this.getType(stack).hasCustomEntity(stack);
    }

    @Nonnull
    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return this.getType(itemstack).createEntity(world, location, itemstack);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getType(stack).hasEffect(stack);
    }

    @Override
    public Upgrade getUpgrade(ItemStack stack) {
        return this.getType(stack).getUpgrade(stack);
    }

    public static enum Type implements IItemStackMaker,
    IUpgradeProvider
    {
        BIOME_MARKER_BLANK(-8),
        ENCHANTED_BOOK_SKELETON(-7),
        FILTER_SKELETON(-6),
        SYMBOL_TICK(-5),
        SYMBOL_CROSS(-4),
        UPGRADE_SPEED_SKELETON(-3),
        SYMBOL_NOCRAFT(-2),
        SYMBOL_ERROR(-1),
        REDSTONE_CRYSTAL(0, "gemRedstone"){

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless("redstone_crystal", this.newStack(1), XU2Entries.itemEnderShard.newWildcardStack(), "dustRedstone", "dustRedstone", "dustRedstone", "dustRedstone");
                DropsHandler.registerDrops(Blocks.field_150450_ax.func_176223_P(), this.newStack(1), 0.025);
                DropsHandler.registerDrops(Blocks.field_150439_ay.func_176223_P(), this.newStack(1), 0.1);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(ClientPower.powerStatusString());
                if (ClientPower.hasNoPower()) {
                    tooltip.add(Lang.translate("See the Extra Utilities 2 Manual for more info"));
                }
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Tech-Tree Start", "See achievements list for Extra Utilities 2 power tech tree", this, null);
            }
        }
        ,
        REDSTONE_GEAR(1, "gearRedstone"){

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped("redstone_gear", this.newStack(1), " T ", "TsT", " T ", Character.valueOf('T'), Blocks.field_150429_aA, Character.valueOf('s'), "plankWood");
            }
        }
        ,
        EYE_REDSTONE(2, "eyeofredstone"){

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless("redstone_eye", this.newStack(1), Items.field_151079_bi, "dustRedstone", REDSTONE_CRYSTAL.newStack(1));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(ClientPower.powerStatusString());
            }
        }
        ,
        DYE_POWDER_LUNAR(3, "dustLunar"){

            @Override
            public void addRecipes() {
                OreDictionary.registerOre((String)"dyeMagenta", (ItemStack)this.newStack(1));
                TileResonator.register(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.BLUE.func_176767_b()), this.newStack(1), 1600);
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Dye of the Moon", "The moons power beckons!", DYE_POWDER_LUNAR, XU2Entries.stoneburnt);
            }
        }
        ,
        RED_COAL(4, "coalPowered"){

            @Override
            public void addRecipes() {
                TileResonator.register(new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE), this.newStack(1), 1600, true);
                GameRegistry.registerFuelHandler((IFuelHandler)new IFuelHandler(){
                    ISidedFunction<Integer, PowerManager.IPowerReport> getPowerReport = new ISidedFunction<Integer, PowerManager.IPowerReport>(){

                        @Override
                        @SideOnly(value=Side.SERVER)
                        public PowerManager.IPowerReport applyServer(Integer input) {
                            return this.isPowered(input);
                        }

                        @Nonnull
                        public PowerManager.IPowerReport isPowered(Integer input) {
                            return PowerManager.instance.getPowerFreq(input);
                        }

                        @Override
                        @SideOnly(value=Side.CLIENT)
                        public PowerManager.IPowerReport applyClient(Integer input) {
                            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                            if (server == null) {
                                return ClientPower.POWER_REPORT;
                            }
                            return this.isPowered(input);
                        }
                    };

                    public int getBurnTime(ItemStack fuel) {
                        if (StackHelper.isNull(fuel) || fuel.func_77952_i() != Type.RED_COAL.meta || fuel.func_77973_b() != XU2Entries.itemIngredients.value) {
                            return 0;
                        }
                        NBTTagCompound nbt = fuel.func_77978_p();
                        if (nbt != null && nbt.func_150297_b("Freq", 3)) {
                            PowerManager.IPowerReport freq = ExtraUtils2.proxy.apply(this.getPowerReport, nbt.func_74762_e("Freq"));
                            float n = this.getPowerBonus(freq);
                            return (int)Math.floor(1600.0f * n);
                        }
                        return 1600;
                    }
                });
            }

            public float getPowerBonus(PowerManager.IPowerReport freq) {
                if (!freq.isPowered()) {
                    return 1.0f;
                }
                float n = 1.0f + freq.getPowerCreated() / 80.0f;
                if (n > 8.0f) {
                    n = 8.0f;
                } else if (n < 1.0f) {
                    n = 1.0f;
                }
                return n;
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                super.addInformation(stack, playerIn, tooltip, advanced);
                tooltip.add(Lang.translateArgs("Boosts fuel efficiency with additional GP up to %s.", StringHelper.formatPercent(7.0)));
                tooltip.add(Lang.translateArgs("Current efficiency boost: %s", StringHelper.formatPercent(this.getPowerBonus(ClientPower.POWER_REPORT) - 1.0f)));
            }

            @Override
            public boolean hasContainerItem(ItemStack stack) {
                return false;
            }

            @Override
            public ItemStack getContainerItem(ItemStack itemStack) {
                return StackHelper.empty();
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Powered Coal", "Boosts coals power by 8x", RED_COAL, XU2Entries.resonator);
            }
        }
        ,
        MOON_STONE(5, "gemMoon"){

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped("moon_stone", this.newStack(), "sss", "sds", "sss", Character.valueOf('d'), "gemDiamond", Character.valueOf('s'), DYE_POWDER_LUNAR);
            }
        }
        ,
        UPGRADE_SPEED(6, "xuUpgradeSpeed"){

            @Override
            public Upgrade getUpgrade(ItemStack stack) {
                return Upgrade.SPEED;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless("upgrade_speed", this.newStack(1), UPGRADE_BASE, "ingotGold", "blockRedstone");
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Speed Upgrade", "Boosts speed of transfer nodes.", this, UPGRADE_BASE);
            }

            @Override
            public int getMaxStackSize(ItemStack stack) {
                return 4;
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Increases speed of operations."));
                Upgrade.addTooltip(tooltip, stack, this, 4);
            }
        }
        ,
        UPGRADE_STACK(7, "xuUpgradeStack"){

            @Override
            public Upgrade getUpgrade(ItemStack stack) {
                return Upgrade.STACK_SIZE;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless("upgrade_stack", this.newStack(1), UPGRADE_BASE, "ingotGold", Items.field_151045_i);
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Stack Upgrade", "Boosts amount pulled from transfer nodes.", this, UPGRADE_BASE);
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Increase the number of items pulled to a stack"));
                Upgrade.addTooltip(tooltip, stack, this, -1);
            }
        }
        ,
        UPGRADE_MINING(8, "xuUpgradeMining"){

            @Override
            public Upgrade getUpgrade(ItemStack stack) {
                return Upgrade.MINING;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShapeless("upgrade_mining", this.newStack(1), UPGRADE_BASE, new ItemStack(Items.field_151005_D));
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Mining Upgrade", "Mines objects and fluids from the world.", this, UPGRADE_BASE);
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Allows mining of cobblestone and pumping of water"));
                Upgrade.addTooltip(tooltip, stack, this, -1);
            }
        }
        ,
        UPGRADE_BASE(9, "xuUpgradeBlank"){

            @Override
            public void addRecipes() {
                TileResonator.register(new ItemStack(Blocks.field_150445_bS), this.newStack(1), 800);
            }

            @Override
            public void addAchievement() {
                AchievementHelper.addAchievement("Transfer Node Upgrades", "Augment the power of nodes", this, XU2Entries.grocket.getMetaMaker(0));
            }
        }
        ,
        EVIL_DROP(10, "dropofevil"){

            @Override
            public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand) {
                IBlockState state = worldIn.func_180495_p(pos);
                if (XU2Entries.mobSpawner.isActive() && state.func_177230_c() == Blocks.field_150474_ac) {
                    TileEntity tile;
                    if (!worldIn.field_72995_K && (tile = worldIn.func_175625_s(pos)) instanceof TileEntityMobSpawner) {
                        TileEntityMobSpawner spawner = (TileEntityMobSpawner)tile;
                        NBTTagCompound nbt = spawner.func_145881_a().func_189530_b(new NBTTagCompound());
                        if (worldIn.func_175698_g(pos)) {
                            ItemStack dropStack = new ItemStack((Block)XU2Entries.mobSpawner.value);
                            dropStack.func_77982_d(nbt);
                            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)dropStack);
                        }
                    }
                    return EnumActionResult.SUCCESS;
                }
                if (XU2Entries.cursedEarth.isActive() && (state == Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT) || state == Blocks.field_150349_c.func_176223_P())) {
                    if (!worldIn.field_72995_K) {
                        BlockCursedEarth.startFastSpread(worldIn, pos);
                        StackHelper.decrease(stack);
                    }
                    return EnumActionResult.SUCCESS;
                }
                return EnumActionResult.PASS;
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
            }

            @Override
            public void addRecipes() {
                DropsHandler.lootDrops.put((Object)LootTableList.field_186386_ak, (Object)new LootPool(new LootEntry[]{new LootEntryItem((Item)XU2Entries.itemIngredients.value, 1, 0, new LootFunction[]{new SetMetadata(new LootCondition[0], new RandomValueRange((float)this.meta, (float)this.meta))}, new LootCondition[0], "xuLootDropOfEvil")}, new LootCondition[]{new RandomChanceWithLooting(0.1f, 0.1f)}, new RandomValueRange(1.0f, 1.0f), new RandomValueRange(0.0f, 0.0f), "xuLootDropOfEvil"));
            }
        }
        ,
        DEMON_INGOT(11, "ingotDemonicMetal"){
            {
                MinecraftForge.EVENT_BUS.register((Object)new DemonicIngotHandler());
            }

            @Override
            public void addRecipes() {
                if (XU2Entries.simpleDecorative.isActive()) {
                    CraftingHelper.addIngotBlockPackingRecipes("demon", this.newStack(), BlockSimpleDecorative.Type.BLOCK_DEMONIC.newStack());
                }
            }

            @Override
            public boolean hasCustomEntity(ItemStack stack) {
                return true;
            }

            @Override
            public Entity createEntity(World world, Entity location, ItemStack itemstack) {
                location.func_184224_h(true);
                return null;
            }

            @Override
            public boolean onEntityItemUpdate(EntityItem entityItem) {
                World worldObj = entityItem.field_70170_p;
                if (worldObj.field_72995_K && worldObj.func_180495_p(new BlockPos((Entity)entityItem)).func_185904_a() == Material.field_151587_i) {
                    worldObj.func_175688_a(EnumParticleTypes.LAVA, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
                }
                return super.onEntityItemUpdate(entityItem);
            }
        }
        ,
        ENCHANTED_INGOT(12, "ingotEnchantedMetal"){

            @Override
            public void addRecipes() {
                if (XU2Entries.simpleDecorative.isActive()) {
                    CraftingHelper.addIngotBlockPackingRecipes("enchanted", this.newStack(), BlockSimpleDecorative.Type.BLOCK_ENCHANTED.newStack());
                    if (XU2Entries.machineEntry.isActive()) {
                        XUMachineEnchanter.addRecipe(new ItemStack(Blocks.field_150340_R), BlockSimpleDecorative.Type.BLOCK_ENCHANTED.newStack(), 9, 24000, "gemLapis");
                    }
                }
                if (XU2Entries.machineEntry.isActive()) {
                    XUMachineEnchanter.addRecipe(new ItemStack(Items.field_151043_k), this.newStack(), 1, 8000, "gemLapis");
                }
            }
        }
        ,
        REDSTONE_COIL(13, "xuRedstoneCoil"){
            final int NEEDED_FOR_BURN = 2000;
            final int BURN_TIME = 20;

            @Override
            @SideOnly(value=Side.CLIENT)
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(Lang.translate("Use the RF energy stored in wireless batteries to create heat") + "\n" + Lang.translateArgs("Uses %s RF to create %s ticks of burn time.", 2000, 20), 200));
            }

            @Override
            public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
                NBTTagCompound nbt = stack.func_77978_p();
                if (!(nbt != null && nbt.func_150297_b("Freq", 3) || worldIn.field_72995_K || !(entityIn instanceof EntityPlayerMP))) {
                    stack.func_77983_a("Freq", (NBTBase)new NBTTagInt(Freq.getBasePlayerFreq((EntityPlayerMP)entityIn)));
                }
            }

            @Override
            public void addRecipes() {
                TileResonator.register(new ItemStack(Blocks.field_150411_aY, 1, Short.MAX_VALUE), this.newStack(1), 1600, true);
                GameRegistry.registerFuelHandler(fuel -> {
                    if (StackHelper.isNull(fuel) || fuel.func_77952_i() != this.meta || fuel.func_77973_b() != XU2Entries.itemIngredients.value) {
                        return 0;
                    }
                    if (FMLCommonHandler.instance().getEffectiveSide() != Side.SERVER) {
                        return 20;
                    }
                    NBTTagCompound nbt = fuel.func_77978_p();
                    if (nbt != null && nbt.func_150297_b("Freq", 3)) {
                        int freqNo = nbt.func_74762_e("Freq");
                        PowerManager.PowerFreq freq = PowerManager.instance.getPowerFreq(freqNo);
                        Collection batteries = freq.getSubTypes(EnergyTransfer.ENERGY_SYSTEM_STORAGE_KEY);
                        int totalEnergy = 0;
                        if (batteries != null) {
                            for (TilePowerBattery battery : batteries) {
                                if ((totalEnergy += battery.energy.getEnergyStored()) < 2000) continue;
                                return 20;
                            }
                        }
                    }
                    return 0;
                });
            }

            @Override
            public boolean hasContainerItem(ItemStack stack) {
                return true;
            }

            @Override
            public ItemStack getContainerItem(ItemStack itemStack) {
                NBTTagCompound nbt;
                Side effectiveSide = FMLCommonHandler.instance().getEffectiveSide();
                if (effectiveSide == Side.SERVER && (nbt = itemStack.func_77978_p()) != null && nbt.func_150297_b("Freq", 3)) {
                    int freqNo = nbt.func_74762_e("Freq");
                    PowerManager.PowerFreq freq = PowerManager.instance.getPowerFreq(freqNo);
                    Collection batteries = freq.getSubTypes(EnergyTransfer.ENERGY_SYSTEM_STORAGE_KEY);
                    int extractedEnergy = 0;
                    if (batteries != null) {
                        for (TilePowerBattery battery : batteries) {
                            if ((extractedEnergy += battery.energy.extractEnergy(2000 - extractedEnergy, false)) < 2000) continue;
                            break;
                        }
                    }
                }
                ItemStack copy = itemStack.func_77946_l();
                StackHelper.setStackSize(copy, 1);
                return copy;
            }

            @Override
            public int getMaxStackSize(ItemStack stack) {
                return 1;
            }
        }
        ,
        DYE_POWDER_BLUE(14, "dyeBlue"){

            @Override
            public void registerOres() {
                OreDictionary.registerOre((String)"dye", (ItemStack)this.newStack());
                OreDictionary.registerOre((String)"dyeBlue", (ItemStack)this.newStack());
            }
        }
        ,
        UPGRADE_SPEED_ENCHANTED(15, "xuUpgradeSpeedEnchanted"){

            @Override
            public Upgrade getUpgrade(ItemStack stack) {
                return Upgrade.SPEED;
            }

            @Override
            public boolean hasEffect(ItemStack stack) {
                return true;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped("upgrade_speed_enchanted", this.newStack(), "aia", "isi", "aia", Character.valueOf('a'), XU2Entries.magicApple.isActive() ? XU2Entries.magicApple : "ingotGold", Character.valueOf('i'), ENCHANTED_INGOT, Character.valueOf('s'), UPGRADE_SPEED);
            }

            @Override
            public int getMaxStackSize(ItemStack stack) {
                return 16;
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Increases speed of operations."));
                Upgrade.addTooltip(tooltip, stack, this, 16);
            }
        }
        ,
        UPGRADE_SPEED_SUPER(16, "xuUpgradeSpeedEnchanted"){

            @Override
            public Upgrade getUpgrade(ItemStack stack) {
                return Upgrade.SPEED;
            }

            @Override
            public boolean hasEffect(ItemStack stack) {
                return true;
            }

            @Override
            public void addRecipes() {
                CraftingHelper.addShaped("upgrade_speed_super", this.newStack(), "aia", "isi", "aia", Character.valueOf('a'), EVIL_DROP, Character.valueOf('i'), EVIL_INFUSED_INGOT, Character.valueOf('s'), UPGRADE_SPEED_ENCHANTED);
            }

            @Override
            public int getMaxStackSize(ItemStack stack) {
                return 64;
            }

            @Override
            public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
                tooltip.add(Lang.translate("Increases speed of operations."));
                Upgrade.addTooltip(tooltip, stack, this, 64);
            }
        }
        ,
        EVIL_INFUSED_INGOT(17, "ingotEvilMetal"){

            @Override
            public void addRecipes() {
                BlockSimpleDecorative.Type block_evil = BlockSimpleDecorative.Type.BLOCK_EVIL;
                if (XU2Entries.simpleDecorative.isActive()) {
                    CraftingHelper.addIngotBlockPackingRecipes("evil", this.newStack(), block_evil.newStack());
                    if (XU2Entries.machineEntry.isActive()) {
                        XUMachineEnchanter.addRecipe(new ItemStack(Blocks.field_150339_S, 8), block_evil.newStack(8), 9, 192000, "netherStar");
                    }
                }
                if (XU2Entries.machineEntry.isActive()) {
                    XUMachineEnchanter.addRecipe(new ItemStack(Items.field_151042_j, 8), this.newStack(8), 1, 64000, "netherStar");
                }
            }
        };

        public final int meta;
        public final String texture;
        public final String oreName;

        private Type(int meta) {
            this(meta, null);
        }

        private Type(int meta, String oreName) {
            this.meta = meta;
            this.oreName = oreName;
            this.texture = this.name().toLowerCase();
            metaMap.put(meta, (Object)this);
            if (meta < 0) {
                metaMap.put(meta + Short.MAX_VALUE, (Object)this);
            }
        }

        protected void addsubitems(List<ItemStack> subItems) {
            subItems.add(this.newStack());
        }

        public String defaultName() {
            StringBuilder builder = new StringBuilder();
            String[] split = this.name().split("_");
            for (int i = 0; i < split.length; ++i) {
                if (i > 0) {
                    builder.append(" ");
                }
                builder.append(StringHelper.capFirst(split[i], true));
            }
            return builder.toString();
        }

        public void addRecipes() {
        }

        @Override
        public ItemStack newStack(int amount) {
            int m = this.meta;
            if (m < 0) {
                m += Short.MAX_VALUE;
            }
            return XU2Entries.itemIngredients.newStack(amount, m);
        }

        @SideOnly(value=Side.CLIENT)
        public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        }

        @Override
        public ItemStack newStack() {
            return this.newStack(1);
        }

        public int getMaxStackSize(ItemStack stack) {
            return 64;
        }

        @Override
        public Upgrade getUpgrade(ItemStack stack) {
            return null;
        }

        public void addAchievement() {
        }

        public EnumActionResult onItemUse(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand) {
            return EnumActionResult.PASS;
        }

        public ItemStack getContainerItem(ItemStack itemStack) {
            return StackHelper.empty();
        }

        public boolean hasContainerItem(ItemStack stack) {
            return false;
        }

        public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        }

        public void registerOres() {
            if (this.oreName != null) {
                OreDictionary.registerOre((String)this.oreName, (ItemStack)this.newStack());
            }
        }

        public boolean hasCustomEntity(ItemStack stack) {
            return false;
        }

        public Entity createEntity(World world, Entity location, ItemStack itemstack) {
            return null;
        }

        public boolean onEntityItemUpdate(EntityItem entityItem) {
            return false;
        }

        public boolean hasEffect(ItemStack stack) {
            return false;
        }

        public void preInitRegister() {
        }
    }
}

