/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.XUBlock;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.compatibility.StackHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.DynamicGui;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidgetServerNetwork;
import com.rwtema.extrautils2.gui.backend.WidgetClick;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.gui.backend.WidgetText;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.itemhandler.ConcatFixedLength;
import com.rwtema.extrautils2.itemhandler.EmptyHandlerModifiable;
import com.rwtema.extrautils2.itemhandler.IItemHandlerModifiableCompat;
import com.rwtema.extrautils2.itemhandler.SingleStackHandlerBase;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.utils.ItemStackNonNull;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.datastructures.ArrayAccess;
import com.rwtema.extrautils2.utils.helpers.ColorHelper;
import com.rwtema.extrautils2.utils.helpers.NBTHelper;
import com.rwtema.extrautils2.utils.helpers.PlayerHelper;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TilePlayerChest
extends TilePower
implements IDynamicHandler {
    private static final int[] col = new int[]{-2142220208, -2130751408, -2142175408, -2130706433};
    public IItemHandlerModifiable PLAYER_HANDLER;
    GameProfile profile;
    TIntHashSet extractable = new TIntHashSet();
    TIntHashSet insertable = new TIntHashSet();
    IItemHandler[] playerInvHandlers = new IItemHandler[5];

    public TilePlayerChest() {
        this.playerInvHandlers[0] = new IItemHandlerModifiableCompat(){

            @Override
            public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
                EntityPlayerMP ownerPlayer = TilePlayerChest.this.getOwnerPlayer();
                if (ownerPlayer != null) {
                    ownerPlayer.field_71071_by.func_70299_a(slot, stack);
                    PlayerHelper.syncInventory(ownerPlayer);
                }
            }

            @Override
            public int getSlots() {
                return 36;
            }

            @Override
            @ItemStackNonNull
            public ItemStack getStackInSlot(int slot) {
                return TilePlayerChest.this.getTarget().getStackInSlot(slot);
            }

            @Override
            @ItemStackNonNull
            public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
                if (simulate) {
                    return TilePlayerChest.this.getTarget().insertItem(slot, stack, true);
                }
                EntityPlayerMP ownerPlayer = TilePlayerChest.this.getOwnerPlayer();
                if (ownerPlayer == null) {
                    return stack;
                }
                ItemStack itemStack = TilePlayerChest.this.getTarget().insertItem(slot, stack, false);
                if (itemStack != stack) {
                    PlayerHelper.syncInventory(ownerPlayer);
                }
                return itemStack;
            }

            @Override
            @ItemStackNonNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (simulate) {
                    return TilePlayerChest.this.getTarget().extractItem(slot, amount, true);
                }
                EntityPlayerMP ownerPlayer = TilePlayerChest.this.getOwnerPlayer();
                if (ownerPlayer == null) {
                    return StackHelper.empty();
                }
                ItemStack itemStack = TilePlayerChest.this.getTarget().extractItem(slot, amount, false);
                if (StackHelper.isNonNull(itemStack)) {
                    PlayerHelper.syncInventory(ownerPlayer);
                }
                return itemStack;
            }
        };
        for (int i = 0; i < 4; ++i) {
            final int finalI = i;
            this.playerInvHandlers[i + 1] = new SingleStackHandlerBase(){

                @Override
                @ItemStackNonNull
                public ItemStack getStack() {
                    EntityPlayerMP ownerPlayer = TilePlayerChest.this.getOwnerPlayer();
                    if (ownerPlayer == null) {
                        return StackHelper.empty();
                    }
                    return (ItemStack)CompatHelper.getArray10List11(ownerPlayer.field_71071_by.field_70460_b).get(3 - finalI);
                }

                @Override
                public void setStack(@ItemStackNonNull ItemStack stack) {
                    EntityPlayerMP ownerPlayer = TilePlayerChest.this.getOwnerPlayer();
                    if (ownerPlayer == null) {
                        return;
                    }
                    ArrayAccess arrayAccess = CompatHelper.getArray10List11(ownerPlayer.field_71071_by.field_70460_b);
                    if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)((ItemStack)arrayAccess.get(3 - finalI)))) {
                        arrayAccess.set(3 - finalI, stack);
                        PlayerHelper.syncInventory(ownerPlayer);
                    }
                }

                @Override
                protected int getStackLimit(@Nonnull ItemStack stack) {
                    if (StackHelper.isNull(stack)) {
                        return 0;
                    }
                    EntityPlayerMP ownerPlayer = TilePlayerChest.this.getOwnerPlayer();
                    return ownerPlayer != null && stack.func_77973_b().isValidArmor(stack, EntityEquipmentSlot.values()[5 - finalI], (Entity)ownerPlayer) ? 1 : 0;
                }
            };
        }
        this.PLAYER_HANDLER = new ConcatFixedLength(this.playerInvHandlers){

            @Override
            @ItemStackNonNull
            public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
                if (!TilePlayerChest.this.insertable.contains(slot)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }

            @Override
            @ItemStackNonNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (!TilePlayerChest.this.extractable.contains(slot)) {
                    return StackHelper.empty();
                }
                return super.extractItem(slot, amount, simulate);
            }
        };
    }

    public IItemHandlerModifiable getTarget() {
        EntityPlayerMP target = this.getOwnerPlayer();
        if (target == null) {
            return EmptyHandlerModifiable.INSTANCE;
        }
        return new InvWrapper((IInventory)target.field_71071_by);
    }

    @Nullable
    public EntityPlayerMP getOwnerPlayer() {
        if (this.profile == null || this.field_145850_b == null || this.field_145850_b.field_72995_K || !this.active) {
            return null;
        }
        EntityPlayerMP target = null;
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            for (EntityPlayerMP playerMP : server.func_184103_al().func_181057_v()) {
                if (!this.profile.equals((Object)playerMP.func_146103_bH())) continue;
                if (playerMP.field_70128_L) {
                    return null;
                }
                target = playerMP;
            }
        }
        return target;
    }

    @Override
    public IItemHandler getItemHandler(EnumFacing facing) {
        return this.PLAYER_HANDLER;
    }

    @Override
    public void onPowerChanged() {
        this.markForUpdate();
    }

    @Override
    public void addToDescriptionPacket(XUPacketBuffer packet) {
        super.addToDescriptionPacket(packet);
        if (this.profile != null) {
            String name = this.profile.getName();
            packet.writeString(name);
        } else {
            packet.writeShort(0);
        }
    }

    @Override
    public void handleDescriptionPacket(XUPacketBuffer packet) {
        super.handleDescriptionPacket(packet);
        String s = packet.readString();
        this.profile = StringUtils.func_151246_b((String)s) ? null : new GameProfile(null, s);
    }

    @Override
    public float getPower() {
        return 4.0f;
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.profile != null) {
            compound.func_74782_a("Owner", (NBTBase)NBTHelper.proifleToNBT(this.profile));
        }
        compound.func_74783_a("InsertSlots", this.insertable.toArray());
        compound.func_74783_a("ExtractSlots", this.extractable.toArray());
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.profile = NBTHelper.profileFromNBT(compound.func_74775_l("Owner"));
        this.insertable.addAll(compound.func_74759_k("InsertSlots"));
        this.extractable.addAll(compound.func_74759_k("ExtractSlots"));
    }

    @Override
    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack, XUBlock xuBlock) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack, xuBlock);
        if (placer instanceof EntityPlayer) {
            this.profile = PlayerHelper.isPlayerReal((EntityPlayer)placer) ? ((EntityPlayer)placer).func_146103_bH() : null;
        }
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            if (ExtraUtils2.deobf_folder && ExtraUtils2.proxy.isAltSneaking(playerIn)) {
                this.openGUI(playerIn, 2);
                return true;
            }
            EntityPlayerMP ownerPlayer = this.getOwnerPlayer();
            if (ownerPlayer == playerIn) {
                this.openGUI(playerIn, 0);
            } else if (ownerPlayer != null) {
                this.openGUI(playerIn, 1);
            }
        }
        return true;
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        if (ID2 == 0) {
            return new DynamicPlayerChestConfig(player);
        }
        if (ID2 == 1) {
            if (world.field_72995_K) {
                return new DynamicPlayerChest(player, (IItemHandler)new ItemStackHandler(40));
            }
            return new DynamicPlayerChest(player, (IItemHandler)this.PLAYER_HANDLER);
        }
        if (ID2 == 2) {
            if (world.field_72995_K) {
                return new DynamicPlayerChest(player, (IItemHandler)new ItemStackHandler(40));
            }
            List ents = world.func_72872_a(EntityMinecartChest.class, new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)).func_72314_b(10.0, 10.0, 10.0));
            if (ents == null || ents.isEmpty()) {
                return new DynamicPlayerChest(player, EmptyHandlerModifiable.INSTANCE);
            }
            EntityMinecartChest entityMinecartChest = (EntityMinecartChest)ents.get(0);
            final InvWrapper invWrapper = new InvWrapper((IInventory)entityMinecartChest);
            return new DynamicPlayerChest(player, new IItemHandlerModifiableCompat(){

                @Override
                public void setStackInSlot(int slot, @ItemStackNonNull ItemStack stack) {
                    if (slot < invWrapper.getSlots()) {
                        invWrapper.setStackInSlot(slot, stack);
                    }
                }

                @Override
                public int getSlots() {
                    return 40;
                }

                @Override
                @ItemStackNonNull
                public ItemStack getStackInSlot(int slot) {
                    if (slot < invWrapper.getSlots()) {
                        return invWrapper.getStackInSlot(slot);
                    }
                    return StackHelper.empty();
                }

                @Override
                @ItemStackNonNull
                public ItemStack insertItem(int slot, @ItemStackNonNull ItemStack stack, boolean simulate) {
                    if (slot < invWrapper.getSlots()) {
                        return invWrapper.insertItem(slot, stack, simulate);
                    }
                    return stack;
                }

                @Override
                @ItemStackNonNull
                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (slot < invWrapper.getSlots()) {
                        return invWrapper.extractItem(slot, amount, simulate);
                    }
                    return StackHelper.empty();
                }
            });
        }
        return null;
    }

    @Override
    public void breakBlock(World worldIn, BlockPos pos, IBlockState state) {
    }

    public class DynamicPlayerChestConfig
    extends DynamicContainerTile {
        int clickType;

        public DynamicPlayerChestConfig(EntityPlayer player) {
            int j;
            super(TilePlayerChest.this);
            this.clickType = -1;
            int x = 4;
            int y = 4;
            this.addWidget(new WidgetTextData(x, y, 162){

                @Override
                public void addToDescription(XUPacketBuffer packet) {
                    packet.writeString(TilePlayerChest.this.profile == null ? "" : TilePlayerChest.this.profile.getName());
                }

                @Override
                @SideOnly(value=Side.CLIENT)
                protected String constructText(XUPacketBuffer packet) {
                    String s = packet.readString();
                    if (StringUtils.func_151246_b((String)s)) {
                        return "";
                    }
                    return Lang.translateArgs("%s's Inventory", s);
                }
            });
            this.addWidget(new WidgetText(x, y += 9, Lang.translate("Configuration")));
            y += 9;
            int i = 0;
            while (i < 4) {
                final int finalI = i++;
                this.addWidget(new WidgetClickableSlot(36 + finalI, x + finalI * 18, y){

                    @Override
                    @SideOnly(value=Side.CLIENT)
                    public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                        super.renderBackground(manager, gui, guiLeft, guiTop);
                        if (StackHelper.isNonNull(this.displayStack)) {
                            return;
                        }
                        TextureAtlasSprite textureExtry = Minecraft.func_71410_x().func_147117_R().getTextureExtry(ItemArmor.field_94603_a[3 - finalI]);
                        if (textureExtry != null) {
                            manager.func_110577_a(TextureMap.field_110575_b);
                            gui.func_175175_a(guiLeft + this.getX() + 1, guiTop + this.getY() + 1, textureExtry, 16, 16);
                            manager.func_110577_a(gui.getWidgetTexture());
                        }
                    }
                });
            }
            y += 18;
            for (j = 0; j < 3; ++j) {
                for (int k = 0; k < 9; ++k) {
                    this.addWidget(new WidgetClickableSlot(k + j * 9 + 9, x + k * 18, y + 14 + j * 18));
                }
            }
            for (j = 0; j < 9; ++j) {
                this.addWidget(new WidgetClickableSlot(j, x + j * 18, y + 14 + 58));
            }
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }

        @Override
        @ItemStackNonNull
        public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int par2) {
            return super.func_82846_b(par1EntityPlayer, par2);
        }

        @Override
        public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
            if (!this.isClient && playerIn != TilePlayerChest.this.getOwnerPlayer()) {
                return false;
            }
            return super.func_75145_c(playerIn) && TilePlayerChest.this.active;
        }

        public class WidgetClickableSlot
        extends WidgetClick
        implements IWidgetServerNetwork {
            private final int slot;
            ItemStack displayStack;
            byte accessType;
            boolean overMe;

            public WidgetClickableSlot(int slot, int x, int y) {
                super(x, y, 18, 18);
                this.accessType = 0;
                this.overMe = false;
                this.slot = slot;
            }

            @Override
            public void onClick(byte b) {
                if ((b & 1) != 0) {
                    TilePlayerChest.this.insertable.add(this.slot);
                } else {
                    TilePlayerChest.this.insertable.remove(this.slot);
                }
                if ((b & 2) != 0) {
                    TilePlayerChest.this.extractable.add(this.slot);
                } else {
                    TilePlayerChest.this.extractable.remove(this.slot);
                }
            }

            @Override
            public void addToDescription(XUPacketBuffer packet) {
                packet.writeByte((TilePlayerChest.this.insertable.contains(this.slot) ? 1 : 0) | (TilePlayerChest.this.extractable.contains(this.slot) ? 2 : 0));
                packet.writeItemStack(TilePlayerChest.this.PLAYER_HANDLER.getStackInSlot(this.slot));
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void handleDescriptionPacket(XUPacketBuffer packet) {
                this.accessType = packet.readByte();
                this.displayStack = packet.readItemStack();
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void renderForeground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                if (StackHelper.isNull(this.displayStack)) {
                    return;
                }
                GlStateManager.func_179145_e();
                RenderHelper.func_74520_c();
                gui.renderStack(this.displayStack, guiLeft + this.getX() + 1, guiTop + this.getY() + 1, null);
                RenderHelper.func_74518_a();
                GlStateManager.func_179140_f();
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 0, 0, 18, 18);
                int color = col[this.accessType & 3];
                GlStateManager.func_179131_c((float)ColorHelper.getRF(color), (float)ColorHelper.getGF(color), (float)ColorHelper.getBF(color), (float)1.0f);
                gui.func_73729_b(guiLeft + this.getX() + 1, guiTop + this.getY() + 1, 1, 1, 16, 16);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void mouseClicked(int mouseX, int mouseY, int mouseButton, boolean mouseOver) {
                if (mouseOver && (mouseButton == 0 || mouseButton == 1)) {
                    DynamicPlayerChestConfig.this.clickType = this.accessType + (mouseButton * 2 - 1) & 3;
                    this.overMe = true;
                    this.sendClick(DynamicPlayerChestConfig.this.clickType);
                }
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void mouseReleased(int mouseX, int mouseY, int mouseButton, boolean mouseOver) {
                super.mouseReleased(mouseX, mouseY, mouseButton, mouseOver);
                DynamicPlayerChestConfig.this.clickType = -1;
                this.overMe = false;
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void mouseClickMove(int mouseX, int mouseY, int mouseButton, long timeSinceLastMove, boolean mouseOver) {
                if (mouseOver && DynamicPlayerChestConfig.this.clickType != -1 && !this.overMe) {
                    this.sendClick(DynamicPlayerChestConfig.this.clickType);
                    this.overMe = true;
                }
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public List<String> getToolTip() {
                ArrayList strings = Lists.newArrayList();
                switch (this.accessType) {
                    case 0: {
                        strings.add(ChatFormatting.GRAY + Lang.translate("No Access") + ChatFormatting.RESET);
                        break;
                    }
                    case 1: {
                        strings.add(ChatFormatting.RED + Lang.translate("Insert Only") + ChatFormatting.RESET);
                        break;
                    }
                    case 2: {
                        strings.add(ChatFormatting.GREEN + Lang.translate("Extract Only") + ChatFormatting.RESET);
                        break;
                    }
                    case 3: {
                        strings.add(ChatFormatting.WHITE + Lang.translate("Full Access") + ChatFormatting.RESET);
                    }
                }
                return strings;
            }
        }
    }

    public class DynamicPlayerChest
    extends DynamicContainerTile {
        IItemHandler target;

        public DynamicPlayerChest(EntityPlayer player, IItemHandler target) {
            int j;
            super(TilePlayerChest.this);
            this.target = target;
            int x = 4;
            int y = 4;
            this.addWidget(new WidgetTextData(x, y, 162){

                @Override
                public void addToDescription(XUPacketBuffer packet) {
                    packet.writeString(TilePlayerChest.this.profile == null ? "" : TilePlayerChest.this.profile.getName());
                }

                @Override
                protected String constructText(XUPacketBuffer packet) {
                    String s = packet.readString();
                    if (StringUtils.func_151246_b((String)s)) {
                        return "";
                    }
                    return Lang.translateArgs("%s's Inventory", s);
                }
            });
            y += 9;
            int i = 0;
            while (i < 4) {
                final int finalI = i++;
                this.addWidget(new WidgetSlotAccess(target, 36 + finalI, x + finalI * 18, y){

                    @SideOnly(value=Side.CLIENT)
                    public String func_178171_c() {
                        return ItemArmor.field_94603_a[3 - finalI];
                    }

                    public int func_75219_a() {
                        return 1;
                    }

                    @Override
                    public boolean func_75214_a(ItemStack stack) {
                        if (!super.func_75214_a(stack)) {
                            return false;
                        }
                        EntityPlayerMP ownerPlayer = TilePlayerChest.this.getOwnerPlayer();
                        return ownerPlayer != null && stack.func_77973_b().isValidArmor(stack, EntityEquipmentSlot.values()[2 + finalI], (Entity)ownerPlayer);
                    }
                });
            }
            y += 18;
            for (j = 0; j < 3; ++j) {
                for (int k = 0; k < 9; ++k) {
                    this.addWidget(new WidgetSlotAccess(target, k + j * 9 + 9, x + k * 18, y + 14 + j * 18));
                }
            }
            for (j = 0; j < 9; ++j) {
                this.addWidget(new WidgetSlotAccess(target, j, x + j * 18, y + 14 + 58));
            }
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }

        @Override
        public boolean func_75145_c(@Nonnull EntityPlayer playerIn) {
            return super.func_75145_c(playerIn);
        }

        public class WidgetSlotAccess
        extends WidgetSlotItemHandler
        implements IWidgetServerNetwork {
            byte accessType;

            public WidgetSlotAccess(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
                super(itemHandler, index, xPosition, yPosition);
                this.accessType = (byte)3;
            }

            @Override
            public void addToDescription(XUPacketBuffer packet) {
                this.accessType = (byte)((TilePlayerChest.this.insertable.contains(this.index) ? 1 : 0) | (TilePlayerChest.this.extractable.contains(this.index) ? 2 : 0));
                packet.writeByte(this.accessType);
            }

            @Override
            public void handleDescriptionPacket(XUPacketBuffer packet) {
                this.accessType = packet.readByte();
            }

            public boolean func_75214_a(ItemStack stack) {
                return (this.accessType & 1) != 0 && super.func_75214_a(stack);
            }

            public boolean func_82869_a(EntityPlayer playerIn) {
                return (this.accessType & 2) != 0 && super.func_82869_a(playerIn);
            }

            @Override
            @SideOnly(value=Side.CLIENT)
            public void renderBackground(TextureManager manager, DynamicGui gui, int guiLeft, int guiTop) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                gui.func_73729_b(guiLeft + this.getX(), guiTop + this.getY(), 0, 0, 18, 18);
                int color = col[this.accessType & 3];
                GlStateManager.func_179131_c((float)ColorHelper.getRF(color), (float)ColorHelper.getGF(color), (float)ColorHelper.getBF(color), (float)1.0f);
                gui.func_73729_b(guiLeft + this.getX() + 1, guiTop + this.getY() + 1, 1, 1, 16, 16);
            }
        }
    }
}

