/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.tile;

import com.google.common.collect.ImmutableList;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.extrautils2.backend.entries.XU2Entries;
import com.rwtema.extrautils2.biome.BiomeManip;
import com.rwtema.extrautils2.blocks.BlockTerraformer;
import com.rwtema.extrautils2.compatibility.CompatHelper;
import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.WidgetBackground;
import com.rwtema.extrautils2.gui.backend.WidgetEnergyStorage;
import com.rwtema.extrautils2.gui.backend.WidgetScrollBarServer;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.gui.backend.WidgetTextDataScroll;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.items.ItemBiomeMarker;
import com.rwtema.extrautils2.network.XUPacketBuffer;
import com.rwtema.extrautils2.power.PowerManager;
import com.rwtema.extrautils2.power.energy.XUEnergyStorage;
import com.rwtema.extrautils2.tile.TilePower;
import com.rwtema.extrautils2.tile.TileTerraformerClimograph;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.TEHelper;
import com.rwtema.extrautils2.utils.datastructures.NBTSerializable;
import com.rwtema.extrautils2.utils.helpers.StringHelper;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class TileTerraformer
extends TilePower
implements ITickable,
IDynamicHandler {
    static final int MAX_CONTAINER_RANGE = 4;
    static final int MAX_TRANSFORMATION_RANGE = 64;
    static final int POWER_PER_TICK = 80;
    private static final int TRANSFORM_TIME = 20;
    final NBTSerializable.NBTMutableBlockPos targetPosition = this.registerNBT("targetpos", new NBTSerializable.NBTMutableBlockPos());
    public XUEnergyStorage energy = this.registerNBT("energy", new XUEnergyStorage(1600));
    ItemBiomeMarker.ItemBiomeHandler targetBiome = this.registerNBT("biome", new ItemBiomeMarker.ItemBiomeHandler(){

        @Override
        protected void onContentsChanged() {
            TileTerraformer.this.func_70296_d();
        }
    });
    NBTSerializable.Int range = this.registerNBT("scantime", new NBTSerializable.Int());
    NBTSerializable.Int transformTime = this.registerNBT("transformtime", new NBTSerializable.Int());
    int findingCooldown = 0;
    NBTSerializable.NBTEnumIntMap<BlockTerraformer.Type> currentStoredEnergy = this.registerNBT("loadedEnergy", new NBTSerializable.NBTEnumIntMap<BlockTerraformer.Type>(BlockTerraformer.Type.class));
    EnumSet<BlockTerraformer.Type> present_set = EnumSet.noneOf(BlockTerraformer.Type.class);

    public static boolean isHostile(Biome biome) {
        List spawnableList = biome.func_76747_a(EnumCreatureType.MONSTER);
        return !spawnableList.isEmpty();
    }

    @Nonnull
    public static String getName(BlockTerraformer.Type type) {
        return TileTerraformer.getStack(type).func_82833_r();
    }

    @Nonnull
    public static ItemStack getStack(BlockTerraformer.Type type) {
        return XU2Entries.terraformer.newStack(1, ((BlockTerraformer)XU2Entries.terraformer.value).func_176223_P().func_177226_a(BlockTerraformer.TYPE, (Comparable)((Object)type)));
    }

    public static TObjectIntHashMap<BlockTerraformer.Type> getTransformationRequirements(Biome current, Biome target) {
        int v;
        TObjectIntHashMap map = new TObjectIntHashMap(10, 0.5f, 0);
        float tempDiff = target.func_185353_n() - current.func_185353_n();
        float rainDiff = target.func_76727_i() - current.func_76727_i();
        if (tempDiff > 0.0f) {
            v = (int)Math.floor(tempDiff * 15.0f);
            map.adjustOrPutValue((Object)BlockTerraformer.Type.HEATER, v, v);
        } else if (tempDiff < 0.0f) {
            v = (int)Math.floor(-tempDiff * 15.0f);
            map.adjustOrPutValue((Object)BlockTerraformer.Type.COOLER, v, v);
        }
        if (rainDiff > 0.0f) {
            v = (int)Math.floor(rainDiff * 20.0f);
            map.adjustOrPutValue((Object)BlockTerraformer.Type.HUMIDIFIER, v, v);
        } else if (rainDiff < 0.0f) {
            v = (int)Math.floor(-rainDiff * 20.0f);
            map.adjustOrPutValue((Object)BlockTerraformer.Type.DEHUMIDIFIER, v, v);
        }
        Set<BiomeDictionary.Type> removedTraits = TileTerraformer.getTraitsDiff(target, current);
        Set<BiomeDictionary.Type> addedTraits = TileTerraformer.getTraitsDiff(current, target);
        TileTerraformer.alter((TObjectIntHashMap<BlockTerraformer.Type>)map, addedTraits, removedTraits, BlockTerraformer.Type.HUMIDIFIER, BlockTerraformer.Type.DEHUMIDIFIER, 4, 4, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH);
        TileTerraformer.alter((TObjectIntHashMap<BlockTerraformer.Type>)map, addedTraits, removedTraits, BlockTerraformer.Type.DEHUMIDIFIER, BlockTerraformer.Type.HUMIDIFIER, 4, 4, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA);
        TileTerraformer.alter((TObjectIntHashMap<BlockTerraformer.Type>)map, addedTraits, removedTraits, BlockTerraformer.Type.MAGIC_INFUSER, BlockTerraformer.Type.MAGIC_INFUSER, 10, 10, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.END, BiomeDictionary.Type.NETHER);
        for (Pair<BlockTerraformer.Type, BlockTerraformer.Type> opposite : BlockTerraformer.OPPOSITES) {
            int l = map.get(opposite.getLeft());
            int r = map.get(opposite.getRight());
            if (l == 0 && r == 0) continue;
            if (l == r) {
                map.remove(opposite.getLeft());
                continue;
            }
            if (l < r) {
                map.remove(opposite.getLeft());
                continue;
            }
            if (r >= l) continue;
            map.remove(opposite.getRight());
        }
        if (!TileTerraformer.isHostile(target) && TileTerraformer.isHostile(current)) {
            map.adjustOrPutValue((Object)BlockTerraformer.Type.DEHOSTILIFIER, 10, 10);
        }
        return map;
    }

    public static void alter(TObjectIntHashMap<BlockTerraformer.Type> map, Set<BiomeDictionary.Type> addedTraits, Set<BiomeDictionary.Type> removedTraits, BlockTerraformer.Type plusType, BlockTerraformer.Type removeType, int addAmount, int remove_amount, BiomeDictionary.Type ... biomeTypes) {
        for (BiomeDictionary.Type type : biomeTypes) {
            if (addedTraits.contains(type)) {
                map.adjustOrPutValue((Object)plusType, addAmount, addAmount);
            }
            if (!removedTraits.contains(type)) continue;
            map.adjustOrPutValue((Object)removeType, remove_amount, remove_amount);
        }
    }

    public static Set<BiomeDictionary.Type> getTraitsDiff(Biome a, Biome b) {
        HashSet<BiomeDictionary.Type> set = new HashSet<BiomeDictionary.Type>();
        for (BiomeDictionary.Type type : CompatHelper.getTypesForBiome(b)) {
            set.add(type);
        }
        for (BiomeDictionary.Type type : CompatHelper.getTypesForBiome(a)) {
            set.remove(type);
        }
        return set;
    }

    @Override
    protected Iterable<ItemStack> getDropHandler() {
        return InventoryHelper.getItemHandlerIterator((IItemHandler)this.targetBiome);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Biome target = this.targetBiome.getBiome();
        if (target == null) {
            return;
        }
        if (this.range.value <= 0) {
            return;
        }
        if (this.targetPosition.equals(BlockPos.field_177992_a)) {
            if (this.findingCooldown > 0) {
                --this.findingCooldown;
                return;
            }
            BlockPos.MutableBlockPos temp_pos = new BlockPos.MutableBlockPos();
            int range = MathHelper.func_76125_a((int)this.range.value, (int)1, (int)64);
            Random rand = this.field_145850_b.field_73012_v;
            int curBest = Integer.MAX_VALUE;
            for (int i = 0; i < 100; ++i) {
                int d;
                Biome biome1;
                int x = rand.nextInt(range * 2 + 1) - range;
                int z = rand.nextInt(range * 2 + 1) - range;
                temp_pos.func_181079_c(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p() + z);
                if (!this.field_145850_b.func_175667_e((BlockPos)temp_pos) || (biome1 = this.field_145850_b.getBiomeForCoordsBody((BlockPos)temp_pos)) == target || (d = x * x + z * z) >= curBest) continue;
                curBest = d;
                this.targetPosition.func_189533_g((Vec3i)temp_pos);
            }
            if (this.targetPosition.equals(BlockPos.field_177992_a)) {
                this.findingCooldown = 20;
                return;
            }
        }
        if (this.targetPosition.equals(BlockPos.field_177992_a)) {
            return;
        }
        if (!this.field_145850_b.func_175667_e((BlockPos)this.targetPosition)) {
            this.targetPosition.func_189533_g((Vec3i)BlockPos.field_177992_a);
            this.transformTime.value = 0;
            return;
        }
        Biome curBiome = this.field_145850_b.getBiomeForCoordsBody((BlockPos)this.targetPosition);
        if (curBiome == target) {
            this.targetPosition.func_189533_g((Vec3i)BlockPos.field_177992_a);
            this.transformTime.value = 0;
            return;
        }
        TObjectIntHashMap<BlockTerraformer.Type> map = TileTerraformer.getTransformationRequirements(curBiome, target);
        if (this.transformTime.value > 0) {
            List<TileTerraformerClimograph> containers = this.getTileTerraformerContainers();
            this.present_set.clear();
            for (TileTerraformerClimograph container : containers) {
                BlockTerraformer.Type type = container.getType();
                if (!map.containsKey((Object)type)) continue;
                this.present_set.add(type);
                if (this.present_set.size() < map.size()) continue;
                break;
            }
            if (this.present_set.size() < map.size()) {
                return;
            }
            for (TileTerraformerClimograph container : containers) {
                if (!map.containsKey((Object)container.getType())) continue;
                if (container.sprinkerActive == 0) {
                    container.markForUpdate();
                }
                container.sprinkerActive = 200;
            }
            if (this.energy.extractEnergy(80, true) < 80) {
                return;
            }
            this.energy.extractEnergy(80, false);
            --this.transformTime.value;
            if (this.transformTime.value == 0) {
                BiomeManip.setBiome(this.field_145850_b, target, this.targetPosition.func_185334_h());
                this.targetPosition.func_189533_g((Vec3i)BlockPos.field_177992_a);
                this.transformTime.value = 0;
                this.currentStoredEnergy.map.clear();
                this.func_73660_a();
            }
            return;
        }
        boolean needsEnergy = false;
        for (BlockTerraformer.Type type : map.keySet()) {
            if (this.currentStoredEnergy.map.get((Object)type) >= map.get((Object)type)) continue;
            needsEnergy = true;
            break;
        }
        if (!needsEnergy) {
            this.transformTime.value = 20;
        } else {
            List<TileTerraformerClimograph> containers = this.getTileTerraformerContainers();
            this.present_set.clear();
            for (TileTerraformerClimograph container : containers) {
                int toAdd;
                BlockTerraformer.Type type = container.getType();
                this.present_set.add(type);
                if (container.hasAntenna != Boolean.TRUE || container.level.value <= 0 || (toAdd = map.get((Object)type) - this.currentStoredEnergy.map.get((Object)type)) <= 0) continue;
                container.level.value -= toAdd;
                this.currentStoredEnergy.map.adjustOrPutValue((Object)type, toAdd, toAdd);
            }
        }
    }

    private List<TileTerraformerClimograph> getTileTerraformerContainers() {
        return TEHelper.get(this.field_145850_b, this.field_174879_c, 4, value -> value instanceof TileTerraformerClimograph && PowerManager.areFreqOnSameGrid(this.frequency(), ((TileTerraformerClimograph)value).frequency()));
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerTerraformer(this, player);
    }

    @Override
    public float getPower() {
        return Float.NaN;
    }

    @Override
    public void onPowerChanged() {
    }

    @Override
    @Nullable
    public IEnergyStorage getEnergyHandler(EnumFacing facing) {
        return this.energy;
    }

    public static class ContainerTerraformer
    extends DynamicContainerTile {
        public ContainerTerraformer(final TileTerraformer tile, EntityPlayer player) {
            super(tile);
            this.addTitle(TileTerraformer.getName(BlockTerraformer.Type.CONTROLLER));
            this.addWidget(tile.targetBiome.getSlot(4, 15));
            this.addWidget(new WidgetTextData(28, 18, 90){

                @Override
                public void addToDescription(XUPacketBuffer packet) {
                    Biome biome = tile.targetBiome.getBiome();
                    if (biome == null || tile.targetPosition.equals(BlockPos.field_177992_a)) {
                        packet.writeBoolean(false);
                        return;
                    }
                    packet.writeBoolean(true);
                    Biome current = tile.field_145850_b.func_180494_b((BlockPos)tile.targetPosition);
                    packet.writeInt(Biome.field_185377_q.func_148757_b((Object)biome));
                    packet.writeInt(Biome.field_185377_q.func_148757_b((Object)current));
                }

                @Override
                protected String constructText(XUPacketBuffer packet) {
                    if (!packet.readBoolean()) {
                        return "";
                    }
                    Biome biome = Biome.func_150568_d((int)packet.readInt());
                    Biome current = Biome.func_150568_d((int)packet.readInt());
                    biome = biome == null ? Biomes.field_76772_c : biome;
                    current = current == null ? Biomes.field_76772_c : current;
                    return current.func_185359_l() + " -> " + biome.func_185359_l();
                }
            });
            WidgetScrollBarServer scrollBar = new WidgetScrollBarServer(4, 35, 70, 0, 64){

                @Override
                public int getValueServer() {
                    return tile.range.value;
                }

                @Override
                public void setValueServer(int level) {
                    BlockPos subtract;
                    if (tile.range.value > level && (Math.abs((subtract = tile.targetPosition.func_177973_b((Vec3i)tile.field_174879_c)).func_177958_n()) > level || Math.abs(subtract.func_177952_p()) > level)) {
                        tile.targetPosition.func_189533_g((Vec3i)BlockPos.field_177992_a);
                    }
                    tile.range.value = level;
                }

                @Override
                public List<String> getToolTip() {
                    return ImmutableList.of((Object)Lang.translateArgs("Range: %s", this.scrollValue));
                }
            };
            this.addWidget(scrollBar);
            int widthtemp = 160;
            this.addWidget(new WidgetBackground(22, 35, 142, 70, DynamicContainer.texBackgroundBorder));
            int border = 2;
            WidgetTextDataScroll textData = new WidgetTextDataScroll(22 + border, 35 + border, 142 - border * 2, 70 - border * 2){

                @Override
                public void addToDescription(XUPacketBuffer packet) {
                    packet.writeInt(tile.range.value);
                    Biome biome = tile.targetBiome.getBiome();
                    packet.writeBoolean(biome != null);
                    if (biome == null) {
                        packet.writeBlockPos(BlockPos.field_177992_a);
                        return;
                    }
                    packet.writeBlockPos((BlockPos)tile.targetPosition);
                    if (tile.targetPosition.equals(BlockPos.field_177992_a)) {
                        return;
                    }
                    Biome current = tile.field_145850_b.func_180494_b((BlockPos)tile.targetPosition);
                    packet.writeInt(Biome.field_185377_q.func_148757_b((Object)biome));
                    packet.writeInt(Biome.field_185377_q.func_148757_b((Object)current));
                    packet.writeInt(tile.transformTime.value);
                    TObjectIntHashMap<BlockTerraformer.Type> transformationRequirements = TileTerraformer.getTransformationRequirements(current, biome);
                    packet.writeShort(transformationRequirements.size());
                    HashSet<BlockTerraformer.Type> missingTypes = new HashSet<BlockTerraformer.Type>();
                    for (BlockTerraformer.Type type : transformationRequirements.keySet()) {
                        packet.writeByte(type.ordinal());
                        packet.writeInt(tile.currentStoredEnergy.map.get((Object)type));
                        packet.writeInt(transformationRequirements.get((Object)type));
                        if (tile.present_set.contains((Object)type)) continue;
                        missingTypes.add(type);
                    }
                    packet.writeShort(missingTypes.size());
                    for (BlockTerraformer.Type missingType : missingTypes) {
                        packet.writeByte(missingType.ordinal());
                    }
                }

                @Override
                protected String constructText(XUPacketBuffer packet) {
                    BlockTerraformer.Type type;
                    int i;
                    int range = packet.readInt();
                    packet.readBoolean();
                    BlockPos pos = packet.readBlockPos();
                    if (pos.equals((Object)BlockPos.field_177992_a)) {
                        if (tile.targetBiome.isEmpty()) {
                            return Lang.translate("No biome marker.");
                        }
                        if (range == 0) {
                            return Lang.translate("Range is set to zero.");
                        }
                        return Lang.translate("Searching...");
                    }
                    StringBuilder builder = new StringBuilder();
                    builder.append(Lang.translateArgs("Processing %s, %s, %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).append('\n');
                    Biome biome = Biome.func_150568_d((int)packet.readInt());
                    Biome current = Biome.func_150568_d((int)packet.readInt());
                    int time = packet.readInt();
                    builder.append(Lang.translateArgs("Transform Time: %s", time)).append("\n\n");
                    int n = packet.readShort();
                    for (i = 0; i < n; ++i) {
                        type = BlockTerraformer.Type.values()[packet.readUnsignedByte()];
                        builder.append(TileTerraformer.getName(type));
                        builder.append(" (").append(StringHelper.format(packet.readInt())).append("/").append(StringHelper.format(packet.readInt())).append(")\n");
                    }
                    n = packet.readShort();
                    if (n > 0) {
                        builder.append("\n").append(ChatFormatting.RED).append(Lang.translate("Missing Climographs:")).append('\n');
                        for (i = 0; i < n; ++i) {
                            type = BlockTerraformer.Type.values()[packet.readUnsignedByte()];
                            builder.append("    - ").append(TileTerraformer.getName(type)).append("\n");
                        }
                        builder.append(Lang.translateArgs("Place Climographs within %s blocks of Terraformer", 4));
                    }
                    return builder.toString();
                }
            };
            this.addWidget(textData);
            this.crop();
            this.addWidget(new WidgetEnergyStorage(this.width, (this.height - 54) / 2, (IEnergyStorage)tile.energy));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }
}

