/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.utils.helpers.CollectionHelper;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.util.EnumFacing;

public class FacingHelper {
    public static final EnumMap<EnumFacing, EnumSet<EnumFacing>> orthogonal = CollectionHelper.populateEnumMultiMap(EnumFacing.class, (facing, facing2) -> facing.func_176740_k() != facing2.func_176740_k());
    public static final EnumMap<EnumFacing, EnumSet<EnumFacing>> horizontalOrthogonal = CollectionHelper.populateEnumMultiMap(EnumFacing.class, (facing, facing2) -> facing.func_176740_k() != facing2.func_176740_k() && facing2.func_176740_k() != EnumFacing.Axis.Y);
    public static final EnumFacing[] facingPlusNull = new EnumFacing[]{null, EnumFacing.DOWN, EnumFacing.UP, EnumFacing.WEST, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.NORTH};
    private static final Random r = new Random();
    private static final EnumFacing[] facingValues = EnumFacing.values();
    public static EnumFacing[][] randOrders;

    public static Iterable<EnumFacing> getRandomFaceOrder() {
        return new FaceIterRandom();
    }

    static {
        EnumFacing[] base = EnumFacing.values();
        randOrders = new EnumFacing[12][6];
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 6; ++j) {
                int k = (i + j) % 6;
                FacingHelper.randOrders[i * 2][j] = base[k];
                FacingHelper.randOrders[i * 2 + 1][j] = base[5 - k];
            }
        }
    }

    private static class FaceIterRandom
    implements Iterable<EnumFacing>,
    Iterator<EnumFacing> {
        byte[] b = new byte[]{0, 1, 2, 3, 4, 5};
        byte i = 0;

        private FaceIterRandom() {
        }

        @Override
        public Iterator<EnumFacing> iterator() {
            this.i = 0;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.i < 6;
        }

        @Override
        public EnumFacing next() {
            if (this.i == 5) {
                this.i = (byte)(this.i + 1);
                return facingValues[this.b[5]];
            }
            int k = this.i + r.nextInt(6 - this.i);
            if (k == this.i) {
                this.i = (byte)(this.i + 1);
                return facingValues[this.b[k]];
            }
            byte t = this.b[k];
            this.b[k] = this.b[this.i];
            this.b[this.i] = t;
            this.i = (byte)(this.i + 1);
            return facingValues[t];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

