/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.Config;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;

public final class IngredientInformation {
    private IngredientInformation() {
    }

    public static <T> String getDisplayName(T ingredient, IIngredientHelper<T> ingredientHelper) {
        String displayName = ingredientHelper.getDisplayName(ingredient);
        return IngredientInformation.removeChatFormatting(displayName);
    }

    public static <T> List<String> getTooltipStrings(T ingredient, IIngredientRenderer<T> ingredientRenderer, Set<String> toRemove) {
        ITooltipFlag.TooltipFlags tooltipFlag = Config.getSearchAdvancedTooltips() ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
        Minecraft minecraft = Minecraft.func_71410_x();
        List<String> tooltip = ingredientRenderer.getTooltip(minecraft, ingredient, (ITooltipFlag)tooltipFlag);
        ArrayList<String> cleanTooltip = new ArrayList<String>(tooltip.size());
        for (String line : tooltip) {
            line = IngredientInformation.removeChatFormatting(line);
            line = Translator.toLowercaseWithLocale(line);
            for (String excludeWord : toRemove) {
                line = line.replace(excludeWord, "");
            }
            if (StringUtils.func_151246_b((String)line)) continue;
            cleanTooltip.add(line);
        }
        return cleanTooltip;
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = TextFormatting.func_110646_a((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    public static <V> Collection<String> getColorStrings(V ingredient, IIngredientHelper<V> ingredientHelper) {
        Iterable<Color> colors = ingredientHelper.getColors(ingredient);
        ColorNamer colorNamer = Internal.getColorNamer();
        return colorNamer.getColorNames(colors, true);
    }
}

