/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.info;

import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.config.Constants;
import mezz.jei.plugins.jei.info.IngredientInfoRecipe;
import mezz.jei.util.Translator;
import net.minecraft.util.ResourceLocation;

public class IngredientInfoRecipeCategory
implements IRecipeCategory<IngredientInfoRecipe> {
    public static final int recipeWidth = 160;
    public static final int recipeHeight = 125;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawable slotBackground;
    private final String localizedName;

    public IngredientInfoRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 125);
        ResourceLocation recipeBackgroundResource = Constants.RECIPE_BACKGROUND;
        this.icon = guiHelper.createDrawable(recipeBackgroundResource, 196, 39, 16, 16);
        this.slotBackground = guiHelper.getSlotDrawable();
        this.localizedName = Translator.translateToLocal("gui.jei.category.itemInformation");
    }

    @Override
    public String getUid() {
        return "jei.information";
    }

    @Override
    public String getTitle() {
        return this.localizedName;
    }

    @Override
    public String getModName() {
        return "Just Enough Items";
    }

    @Override
    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, IngredientInfoRecipe recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        int xPos = 71;
        guiItemStacks.init(0, true, xPos, 0);
        guiItemStacks.setBackground(0, this.slotBackground);
        guiItemStacks.set(ingredients);
    }
}

