/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.config.Config;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeUtil;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeWrapper;
import mezz.jei.util.Log;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.AbstractBrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BrewingRecipeMaker {
    private final Set<Class> unhandledRecipeClasses = new HashSet<Class>();
    private final IIngredientRegistry ingredientRegistry;

    public static List<BrewingRecipeWrapper> getBrewingRecipes(IIngredientRegistry ingredientRegistry) {
        BrewingRecipeMaker brewingRecipeMaker = new BrewingRecipeMaker(ingredientRegistry);
        return brewingRecipeMaker.getBrewingRecipes();
    }

    private BrewingRecipeMaker(IIngredientRegistry ingredientRegistry) {
        this.ingredientRegistry = ingredientRegistry;
    }

    private List<BrewingRecipeWrapper> getBrewingRecipes() {
        this.unhandledRecipeClasses.clear();
        HashSet<BrewingRecipeWrapper> recipes = new HashSet<BrewingRecipeWrapper>();
        this.addVanillaBrewingRecipes(recipes);
        this.addModdedBrewingRecipes(recipes);
        ArrayList<BrewingRecipeWrapper> recipeList = new ArrayList<BrewingRecipeWrapper>(recipes);
        recipeList.sort(Comparator.comparingInt(BrewingRecipeWrapper::getBrewingSteps));
        return recipeList;
    }

    private void addVanillaBrewingRecipes(Collection<BrewingRecipeWrapper> recipes) {
        boolean foundNewPotions;
        List<ItemStack> potionIngredients = this.ingredientRegistry.getPotionIngredients();
        ArrayList<ItemStack> knownPotions = new ArrayList<ItemStack>();
        knownPotions.add(BrewingRecipeUtil.WATER_BOTTLE);
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = this.getNewPotions(knownPotions, potionIngredients, recipes)).isEmpty();
            knownPotions.addAll(newPotions);
        } while (foundNewPotions);
    }

    private List<ItemStack> getNewPotions(List<ItemStack> knownPotions, List<ItemStack> potionIngredients, Collection<BrewingRecipeWrapper> recipes) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            for (ItemStack potionIngredient : potionIngredients) {
                BrewingRecipeWrapper recipe;
                ResourceLocation outputId;
                PotionType potionInputType;
                ResourceLocation inputId;
                PotionType potionOutputType;
                ItemStack potionOutput = PotionHelper.func_185212_d((ItemStack)potionIngredient, (ItemStack)potionInput.func_77946_l());
                if (potionOutput.equals(potionInput) || potionInput.func_77973_b() == potionOutput.func_77973_b() && ((potionOutputType = PotionUtils.func_185191_c((ItemStack)potionOutput)) == PotionTypes.field_185230_b || Objects.equals(inputId = ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)(potionInputType = PotionUtils.func_185191_c((ItemStack)potionInput))), outputId = ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)potionOutputType))) || recipes.contains(recipe = new BrewingRecipeWrapper(Collections.singletonList(potionIngredient), potionInput.func_77946_l(), potionOutput))) continue;
                recipes.add(recipe);
                newPotions.add(potionOutput);
            }
        }
        return newPotions;
    }

    private void addModdedBrewingRecipes(Collection<BrewingRecipeWrapper> recipes) {
        List brewingRecipes = BrewingRecipeRegistry.getRecipes();
        this.addModdedBrewingRecipes(brewingRecipes, recipes);
    }

    private void addModdedBrewingRecipes(Collection<IBrewingRecipe> brewingRecipes, Collection<BrewingRecipeWrapper> recipes) {
        for (IBrewingRecipe iBrewingRecipe : brewingRecipes) {
            Class<?> recipeClass;
            if (iBrewingRecipe instanceof AbstractBrewingRecipe) {
                AbstractBrewingRecipe brewingRecipe = (AbstractBrewingRecipe)iBrewingRecipe;
                NonNullList<ItemStack> ingredientList = Internal.getStackHelper().toItemStackList(brewingRecipe.getIngredient());
                if (ingredientList.isEmpty()) continue;
                ItemStack input = brewingRecipe.getInput();
                if (ItemStack.func_77989_b((ItemStack)input, (ItemStack)BrewingRecipeUtil.POTION)) {
                    input = BrewingRecipeUtil.WATER_BOTTLE;
                }
                ItemStack output = brewingRecipe.getOutput();
                BrewingRecipeWrapper recipe = new BrewingRecipeWrapper((List<ItemStack>)ingredientList, input, output);
                recipes.add(recipe);
                continue;
            }
            if (iBrewingRecipe instanceof VanillaBrewingRecipe || this.unhandledRecipeClasses.contains(recipeClass = iBrewingRecipe.getClass())) continue;
            this.unhandledRecipeClasses.add(recipeClass);
            if (!Config.isDebugModeEnabled()) continue;
            Log.get().debug("Can't handle brewing recipe class: {}", recipeClass);
        }
    }
}

