/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BrewingRecipeWrapper
implements IRecipeWrapper {
    private static final BrewingRecipeUtil UTIL = new BrewingRecipeUtil();
    private final List<ItemStack> ingredients;
    private final ItemStack potionInput;
    private final ItemStack potionOutput;
    private final List<List<ItemStack>> inputs;
    private final int hashCode;

    public BrewingRecipeWrapper(List<ItemStack> ingredients, ItemStack potionInput, ItemStack potionOutput) {
        this.ingredients = ingredients;
        this.potionInput = potionInput;
        this.potionOutput = potionOutput;
        UTIL.addRecipe(potionInput, potionOutput);
        this.inputs = new ArrayList<List<ItemStack>>();
        this.inputs.add(Collections.singletonList(potionInput));
        this.inputs.add(Collections.singletonList(potionInput));
        this.inputs.add(Collections.singletonList(potionInput));
        this.inputs.add(ingredients);
        ItemStack firstIngredient = ingredients.get(0);
        PotionType typeIn = PotionUtils.func_185191_c((ItemStack)potionInput);
        PotionType typeOut = PotionUtils.func_185191_c((ItemStack)potionOutput);
        this.hashCode = com.google.common.base.Objects.hashCode((Object[])new Object[]{potionInput.func_77973_b(), ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)typeIn), potionOutput.func_77973_b(), ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)typeOut), firstIngredient.func_77973_b(), firstIngredient.func_77960_j()});
    }

    @Override
    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.inputs);
        ingredients.setOutput(ItemStack.class, this.potionOutput);
    }

    public List getInputs() {
        return this.inputs;
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int brewingSteps = this.getBrewingSteps();
        if (brewingSteps < Integer.MAX_VALUE) {
            String steps = Translator.translateToLocalFormatted("gui.jei.category.brewing.steps", brewingSteps);
            minecraft.field_71466_p.func_78276_b(steps, 70, 28, Color.gray.getRGB());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BrewingRecipeWrapper)) {
            return false;
        }
        BrewingRecipeWrapper other = (BrewingRecipeWrapper)obj;
        if (!BrewingRecipeWrapper.arePotionsEqual(other.potionInput, this.potionInput)) {
            return false;
        }
        if (!BrewingRecipeWrapper.arePotionsEqual(other.potionOutput, this.potionOutput)) {
            return false;
        }
        if (this.ingredients.size() != other.ingredients.size()) {
            return false;
        }
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (ItemStack.func_77989_b((ItemStack)this.ingredients.get(i), (ItemStack)other.ingredients.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean arePotionsEqual(ItemStack potion1, ItemStack potion2) {
        if (potion1.func_77973_b() != potion2.func_77973_b()) {
            return false;
        }
        PotionType type1 = PotionUtils.func_185191_c((ItemStack)potion1);
        PotionType type2 = PotionUtils.func_185191_c((ItemStack)potion2);
        ResourceLocation key1 = ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)type1);
        ResourceLocation key2 = ForgeRegistries.POTION_TYPES.getKey((IForgeRegistryEntry)type2);
        return Objects.equals(key1, key2);
    }

    public int getBrewingSteps() {
        return UTIL.getBrewingSteps(this.potionOutput);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        PotionType inputType = PotionUtils.func_185191_c((ItemStack)this.potionInput);
        PotionType outputType = PotionUtils.func_185191_c((ItemStack)this.potionOutput);
        return this.ingredients + " + [" + this.potionInput.func_77973_b() + " " + inputType.func_185174_b("") + "] = [" + this.potionOutput + " " + outputType.func_185174_b("") + "]";
    }
}

