/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.render;

import com.google.common.base.Joiner;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.color.ColorNamer;
import mezz.jei.config.Config;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.IIngredientListElement;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ReportedException;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;

public class IngredientRenderer<T> {
    private static final int BLACKLIST_COLOR_ITEM = Color.yellow.getRGB();
    private static final int BLACKLIST_COLOR_WILD = Color.red.getRGB();
    private static final int BLACKLIST_COLOR_MOD = Color.blue.getRGB();
    private static final Rectangle DEFAULT_AREA = new Rectangle(0, 0, 16, 16);
    protected final IIngredientListElement<T> element;
    protected Rectangle area = DEFAULT_AREA;
    protected int padding;

    public IngredientRenderer(IIngredientListElement<T> element) {
        this.element = element;
    }

    public void setArea(Rectangle area) {
        this.area = area;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public IIngredientListElement<T> getElement() {
        return this.element;
    }

    public void renderSlow() {
        if (Config.isEditModeEnabled()) {
            IngredientRenderer.renderEditMode(this.element, this.area, this.padding);
        }
        try {
            IIngredientRenderer<T> ingredientRenderer = this.element.getIngredientRenderer();
            T ingredient = this.element.getIngredient();
            ingredientRenderer.render(Minecraft.func_71410_x(), this.area.x + this.padding, this.area.y + this.padding, ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            throw IngredientRenderer.createRenderIngredientException(e, this.element);
        }
    }

    public void drawHighlight() {
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        GuiUtils.drawGradientRect((int)0, (int)this.area.x, (int)this.area.y, (int)(this.area.x + this.area.width), (int)(this.area.y + this.area.height), (int)-2130706433, (int)-2130706433);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179126_j();
    }

    public void drawTooltip(Minecraft minecraft, int mouseX, int mouseY) {
        T ingredient = this.element.getIngredient();
        IIngredientRenderer<T> ingredientRenderer = this.element.getIngredientRenderer();
        List<String> tooltip = IngredientRenderer.getTooltip(minecraft, this.element);
        FontRenderer fontRenderer = ingredientRenderer.getFontRenderer(minecraft, ingredient);
        if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            TooltipRenderer.drawHoveringText(itemStack, minecraft, tooltip, mouseX, mouseY, fontRenderer);
        } else {
            TooltipRenderer.drawHoveringText(minecraft, tooltip, mouseX, mouseY, fontRenderer);
        }
    }

    protected static <V> void renderEditMode(IIngredientListElement<V> element, Rectangle area, int padding) {
        IIngredientHelper<V> ingredientHelper;
        V ingredient = element.getIngredient();
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.ITEM, ingredientHelper = element.getIngredientHelper())) {
            GuiScreen.func_73734_a((int)(area.x + padding), (int)(area.y + padding), (int)(area.x + 8 + padding), (int)(area.y + 16 + padding), (int)BLACKLIST_COLOR_ITEM);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.WILDCARD, ingredientHelper)) {
            GuiScreen.func_73734_a((int)(area.x + 8 + padding), (int)(area.y + padding), (int)(area.x + 16 + padding), (int)(area.y + 16 + padding), (int)BLACKLIST_COLOR_WILD);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.MOD_ID, ingredientHelper)) {
            GuiScreen.func_73734_a((int)(area.x + padding), (int)(area.y + 8 + padding), (int)(area.x + 16 + padding), (int)(area.y + 16 + padding), (int)BLACKLIST_COLOR_MOD);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static <V> List<String> getTooltip(Minecraft minecraft, IIngredientListElement<V> element) {
        List<String> tooltip = IngredientRenderer.getIngredientTooltipSafe(minecraft, element);
        V ingredient = element.getIngredient();
        IIngredientHelper<V> ingredientHelper = element.getIngredientHelper();
        tooltip = ForgeModIdHelper.getInstance().addModNameToIngredientTooltip(tooltip, ingredient, ingredientHelper);
        int maxWidth = 125;
        for (String tooltipLine : tooltip) {
            int width = minecraft.field_71466_p.func_78256_a(tooltipLine);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        if (Config.getColorSearchMode() != Config.SearchMode.DISABLED) {
            IngredientRenderer.addColorSearchInfoToTooltip(minecraft, element, tooltip, maxWidth);
        }
        if (Config.isEditModeEnabled()) {
            IngredientRenderer.addEditModeInfoToTooltip(minecraft, element, tooltip, maxWidth);
        }
        return tooltip;
    }

    private static <V> List<String> getIngredientTooltipSafe(Minecraft minecraft, IIngredientListElement<V> element) {
        IIngredientRenderer<V> ingredientRenderer = element.getIngredientRenderer();
        V ingredient = element.getIngredient();
        try {
            ITooltipFlag.TooltipFlags tooltipFlag = minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            return ingredientRenderer.getTooltip(minecraft, ingredient, (ITooltipFlag)tooltipFlag);
        }
        catch (LinkageError | RuntimeException e) {
            Log.get().error("Tooltip crashed.", e);
            ArrayList<String> tooltip = new ArrayList<String>();
            tooltip.add(TextFormatting.RED + Translator.translateToLocal("jei.tooltip.error.crash"));
            return tooltip;
        }
    }

    private static <V> void addColorSearchInfoToTooltip(Minecraft minecraft, IIngredientListElement<V> element, List<String> tooltip, int maxWidth) {
        ColorNamer colorNamer = Internal.getColorNamer();
        V ingredient = element.getIngredient();
        IIngredientHelper<V> ingredientHelper = element.getIngredientHelper();
        Iterable<Color> colors = ingredientHelper.getColors(ingredient);
        Collection<String> colorNames = colorNamer.getColorNames(colors, false);
        if (!colorNames.isEmpty()) {
            String colorNamesString = Joiner.on((String)", ").join(colorNames);
            String colorNamesLocalizedString = TextFormatting.GRAY + Translator.translateToLocalFormatted("jei.tooltip.item.colors", colorNamesString);
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(colorNamesLocalizedString, maxWidth));
        }
    }

    private static <V> void addEditModeInfoToTooltip(Minecraft minecraft, IIngredientListElement<V> element, List<String> tooltip, int maxWidth) {
        String description;
        String message;
        V ingredient = element.getIngredient();
        IIngredientHelper<V> ingredientHelper = element.getIngredientHelper();
        tooltip.add("");
        tooltip.add(TextFormatting.ITALIC + Translator.translateToLocal("gui.jei.editMode.description"));
        String controlKeyLocalization = Translator.translateToLocal(Minecraft.field_142025_a ? "key.jei.ctrl.mac" : "key.jei.ctrl");
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.ITEM, ingredientHelper)) {
            message = Translator.translateToLocal("gui.jei.editMode.description.show").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.YELLOW + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        } else {
            message = Translator.translateToLocal("gui.jei.editMode.description.hide").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.YELLOW + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        }
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.WILDCARD, ingredientHelper)) {
            message = Translator.translateToLocal("gui.jei.editMode.description.show.wild").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.RED + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        } else {
            message = Translator.translateToLocal("gui.jei.editMode.description.hide.wild").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.RED + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        }
        if (Config.isIngredientOnConfigBlacklist(ingredient, Config.IngredientBlacklistType.MOD_ID, ingredientHelper)) {
            message = Translator.translateToLocal("gui.jei.editMode.description.show.mod.id").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.BLUE + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        } else {
            message = Translator.translateToLocal("gui.jei.editMode.description.hide.mod.id").replace("%CTRL", controlKeyLocalization);
            description = TextFormatting.BLUE + message;
            tooltip.addAll(minecraft.field_71466_p.func_78271_c(description, maxWidth));
        }
    }

    protected static <T> ReportedException createRenderIngredientException(Throwable throwable, IIngredientListElement<T> element) {
        Object ingredient = element.getIngredient();
        IIngredientHelper ingredientHelper = Internal.getIngredientRegistry().getIngredientHelper(ingredient);
        CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering ingredient");
        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Ingredient being rendered");
        crashreportcategory.func_189529_a("Ingredient Mod", () -> ForgeModIdHelper.getInstance().getModNameForIngredient(ingredient, ingredientHelper));
        crashreportcategory.func_189529_a("Ingredient Info", () -> ingredientHelper.getErrorInfo(ingredient));
        throw new ReportedException(crashreport);
    }
}

