/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.startup;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import mezz.jei.gui.recipes.RecipeClickableArea;
import mezz.jei.plugins.jei.info.IngredientInfoRecipe;
import mezz.jei.plugins.vanilla.anvil.AnvilRecipeWrapper;
import mezz.jei.recipes.RecipeRegistry;
import mezz.jei.recipes.RecipeTransferRegistry;
import mezz.jei.runtime.JeiHelpers;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class ModRegistry
implements IModRegistry,
IRecipeCategoryRegistration {
    private final IJeiHelpers jeiHelpers;
    private final IIngredientRegistry ingredientRegistry;
    private final List<IRecipeCategory> recipeCategories = new ArrayList<IRecipeCategory>();
    private final Set<String> recipeCategoryUids = new HashSet<String>();
    @Deprecated
    private final List<IRecipeHandler> unsortedRecipeHandlers = new ArrayList<IRecipeHandler>();
    private final Multimap<String, IRecipeHandler> recipeHandlers = ArrayListMultimap.create();
    private final List<IAdvancedGuiHandler<?>> advancedGuiHandlers = new ArrayList();
    @Deprecated
    private final List<Object> unsortedRecipes = new ArrayList<Object>();
    private final Multimap<String, Object> recipes = ArrayListMultimap.create();
    private final RecipeTransferRegistry recipeTransferRegistry;
    private final Multimap<Class<? extends GuiContainer>, RecipeClickableArea> recipeClickableAreas = ArrayListMultimap.create();
    private final Multimap<String, Object> recipeCatalysts = ArrayListMultimap.create();
    private final List<IRecipeRegistryPlugin> recipeRegistryPlugins = new ArrayList<IRecipeRegistryPlugin>();

    public ModRegistry(JeiHelpers jeiHelpers, IIngredientRegistry ingredientRegistry) {
        this.jeiHelpers = jeiHelpers;
        this.ingredientRegistry = ingredientRegistry;
        this.recipeTransferRegistry = new RecipeTransferRegistry(jeiHelpers.getStackHelper(), jeiHelpers.recipeTransferHandlerHelper());
    }

    @Override
    public IJeiHelpers getJeiHelpers() {
        return this.jeiHelpers;
    }

    @Override
    public IIngredientRegistry getIngredientRegistry() {
        return this.ingredientRegistry;
    }

    @Override
    public void addRecipeCategories(IRecipeCategory ... recipeCategories) {
        ErrorUtil.checkNotEmpty(recipeCategories, "recipeCategories");
        for (IRecipeCategory recipeCategory : recipeCategories) {
            String uid = recipeCategory.getUid();
            Preconditions.checkNotNull((Object)uid, (String)"Recipe category UID cannot be null %s", (Object)recipeCategory);
            if (this.recipeCategoryUids.add(uid)) continue;
            throw new IllegalArgumentException("A RecipeCategory with UID \"" + uid + "\" has already been registered.");
        }
        Collections.addAll(this.recipeCategories, recipeCategories);
    }

    @Override
    @Deprecated
    public void addRecipeHandlers(IRecipeHandler ... recipeHandlers) {
        ErrorUtil.checkNotEmpty(recipeHandlers, "recipeHandlers");
        for (IRecipeHandler recipeHandler : recipeHandlers) {
            Preconditions.checkNotNull(recipeHandler.getRecipeClass());
            Preconditions.checkArgument((!recipeHandler.getRecipeClass().equals(Object.class) ? 1 : 0) != 0, (Object)"Recipe handlers must handle a specific class, not Object.class");
            this.unsortedRecipeHandlers.add(recipeHandler);
        }
    }

    @Override
    @Deprecated
    public void addRecipes(Collection recipes) {
        ErrorUtil.checkNotNull(recipes, "recipes");
        this.unsortedRecipes.addAll(recipes);
    }

    @Override
    public void addRecipes(Collection<?> recipes, String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipes, "recipes");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        if (!this.recipeCategoryUids.contains(recipeCategoryUid)) {
            Log.get().warn("No recipe category has been registered for recipeCategoryUid {}", (Object)recipeCategoryUid);
        }
        for (Object recipe : recipes) {
            ErrorUtil.checkNotNull(recipe, "recipe");
            this.recipes.put((Object)recipeCategoryUid, recipe);
        }
    }

    @Override
    public <T> void handleRecipes(final Class<T> recipeClass, final IRecipeWrapperFactory<T> recipeWrapperFactory, final String recipeCategoryUid) {
        ErrorUtil.checkNotNull(recipeClass, "recipeClass");
        Preconditions.checkArgument((!recipeClass.equals(Object.class) ? 1 : 0) != 0, (Object)"Recipe handlers must handle a specific class, not Object.class");
        ErrorUtil.checkNotNull(recipeWrapperFactory, "recipeWrapperFactory");
        ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
        IRecipeHandler recipeHandler = new IRecipeHandler<T>(){

            @Override
            public Class<T> getRecipeClass() {
                return recipeClass;
            }

            @Override
            public String getRecipeCategoryUid(T recipe) {
                return recipeCategoryUid;
            }

            @Override
            public IRecipeWrapper getRecipeWrapper(T recipe) {
                return recipeWrapperFactory.getRecipeWrapper(recipe);
            }

            @Override
            public boolean isRecipeValid(T recipe) {
                return true;
            }
        };
        this.recipeHandlers.put((Object)recipeCategoryUid, (Object)recipeHandler);
    }

    @Override
    public void addRecipeClickArea(Class<? extends GuiContainer> guiContainerClass, int xPos, int yPos, int width, int height, String ... recipeCategoryUids) {
        ErrorUtil.checkNotNull(guiContainerClass, "guiContainerClass");
        ErrorUtil.checkNotEmpty(recipeCategoryUids, "recipeCategoryUids");
        RecipeClickableArea recipeClickableArea = new RecipeClickableArea(yPos, yPos + height, xPos, xPos + width, recipeCategoryUids);
        this.recipeClickableAreas.put(guiContainerClass, (Object)recipeClickableArea);
    }

    @Override
    public void addRecipeCatalyst(Object catalystIngredient, String ... recipeCategoryUids) {
        ErrorUtil.checkIsValidIngredient(catalystIngredient, "catalystIngredient");
        ErrorUtil.checkNotEmpty(recipeCategoryUids, "recipeCategoryUids");
        for (String recipeCategoryUid : recipeCategoryUids) {
            ErrorUtil.checkNotNull(recipeCategoryUid, "recipeCategoryUid");
            this.recipeCatalysts.put((Object)recipeCategoryUid, catalystIngredient);
        }
    }

    @Override
    @Deprecated
    public void addRecipeCategoryCraftingItem(ItemStack craftingItem, String ... recipeCategoryUids) {
        this.addRecipeCatalyst(craftingItem, recipeCategoryUids);
    }

    @Override
    public void addAdvancedGuiHandlers(IAdvancedGuiHandler<?> ... advancedGuiHandlers) {
        ErrorUtil.checkNotEmpty(advancedGuiHandlers, "advancedGuiHandlers");
        Collections.addAll(this.advancedGuiHandlers, advancedGuiHandlers);
    }

    @Override
    @Deprecated
    public void addDescription(List<ItemStack> itemStacks, String ... descriptionKeys) {
        this.addIngredientInfo(itemStacks, ItemStack.class, descriptionKeys);
    }

    @Override
    @Deprecated
    public void addDescription(ItemStack itemStack, String ... descriptionKeys) {
        this.addIngredientInfo(itemStack, ItemStack.class, descriptionKeys);
    }

    @Override
    public <T> void addIngredientInfo(T ingredient, Class<? extends T> ingredientClass, String ... descriptionKeys) {
        ErrorUtil.checkIsValidIngredient(ingredient, "ingredient");
        ErrorUtil.checkNotEmpty(descriptionKeys, "descriptionKeys");
        this.addIngredientInfo(Collections.singletonList(ingredient), ingredientClass, descriptionKeys);
    }

    @Override
    public <T> void addIngredientInfo(List<T> ingredients, Class<? extends T> ingredientClass, String ... descriptionKeys) {
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        for (T ingredient : ingredients) {
            ErrorUtil.checkIsValidIngredient(ingredient, "ingredient");
        }
        ErrorUtil.checkNotEmpty(descriptionKeys, "descriptionKeys");
        IGuiHelper guiHelper = this.jeiHelpers.getGuiHelper();
        List<IngredientInfoRecipe<? extends T>> recipes = IngredientInfoRecipe.create(guiHelper, ingredients, ingredientClass, descriptionKeys);
        this.addRecipes(recipes, "jei.information");
    }

    @Override
    public void addAnvilRecipe(ItemStack leftInput, List<ItemStack> rightInputs, List<ItemStack> outputs) {
        ErrorUtil.checkNotEmpty(leftInput, "leftInput");
        ErrorUtil.checkNotEmpty(rightInputs, "rightInputs");
        ErrorUtil.checkNotEmpty(outputs, "outputs");
        Preconditions.checkArgument((rightInputs.size() == outputs.size() ? 1 : 0) != 0, (Object)"Input and output sizes must match.");
        AnvilRecipeWrapper anvilRecipeWrapper = new AnvilRecipeWrapper(leftInput, rightInputs, outputs);
        this.addRecipes(Collections.singletonList(anvilRecipeWrapper), "minecraft.anvil");
    }

    @Override
    public IRecipeTransferRegistry getRecipeTransferRegistry() {
        return this.recipeTransferRegistry;
    }

    @Override
    public void addRecipeRegistryPlugin(IRecipeRegistryPlugin recipeRegistryPlugin) {
        ErrorUtil.checkNotNull(recipeRegistryPlugin, "recipeRegistryPlugin");
        Log.get().info("Added recipe registry plugin: {}", recipeRegistryPlugin.getClass());
        this.recipeRegistryPlugins.add(recipeRegistryPlugin);
    }

    public List<IAdvancedGuiHandler<?>> getAdvancedGuiHandlers() {
        return this.advancedGuiHandlers;
    }

    public RecipeRegistry createRecipeRegistry(IIngredientRegistry ingredientRegistry) {
        ImmutableTable<Class, String, IRecipeTransferHandler> recipeTransferHandlers = this.recipeTransferRegistry.getRecipeTransferHandlers();
        return new RecipeRegistry(this.recipeCategories, this.unsortedRecipeHandlers, this.recipeHandlers, recipeTransferHandlers, this.unsortedRecipes, this.recipes, this.recipeClickableAreas, this.recipeCatalysts, ingredientRegistry, this.recipeRegistryPlugins);
    }
}

