/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.suffixtree;

import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import javax.annotation.Nullable;
import mezz.jei.suffixtree.Edge;
import mezz.jei.suffixtree.ISearchTree;
import mezz.jei.suffixtree.Node;

public class GeneralizedSuffixTree
implements ISearchTree {
    private int highestIndex = -1;
    private final Node root;
    private Node activeLeaf = this.root = new Node();

    @Override
    public TIntSet search(String word) {
        Node tmpNode = this.searchNode(word);
        if (tmpNode == null) {
            return new TIntHashSet();
        }
        TIntHashSet ret = new TIntHashSet(1000);
        tmpNode.getData((TIntSet)ret);
        return ret;
    }

    @Nullable
    private Node searchNode(String word) {
        Node currentNode = this.root;
        for (int i = 0; i < word.length(); ++i) {
            int lenToMatch;
            char ch = word.charAt(i);
            Edge currentEdge = currentNode.getEdge(ch);
            if (null == currentEdge) {
                return null;
            }
            String label = currentEdge.getLabel();
            if (!word.regionMatches(i, label, 0, lenToMatch = Math.min(word.length() - i, label.length()))) {
                return null;
            }
            if (label.length() >= word.length() - i) {
                return currentEdge.getDest();
            }
            currentNode = currentEdge.getDest();
            i += lenToMatch - 1;
        }
        return null;
    }

    public void put(String key, int index) throws IllegalStateException {
        if (index < this.highestIndex) {
            throw new IllegalStateException("The input index must not be less than any of the previously inserted ones. Got " + index + ", expected at least " + this.highestIndex);
        }
        this.highestIndex = index;
        this.activeLeaf = this.root;
        Node s = this.root;
        String text = "";
        for (int i = 0; i < key.length(); ++i) {
            Pair<Node, String> active = this.update(s, text, key.charAt(i), key.substring(i), index);
            s = active.getFirst();
            text = active.getSecond();
        }
        if (null == this.activeLeaf.getSuffix() && this.activeLeaf != this.root && this.activeLeaf != s) {
            this.activeLeaf.setSuffix(s);
        }
    }

    private Pair<Boolean, Node> testAndSplit(Node inputs, String stringPart, char t, String remainder, int value) {
        Pair<Node, String> ret = this.canonize(inputs, stringPart);
        Node s = ret.getFirst();
        String str = ret.getSecond();
        if (!"".equals(str)) {
            Edge g = s.getEdge(str.charAt(0));
            String label = g.getLabel();
            if (label.length() > str.length() && label.charAt(str.length()) == t) {
                return new Pair<Boolean, Node>(true, s);
            }
            String newlabel = label.substring(str.length());
            assert (label.startsWith(str));
            Node r = new Node();
            Edge newedge = new Edge(str, r);
            g.setLabel(newlabel);
            r.addEdge(newlabel.charAt(0), g);
            s.addEdge(str.charAt(0), newedge);
            return new Pair<Boolean, Node>(false, r);
        }
        Edge e = s.getEdge(t);
        if (null == e) {
            return new Pair<Boolean, Node>(false, s);
        }
        if (remainder.equals(e.getLabel())) {
            e.getDest().addRef(value);
            return new Pair<Boolean, Node>(true, s);
        }
        if (remainder.startsWith(e.getLabel())) {
            return new Pair<Boolean, Node>(true, s);
        }
        if (e.getLabel().startsWith(remainder)) {
            Node newNode = new Node();
            newNode.addRef(value);
            Edge newEdge = new Edge(remainder, newNode);
            e.setLabel(e.getLabel().substring(remainder.length()));
            newNode.addEdge(e.getLabel().charAt(0), e);
            s.addEdge(t, newEdge);
            return new Pair<Boolean, Node>(false, s);
        }
        return new Pair<Boolean, Node>(true, s);
    }

    private Pair<Node, String> canonize(Node s, String inputstr) {
        if ("".equals(inputstr)) {
            return new Pair<Node, String>(s, inputstr);
        }
        Node currentNode = s;
        String str = inputstr;
        Edge g = s.getEdge(str.charAt(0));
        while (g != null && str.startsWith(g.getLabel())) {
            str = str.substring(g.getLabel().length());
            currentNode = g.getDest();
            if (str.length() <= 0) continue;
            g = currentNode.getEdge(str.charAt(0));
        }
        return new Pair<Node, String>(currentNode, str);
    }

    private Pair<Node, String> update(Node inputNode, String stringPart, char newChar, String rest, int value) {
        Node s = inputNode;
        String tempstr = stringPart + newChar;
        Node oldroot = this.root;
        Pair<Boolean, Node> ret = this.testAndSplit(s, stringPart, newChar, rest, value);
        Node r = ret.getSecond();
        boolean endpoint = ret.getFirst();
        while (!endpoint) {
            Node leaf;
            Edge tempEdge = r.getEdge(newChar);
            if (null != tempEdge) {
                leaf = tempEdge.getDest();
            } else {
                leaf = new Node();
                leaf.addRef(value);
                Edge newedge = new Edge(rest, leaf);
                r.addEdge(newChar, newedge);
            }
            if (this.activeLeaf != this.root) {
                this.activeLeaf.setSuffix(leaf);
            }
            this.activeLeaf = leaf;
            if (oldroot != this.root) {
                oldroot.setSuffix(r);
            }
            oldroot = r;
            if (null == s.getSuffix()) {
                assert (this.root == s);
                tempstr = tempstr.substring(1);
            } else {
                Pair<Node, String> canret = this.canonize(s.getSuffix(), GeneralizedSuffixTree.safeCutLastChar(tempstr));
                s = canret.getFirst();
                tempstr = canret.getSecond() + tempstr.charAt(tempstr.length() - 1);
            }
            ret = this.testAndSplit(s, GeneralizedSuffixTree.safeCutLastChar(tempstr), newChar, rest, value);
            r = ret.getSecond();
            endpoint = ret.getFirst();
        }
        if (oldroot != this.root) {
            oldroot.setSuffix(r);
        }
        return this.canonize(s, tempstr);
    }

    private static String safeCutLastChar(String seq) {
        if (seq.length() == 0) {
            return "";
        }
        return seq.substring(0, seq.length() - 1);
    }

    public int getHighestIndex() {
        return this.highestIndex;
    }

    private class Pair<A, B> {
        private final A first;
        private final B second;

        public Pair(A first, B second) {
            this.first = first;
            this.second = second;
        }

        public A getFirst() {
            return this.first;
        }

        public B getSecond() {
            return this.second;
        }

        public String toString() {
            return "Pair (" + this.first + ", " + this.second + ")";
        }
    }
}

