/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.util.InventoryUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class CraftingRecipe {
    private ItemStack result = InventoryUtils.EMPTY_STACK;
    private ItemStack[] recipe = new ItemStack[9];

    public CraftingRecipe() {
        this.ensureRecipeSizeAndClearRecipe(9);
    }

    public void ensureRecipeSize(int size) {
        if (this.getRecipeLength() != size) {
            this.recipe = new ItemStack[size];
        }
    }

    public void clearRecipe() {
        for (int i = 0; i < this.recipe.length; ++i) {
            this.recipe[i] = InventoryUtils.EMPTY_STACK;
        }
        this.result = InventoryUtils.EMPTY_STACK;
    }

    public void ensureRecipeSizeAndClearRecipe(int size) {
        this.ensureRecipeSize(size);
        this.clearRecipe();
    }

    public void storeCraftingRecipe(GuiContainer gui, Slot slot) {
        Configs.SlotRange range = Configs.getCraftingGridSlots(gui, slot);
        if (range != null && slot.func_75216_d() && (!InventoryUtils.areStacksEqual(this.getResult(), slot.func_75211_c()) || this.getRecipeLength() != range.getSlotCount())) {
            int gridSize = range.getSlotCount();
            int numSlots = gui.field_147002_h.field_75151_b.size();
            this.ensureRecipeSizeAndClearRecipe(gridSize);
            int i = 0;
            for (int s = range.getFirst(); i < gridSize && s < numSlots; ++i, ++s) {
                Slot slotTmp = gui.field_147002_h.func_75139_a(s);
                this.recipe[i] = slotTmp.func_75216_d() ? slotTmp.func_75211_c().func_77946_l() : InventoryUtils.EMPTY_STACK;
            }
            this.result = slot.func_75211_c().func_77946_l();
        }
    }

    public void copyRecipeFrom(CraftingRecipe other) {
        int size = other.getRecipeLength();
        ItemStack[] otherRecipe = other.getRecipe();
        this.ensureRecipeSizeAndClearRecipe(size);
        for (int i = 0; i < size; ++i) {
            this.recipe[i] = !InventoryUtils.isStackEmpty(otherRecipe[i]) ? otherRecipe[i].func_77946_l() : InventoryUtils.EMPTY_STACK;
        }
        this.result = !InventoryUtils.isStackEmpty(other.getResult()) ? other.getResult().func_77946_l() : InventoryUtils.EMPTY_STACK;
    }

    public void readFromNBT(@Nonnull NBTTagCompound nbt) {
        if (nbt.func_150297_b("Result", 10) && nbt.func_150297_b("Ingredients", 9)) {
            NBTTagList tagIngredients = nbt.func_150295_c("Ingredients", 10);
            int count = tagIngredients.func_74745_c();
            int length = nbt.func_74762_e("Length");
            if (length > 0) {
                this.ensureRecipeSizeAndClearRecipe(length);
            }
            for (int i = 0; i < count; ++i) {
                NBTTagCompound tag = tagIngredients.func_150305_b(i);
                int slot = tag.func_74762_e("Slot");
                if (slot < 0 || slot >= this.recipe.length) continue;
                this.recipe[slot] = new ItemStack(tag);
            }
            this.result = new ItemStack(nbt.func_74775_l("Result"));
        }
    }

    @Nonnull
    public NBTTagCompound writeToNBT(@Nonnull NBTTagCompound nbt) {
        if (this.isValid()) {
            NBTTagCompound tag = new NBTTagCompound();
            this.result.func_77955_b(tag);
            nbt.func_74768_a("Length", this.recipe.length);
            nbt.func_74782_a("Result", (NBTBase)tag);
            NBTTagList tagIngredients = new NBTTagList();
            for (int i = 0; i < this.recipe.length; ++i) {
                if (InventoryUtils.isStackEmpty(this.recipe[i])) continue;
                tag = new NBTTagCompound();
                tag.func_74768_a("Slot", i);
                this.recipe[i].func_77955_b(tag);
                tagIngredients.func_74742_a((NBTBase)tag);
            }
            nbt.func_74782_a("Ingredients", (NBTBase)tagIngredients);
        }
        return nbt;
    }

    public ItemStack getResult() {
        return this.result;
    }

    public int getRecipeLength() {
        return this.recipe.length;
    }

    public ItemStack[] getRecipe() {
        return this.recipe;
    }

    public boolean isValid() {
        return !InventoryUtils.isStackEmpty(this.getResult());
    }
}

