/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.itemscroller.recipes;

import fi.dy.masa.itemscroller.ItemScroller;
import fi.dy.masa.itemscroller.config.Configs;
import fi.dy.masa.itemscroller.recipes.CraftingRecipe;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.inventory.Slot;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.integrated.IntegratedServer;

public class RecipeStorage {
    private final CraftingRecipe[] recipes;
    private final int recipeCount;
    private final boolean global;
    private int selected;
    private boolean dirty;

    public RecipeStorage(int recipeCount, boolean global) {
        this.recipes = new CraftingRecipe[recipeCount];
        this.recipeCount = recipeCount;
        this.global = global;
        this.initRecipes();
    }

    private void initRecipes() {
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i] = new CraftingRecipe();
        }
    }

    public int getSelection() {
        return this.selected;
    }

    public void changeSelectedRecipe(int index) {
        if (index >= 0 && index < this.recipes.length) {
            this.selected = index;
            this.dirty = true;
        }
    }

    public void scrollSelection(boolean forward) {
        this.changeSelectedRecipe(this.selected + (forward ? 1 : -1));
    }

    public int getRecipeCount() {
        return this.recipeCount;
    }

    @Nonnull
    public CraftingRecipe getRecipe(int index) {
        if (index >= 0 && index < this.recipes.length) {
            return this.recipes[index];
        }
        return this.recipes[0];
    }

    @Nonnull
    public CraftingRecipe getSelectedRecipe() {
        return this.getRecipe(this.getSelection());
    }

    public void storeCraftingRecipe(int index, GuiContainer gui, Slot slot) {
        this.getRecipe(index).storeCraftingRecipe(gui, slot);
        this.dirty = true;
    }

    public void storeCraftingRecipeToCurrentSelection(GuiContainer gui, Slot slot) {
        this.storeCraftingRecipe(this.getSelection(), gui, slot);
    }

    public void clearRecipe(int index) {
        this.getRecipe(index).clearRecipe();
        this.dirty = true;
    }

    private void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null || !nbt.func_150297_b("Recipes", 9)) {
            return;
        }
        for (int i = 0; i < this.recipes.length; ++i) {
            this.recipes[i].clearRecipe();
        }
        NBTTagList tagList = nbt.func_150295_c("Recipes", 10);
        int count = tagList.func_74745_c();
        for (int i = 0; i < count; ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte index = tag.func_74771_c("RecipeIndex");
            if (index < 0 || index >= this.recipes.length) continue;
            this.recipes[index].readFromNBT(tag);
        }
        this.changeSelectedRecipe(nbt.func_74771_c("Selected"));
    }

    private NBTTagCompound writeToNBT(@Nonnull NBTTagCompound nbt) {
        NBTTagList tagRecipes = new NBTTagList();
        for (int i = 0; i < this.recipes.length; ++i) {
            if (!this.recipes[i].isValid()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("RecipeIndex", (byte)i);
            this.recipes[i].writeToNBT(tag);
            tagRecipes.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Recipes", (NBTBase)tagRecipes);
        nbt.func_74774_a("Selected", (byte)this.selected);
        return nbt;
    }

    private String getFileName() {
        String name = "recipes.nbt";
        if (!this.global) {
            if (Minecraft.func_71410_x().func_71356_B()) {
                IntegratedServer server = Minecraft.func_71410_x().func_71401_C();
                if (server != null) {
                    name = "recipes_" + server.func_71270_I() + ".nbt";
                }
            } else {
                ServerData server = Minecraft.func_71410_x().func_147104_D();
                if (server != null) {
                    name = "recipes_" + server.field_78845_b.replace(':', '_') + ".nbt";
                }
            }
        }
        return name;
    }

    private File getSaveDir() {
        return new File(Minecraft.func_71410_x().field_71412_D, "itemscroller");
    }

    public void readFromDisk() {
        if (!Configs.craftingScrollingSaveToFile) {
            return;
        }
        try {
            File file;
            File saveDir = this.getSaveDir();
            if (saveDir != null && (file = new File(saveDir, this.getFileName())).exists() && file.isFile()) {
                this.readFromNBT(CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file)));
            }
        }
        catch (Exception e) {
            ItemScroller.logger.warn("Failed to read recipes from file");
        }
    }

    public void writeToDisk() {
        if (!this.dirty || !Configs.craftingScrollingSaveToFile) {
            return;
        }
        try {
            File saveDir = this.getSaveDir();
            if (saveDir == null) {
                return;
            }
            if (!saveDir.exists() && !saveDir.mkdirs()) {
                ItemScroller.logger.warn("Failed to create the recipe storage directory '{}'", (Object)saveDir.getPath());
                return;
            }
            File fileTmp = new File(saveDir, this.getFileName() + ".tmp");
            File fileReal = new File(saveDir, this.getFileName());
            CompressedStreamTools.func_74799_a((NBTTagCompound)this.writeToNBT(new NBTTagCompound()), (OutputStream)new FileOutputStream(fileTmp));
            if (fileReal.exists()) {
                fileReal.delete();
            }
            fileTmp.renameTo(fileReal);
            this.dirty = false;
        }
        catch (Exception e) {
            ItemScroller.logger.warn("Failed to write recipes to file!");
        }
    }
}

