/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys;

import com.oitsjustjose.geolosys.blocks.BlockOre;
import com.oitsjustjose.geolosys.blocks.BlockOreVanilla;
import com.oitsjustjose.geolosys.blocks.BlockSample;
import com.oitsjustjose.geolosys.blocks.BlockSampleVanilla;
import com.oitsjustjose.geolosys.items.ItemCluster;
import com.oitsjustjose.geolosys.items.ItemIngot;
import com.oitsjustjose.geolosys.items.ItemProPick;
import com.oitsjustjose.geolosys.util.ClientRegistry;
import com.oitsjustjose.geolosys.util.Config;
import com.oitsjustjose.geolosys.util.ConfigParser;
import com.oitsjustjose.geolosys.util.HelperFunctions;
import com.oitsjustjose.geolosys.world.ChunkData;
import com.oitsjustjose.geolosys.world.OreGenerator;
import com.oitsjustjose.geolosys.world.StoneGenerator;
import com.oitsjustjose.geolosys.world.VanillaWorldGenOverride;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Logger;

@Mod(modid="geolosys", name="Geolosys", version="1.8", guiFactory="com.oitsjustjose.geolosys.util.ConfigGUI$GUIFactory", acceptedMinecraftVersions="1.12")
public class Geolosys {
    @Mod.Instance(value="geolosys")
    private static Geolosys instance;
    public Logger LOGGER;
    public Config config;
    public ClientRegistry clientRegistry;
    public ChunkData chunkOreGen;
    public ArrayList<IBlockState> userStates;
    public ConfigParser configParser;
    public Block ORE;
    public Block ORE_VANILLA;
    public Block ORE_SAMPLE;
    public Block ORE_SAMPLE_VANILLA;
    public Item CLUSTER;
    public Item INGOT;
    public Item PRO_PICK;

    public static Geolosys getInstance() {
        return instance;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.LOGGER = event.getModLog();
        this.config = new Config(event.getSuggestedConfigurationFile());
        MinecraftForge.EVENT_BUS.register((Object)this.config);
        this.clientRegistry = new ClientRegistry();
        MinecraftForge.EVENT_BUS.register((Object)this.clientRegistry);
        this.chunkOreGen = new ChunkData();
        this.userStates = new ArrayList();
        this.ORE = new BlockOre();
        this.ORE_VANILLA = new BlockOreVanilla();
        this.ORE_SAMPLE = new BlockSample();
        this.ORE_SAMPLE_VANILLA = new BlockSampleVanilla();
        this.CLUSTER = new ItemCluster();
        if (this.config.enableIngots) {
            this.INGOT = new ItemIngot();
        }
        if (this.config.enableProPick) {
            this.PRO_PICK = new ItemProPick();
        }
        this.registerGeolosysOreGen();
        this.registerVanillaOreGen();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.ORE_GEN_BUS.register((Object)new VanillaWorldGenOverride());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (this.config.enableSmelting) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(this.CLUSTER, 1, 0), (ItemStack)new ItemStack(Items.field_151042_j, 1, 0), (float)0.7f);
            GameRegistry.addSmelting((ItemStack)new ItemStack(this.CLUSTER, 1, 1), (ItemStack)new ItemStack(Items.field_151043_k, 1, 0), (float)1.0f);
            if (!this.config.enableIngots) {
                if (this.config.modIron) {
                    this.smeltSafely(new ItemStack(this.CLUSTER, 1, 0), "ingotIron");
                }
                if (this.config.modGold) {
                    this.smeltSafely(new ItemStack(this.CLUSTER, 1, 1), "ingotGold");
                }
                if (this.config.enableMalachite | this.config.enableAzurite) {
                    this.smeltSafely(new ItemStack(this.CLUSTER, 1, 2), "ingotCopper");
                }
                if (this.config.enableCassiterite || this.config.enableTeallite) {
                    this.smeltSafely(new ItemStack(this.CLUSTER, 1, 3), "ingotTin");
                }
                if (this.config.enableGalena) {
                    this.smeltSafely(new ItemStack(this.CLUSTER, 1, 4), "ingotSilver");
                    this.smeltSafely(new ItemStack(this.CLUSTER, 1, 5), "ingotLead");
                }
                if (this.config.enableBauxite) {
                    this.smeltSafely(new ItemStack(this.CLUSTER, 1, 6), "ingotAluminum");
                }
                if (this.config.enableLimonite) {
                    this.smeltSafely(new ItemStack(this.CLUSTER, 1, 7), "ingotNickel");
                }
                if (this.config.enablePlatinum) {
                    this.smeltSafely(new ItemStack(this.CLUSTER, 1, 8), "ingotPlatinum");
                }
            } else {
                for (int i = 0; i < ItemIngot.EnumType.values().length; ++i) {
                    GameRegistry.addSmelting((ItemStack)new ItemStack(this.CLUSTER, 1, i + 2), (ItemStack)new ItemStack(this.INGOT, 1, i), (float)0.7f);
                }
            }
        }
        this.configParser = new ConfigParser();
        this.registerUserOreGen();
        this.registerUserStoneGen();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new OreGenerator(), (int)0);
        GameRegistry.registerWorldGenerator((IWorldGenerator)new StoneGenerator(), (int)100);
    }

    private void smeltSafely(ItemStack input, String oreDictName) {
        try {
            GameRegistry.addSmelting((ItemStack)input, (ItemStack)((ItemStack)OreDictionary.getOres((String)oreDictName).get(0)), (float)0.7f);
        }
        catch (IndexOutOfBoundsException | NullPointerException ex) {
            System.out.println(oreDictName + " has not been added already. Smelting has been skipped.");
        }
    }

    private void registerVanillaOreGen() {
        if (this.config.modCoal) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 0), this.config.clusterSizeCoal, 48, 70, this.config.chanceCoal);
        }
        if (this.config.modRedstone) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 1), this.config.clusterSizeCinnabar, 5, 12, this.config.chanceCinnabar);
        }
        if (this.config.modGold) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 2), this.config.clusterSizeGold, 5, 30, this.config.chanceGold);
        }
        if (this.config.modLapis) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 3), this.config.clusterSizeLapis, 10, 24, this.config.chanceLapis);
        }
        if (this.config.modQuartz) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 4), this.config.clusterSizeQuartz, 6, 29, this.config.chanceQuartz);
        }
        if (this.config.modDiamond) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE_VANILLA, 5), this.config.clusterSizeKimberlite, 2, 15, this.config.chanceKimberlite);
        }
        if (this.config.modStones) {
            IBlockState diorite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE);
            IBlockState andesite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE);
            IBlockState granite = Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE);
            StoneGenerator.addStoneGen(andesite, 2, 70, 40);
            StoneGenerator.addStoneGen(diorite, 2, 70, 40);
            StoneGenerator.addStoneGen(granite, 2, 70, 40);
        }
    }

    private void registerGeolosysOreGen() {
        if (this.config.enableHematite) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 0), this.config.clusterSizeHematite, 32, 60, this.config.chanceHematite);
        }
        if (this.config.enableLimonite) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 1), this.config.clusterSizeLimonite, 6, 32, this.config.chanceLimonite);
        }
        if (this.config.enableMalachite) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 2), this.config.clusterSizeMalachite, 39, 44, this.config.chanceMalachite);
        }
        if (this.config.enableAzurite) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 3), this.config.clusterSizeAzurite, 12, 44, this.config.chanceAzurite);
        }
        if (this.config.enableCassiterite) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 4), this.config.clusterSizeCassiterite, 44, 68, this.config.chanceCassiterite);
        }
        if (this.config.enableTeallite) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 5), this.config.clusterSizeTeallite, 8, 43, this.config.chanceTeallite);
        }
        if (this.config.enableGalena) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 6), this.config.clusterSizeGalena, 16, 50, this.config.chanceGalena);
        }
        if (this.config.enableBauxite) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 7), this.config.clusterSizeBauxite, 45, 70, this.config.chanceBauxite);
        }
        if (this.config.enablePlatinum) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 8), this.config.clusterSizePlatinum, 3, 25, this.config.chancePlatinum);
        }
        if (this.config.enableAutunite) {
            OreGenerator.addOreGen(HelperFunctions.getStateFromMeta(this.ORE, 9), this.config.clusterSizeUranium, 8, 33, this.config.chanceUranium);
        }
    }

    private void registerUserOreGen() {
        for (ConfigParser.Entry e : this.configParser.getUserOreEntries().keySet()) {
            OreGenerator.addOreGen(e.getState(), e.getSize(), e.getMinY(), e.getMaxY(), e.getChancePerChunk());
            this.userStates.add(e.getState());
        }
    }

    private void registerUserStoneGen() {
        for (ConfigParser.Entry e : this.configParser.getUserStoneEntries()) {
            StoneGenerator.addStoneGen(e.getState(), e.getMinY(), e.getMaxY(), e.getChancePerChunk());
        }
    }
}

