/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.blocks;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.util.Config;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockOre
extends Block {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockOre() {
        super(Material.field_151576_e);
        this.setRegistryName(new ResourceLocation("geolosys", "ore"));
        this.func_149711_c(7.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)EnumType.HEMATITE)));
        this.func_149663_c(this.getRegistryName().toString().replaceAll(":", "."));
        this.setHarvestLevels();
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)new ItemBlockOre(this));
    }

    private void setHarvestLevels() {
        for (EnumType t : EnumType.values()) {
            this.setHarvestLevel("pickaxe", t.getToolLevel(), this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)t)));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Geolosys.getInstance().CLUSTER;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Config conf = Geolosys.getInstance().config;
        Item CLUSTER = Geolosys.getInstance().CLUSTER;
        if (state.func_177230_c().func_176201_c(state) == 1) {
            Random rand;
            int rng;
            if (conf.enableNickel && (rng = (rand = new Random()).nextInt(5)) == 0) {
                drops.add((Object)new ItemStack(CLUSTER, 1, 7));
            }
            drops.add((Object)new ItemStack(CLUSTER, 1, 0));
        } else if (state.func_177230_c().func_176201_c(state) == 6) {
            Random rand = new Random();
            int rng = rand.nextInt(2);
            if (rng == 0) {
                drops.add((Object)new ItemStack(CLUSTER, 1, 4));
                rng = rand.nextInt(2);
                if (rng == 0) {
                    drops.add((Object)new ItemStack(CLUSTER, 1, 5));
                }
            } else {
                drops.add((Object)new ItemStack(CLUSTER, 1, 5));
            }
        } else {
            drops.add((Object)new ItemStack(CLUSTER, 1, this.func_180651_a(state)));
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        int meta = state.func_177230_c().func_176201_c(state);
        switch (meta) {
            case 0: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 3;
            }
            case 7: {
                return 6;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
        }
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(state.func_177230_c(), 1, this.func_176201_c(state));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public class ItemBlockOre
    extends ItemBlock {
        ItemBlockOre(Block block) {
            super(block);
            this.func_77627_a(true);
            this.setRegistryName(block.getRegistryName());
            this.func_77656_e(0);
            this.registerModels();
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public String func_77667_c(ItemStack stack) {
            return stack.func_77973_b().getRegistryName().toString().replaceAll(":", ".") + "." + EnumType.byMetadata(stack.func_77960_j()).func_176610_l();
        }

        @SideOnly(value=Side.CLIENT)
        public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
            if (this.func_194125_a(tab)) {
                for (int i = 0; i < EnumType.values().length; ++i) {
                    list.add((Object)new ItemStack((Item)this, 1, i));
                }
            }
        }

        private void registerModels() {
            for (int i = 0; i < EnumType.values().length; ++i) {
                Geolosys.getInstance().clientRegistry.register(new ItemStack((Item)this, 1, i), VARIANT.func_177701_a() + "=" + EnumType.byMetadata(i).func_176610_l());
            }
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        HEMATITE(0, 1, "hematite", "hematite"),
        LIMONITE(1, 2, "limonite", "limonite"),
        MALACHITE(2, 1, "malachite", "malachite"),
        AZURITE(3, 1, "azurite", "azurite"),
        CASSITERITE(4, 1, "cassiterite", "cassiterite"),
        TEALLITE(5, 1, "teallite", "teallite"),
        GALENA(6, 2, "galena", "galena"),
        BAUXITE(7, 0, "bauxite", "bauxite"),
        PLATINUM(8, 2, "platinum", "platinum"),
        AUTUNITE(9, 2, "autunite", "autunite");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final int toolLevel;
        private final String serializedName;
        private final String unlocalizedName;

        private EnumType(int meta, int toolLevel, String name, String unlocalizedName) {
            this.meta = meta;
            this.toolLevel = toolLevel;
            this.serializedName = name;
            this.unlocalizedName = unlocalizedName;
        }

        public int getToolLevel() {
            return this.toolLevel;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.unlocalizedName;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.serializedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

