/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.items;

import com.oitsjustjose.geolosys.Geolosys;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemCluster
extends Item {
    public static final int META_IRON = 0;
    public static final int META_GOLD = 1;
    public static final int META_COPPER = 2;
    public static final int META_TIN = 3;
    public static final int META_SILVER = 4;
    public static final int META_LEAD = 5;
    public static final int META_ALUMINUM = 6;
    public static final int META_NICKEL = 7;
    public static final int META_PLATINUM = 8;
    public static final int META_URANIUM = 9;

    public ItemCluster() {
        this.func_77627_a(true);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.setRegistryName(new ResourceLocation("geolosys", "CLUSTER"));
        this.func_77655_b(this.getRegistryName().toString().replaceAll(":", "."));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        this.registerModels();
        this.registerOreDict();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < EnumType.values().length; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString().replaceAll(":", ".") + "." + EnumType.byMetadata(stack.func_77960_j()).func_176610_l();
    }

    private void registerModels() {
        for (int i = 0; i < EnumType.values().length; ++i) {
            Geolosys.getInstance().clientRegistry.register(new ItemStack((Item)this, 1, i), new ResourceLocation(this.getRegistryName().toString() + "_" + EnumType.byMetadata(i).name()), "inventory");
        }
    }

    private void registerOreDict() {
        for (int i = 0; i < EnumType.values().length; ++i) {
            OreDictionary.registerOre((String)("ore" + EnumType.byMetadata(i).func_176610_l().substring(0, 1).toUpperCase() + EnumType.byMetadata(i).func_176610_l().substring(1)), (ItemStack)new ItemStack((Item)this, 1, i));
        }
        if (Geolosys.getInstance().config.registerAsBauxite) {
            OreDictionary.registerOre((String)"oreBauxite", (ItemStack)new ItemStack((Item)this, 1, 6));
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        IRON(0, "iron"),
        GOLD(1, "gold"),
        COPPER(2, "copper"),
        TIN(3, "tin"),
        SILVER(4, "silver"),
        LEAD(5, "lead"),
        ALUMINUM(6, "aluminum"),
        NICKEL(7, "nickel"),
        PLATINUM(8, "platinum"),
        URANIUM(9, "uranium");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String serializedName;
        private final String unlocalizedName;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.serializedName = name;
            this.unlocalizedName = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.unlocalizedName;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.serializedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

