/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.items;

import com.oitsjustjose.geolosys.Geolosys;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemIngot
extends Item {
    public static final int META_COPPER = 0;
    public static final int META_TIN = 1;
    public static final int META_SILVER = 2;
    public static final int META_LEAD = 3;
    public static final int META_ALUMINUM = 4;
    public static final int META_NICKEL = 5;
    public static final int META_PLATINUM = 6;

    public ItemIngot() {
        this.func_77627_a(true);
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.setRegistryName(new ResourceLocation("geolosys", "INGOT"));
        this.func_77655_b(this.getRegistryName().toString().replaceAll(":", "."));
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        this.registerModels();
        this.registerOreDict();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < EnumType.values().length; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        return stack.func_77973_b().getRegistryName().toString().replaceAll(":", ".") + "." + EnumType.byMetadata(stack.func_77960_j()).func_176610_l();
    }

    private void registerModels() {
        for (int i = 0; i < EnumType.values().length; ++i) {
            Geolosys.getInstance().clientRegistry.register(new ItemStack((Item)this, 1, i), new ResourceLocation(this.getRegistryName().toString() + "_" + EnumType.byMetadata(i).name()), "inventory");
        }
    }

    private void registerOreDict() {
        for (int i = 0; i < EnumType.values().length; ++i) {
            OreDictionary.registerOre((String)("ingot" + EnumType.byMetadata(i).func_176610_l().substring(0, 1).toUpperCase() + EnumType.byMetadata(i).func_176610_l().substring(1)), (ItemStack)new ItemStack((Item)this, 1, i));
        }
    }

    public static enum EnumType implements IStringSerializable
    {
        COPPER(0, "copper"),
        TIN(1, "tin"),
        SILVER(2, "silver"),
        LEAD(3, "lead"),
        ALUMINUM(4, "aluminum"),
        NICKEL(5, "nickel"),
        PLATINUM(6, "platinum");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String serializedName;
        private final String unlocalizedName;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.serializedName = name;
            this.unlocalizedName = name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.unlocalizedName;
        }

        public static EnumType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.serializedName;
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType type;
                EnumType.META_LOOKUP[type.getMetadata()] = type = enumTypeArray[i];
            }
        }
    }
}

