/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.util;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    public Configuration config;
    public ConfigCategory FeatureControl;
    public ConfigCategory Chances;
    public ConfigCategory Sizes;
    public ConfigCategory Samples;
    public ConfigCategory UserEntries;
    public boolean modIron;
    public boolean modGold;
    public boolean modDiamond;
    public boolean modCoal;
    public boolean modRedstone;
    public boolean modLapis;
    public boolean modQuartz;
    public boolean modStones;
    public boolean enableHematite;
    public boolean enableLimonite;
    public boolean enableNickel;
    public boolean enableMalachite;
    public boolean enableAzurite;
    public boolean enableCassiterite;
    public boolean enableTeallite;
    public boolean enableGalena;
    public boolean enableBauxite;
    public boolean enableAutunite;
    public boolean enablePlatinum;
    public boolean enableIngots;
    public boolean enableProPick;
    public boolean enableSmelting;
    public boolean registerAsBauxite;
    public int chanceCoal;
    public int chanceCinnabar;
    public int chanceGold;
    public int chanceLapis;
    public int chanceQuartz;
    public int chanceKimberlite;
    public int chanceHematite;
    public int chanceLimonite;
    public int chanceMalachite;
    public int chanceAzurite;
    public int chanceCassiterite;
    public int chanceTeallite;
    public int chanceGalena;
    public int chanceBauxite;
    public int chancePlatinum;
    public int chanceUranium;
    public int chanceSample;
    public boolean generateSamplesInWater;
    public boolean boringSamples;
    public int clusterSizeCoal;
    public int clusterSizeCinnabar;
    public int clusterSizeGold;
    public int clusterSizeLapis;
    public int clusterSizeQuartz;
    public int clusterSizeKimberlite;
    public int clusterSizeHematite;
    public int clusterSizeLimonite;
    public int clusterSizeMalachite;
    public int clusterSizeAzurite;
    public int clusterSizeCassiterite;
    public int clusterSizeTeallite;
    public int clusterSizeGalena;
    public int clusterSizeBauxite;
    public int clusterSizePlatinum;
    public int clusterSizeUranium;
    public String[] userOreEntriesRaw;
    public String[] userStoneEntriesRaw;
    public int[] blacklistedDIMs;

    public Config(File configFile) {
        if (this.config == null) {
            this.config = new Configuration(configFile, null, true);
            this.loadConfiguration();
        }
    }

    void loadConfiguration() {
        String category = "Feature Control";
        ArrayList propertyOrder = Lists.newArrayList();
        this.FeatureControl = this.config.getCategory(category).setRequiresMcRestart(true);
        this.FeatureControl.setComment("Control which features are enabled:");
        Property property = this.config.get(category, "Replace Vanilla Iron Ore Gen", true);
        this.modIron = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Replace Gold Deposits", true);
        this.modGold = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Replace Diamond Deposits with Kimberlite", true);
        this.modDiamond = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Replace Coal Deposits", true);
        this.modCoal = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Replace Redstone Deposits with Cinnabar", true);
        this.modRedstone = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Replace Lapis Deposits", true);
        this.modLapis = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Replace Quartz Deposits", true);
        property.setComment("Also adds Certus and Black Quartz drops");
        this.modQuartz = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Replace Stone Variant Deposits", true);
        this.modStones = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Hematite", true);
        this.enableHematite = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Limonite", true);
        this.enableLimonite = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Nickel Drops from Limonite", true);
        this.enableNickel = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Malachite", true);
        this.enableMalachite = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Azurite", true);
        this.enableAzurite = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Cassiterite", true);
        this.enableCassiterite = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Teallite", true);
        this.enableTeallite = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Galena", true);
        this.enableGalena = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Bauxite", true);
        this.enableBauxite = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Autunite", true);
        this.enableAutunite = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Platinum", true);
        this.enablePlatinum = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Ingots", true);
        property.setComment("Set to \"False\" if other mods already provide all necessary ORE variants.");
        this.enableIngots = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Prospector's Pick", true);
        property.setComment("Set to \"False\" if you don't wish to have this feature, or have another mod doing it");
        this.enableProPick = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Enable Cluster Smelting", true);
        property.setComment("Set to \"False\" if you don't want smelting automatically initialized");
        this.enableSmelting = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Also register Aluminum Cluster as oreBauxite", false);
        property.setComment("Meant as a layer of compatibility for mods like TechReborn. Adds \"oreBauxite\" as one of the entries for the Aluminum Cluster");
        this.registerAsBauxite = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Blacklisted Dimensions", new int[]{-1, 1}, "Dimensions that ores CAN'T generate in");
        this.blacklistedDIMs = property.getIntList();
        propertyOrder.add(property.getName());
        this.FeatureControl.setPropertyOrder((List)propertyOrder);
        category = "Ore Gen Chances";
        propertyOrder = Lists.newArrayList();
        this.Chances = this.config.getCategory(category).setRequiresMcRestart(true);
        this.Chances.setComment("The % chance for a pluton to generate in a chunk");
        property = this.config.get(category, "Coal Pluton Chance Per Chunk", 8);
        this.chanceCoal = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Cinnabar Pluton Chance Per Chunk", 3);
        this.chanceCinnabar = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Gold Pluton Chance Per Chunk", 3);
        this.chanceGold = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Lapis Pluton Chance Per Chunk", 4);
        this.chanceLapis = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Quartz Pluton Chance Per Chunk", 6);
        this.chanceQuartz = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Kimberlite Pluton Chance Per Chunk", 4);
        this.chanceKimberlite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Hematite Pluton Chance Per Chunk", 4);
        this.chanceHematite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Limonite Pluton Chance Per Chunk", 6);
        this.chanceLimonite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Malachite Pluton Chance Per Chunk", 4);
        this.chanceMalachite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Azurite Pluton Chance Per Chunk", 7);
        this.chanceAzurite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Cassiterite Pluton Chance Per Chunk", 3);
        this.chanceCassiterite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Teallite Pluton Chance Per Chunk", 7);
        this.chanceTeallite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Galena Pluton Chance Per Chunk", 10);
        this.chanceGalena = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Bauxite Pluton Chance Per Chunk", 9);
        this.chanceBauxite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Platinum Pluton Chance Per Chunk", 4);
        this.chancePlatinum = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Autunite Pluton Chance Per Chunk", 5);
        this.chanceUranium = property.getInt();
        propertyOrder.add(property.getName());
        this.Chances.setPropertyOrder((List)propertyOrder);
        category = "Ore Cluster Sizes";
        propertyOrder = Lists.newArrayList();
        this.Sizes = this.config.getCategory(category).setRequiresMcRestart(true);
        this.Sizes.setComment("The number of ores found in each CLUSTER");
        property = this.config.get(category, "Coal Cluster Size", 64);
        this.clusterSizeCoal = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Cinnabar Cluster Size", 56);
        this.clusterSizeCinnabar = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Gold Cluster Size", 40);
        this.clusterSizeGold = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Lapis Cluster Size", 32);
        this.clusterSizeLapis = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Quartz Cluster Size", 40);
        this.clusterSizeQuartz = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Kimberlite Cluster Size", 20);
        this.clusterSizeKimberlite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Hematite Cluster Size", 24);
        this.clusterSizeHematite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Limonite Cluster Size", 80);
        this.clusterSizeLimonite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Malachite Cluster Size", 24);
        this.clusterSizeMalachite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Azurite Cluster Size", 80);
        this.clusterSizeAzurite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Cassiterite Cluster Size", 24);
        this.clusterSizeCassiterite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Teallite Cluster Size", 80);
        this.clusterSizeTeallite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Galena Cluster Size", 72);
        this.clusterSizeGalena = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Bauxite Cluster Size", 64);
        this.clusterSizeBauxite = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Platinum Cluster Size", 32);
        this.clusterSizePlatinum = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Autunite Cluster Size", 24);
        this.clusterSizeUranium = property.getInt();
        propertyOrder.add(property.getName());
        this.Sizes.setPropertyOrder((List)propertyOrder);
        category = "Ore Samples";
        propertyOrder = Lists.newArrayList();
        this.Samples = this.config.getCategory(category).setRequiresMcRestart(true);
        this.Samples.setComment("Settings strictly regarding samples");
        property = this.config.get(category, "Random Chance of Samples per Chunk", 4, "The maximum number of samples that can generate per chunk", 1, 16);
        this.chanceSample = property.getInt();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Allow samples to spawn in water (shallow or deep)", false);
        this.generateSamplesInWater = property.getBoolean();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Samples drop nothing, instead reveal their contents via chat", false);
        this.boringSamples = property.getBoolean();
        propertyOrder.add(property.getName());
        this.Samples.setPropertyOrder((List)propertyOrder);
        category = "User Entries";
        propertyOrder = Lists.newArrayList();
        this.UserEntries = this.config.getCategory(category).setRequiresMcRestart(true);
        this.UserEntries.setComment("It is STRONGLY suggested you use the ConfigGUI for this.");
        property = this.config.get(category, "Custom Ore Entries", new String[0]);
        property.setComment("Format is:\nmodid:block:meta, clusterSize, min Y, max Y, chance to gen in chunk. Example:\nactuallyadditions:block_misc:3, 32, 13, 42, 20\nOptionally you can declare your own \"sample\" block by appending an extra modid:block:meta to the end. Example:\nactuallyadditions:block_misc:3, 32, 13, 42, 20, actuallyadditions:block_misc:1\nMETA, COLONS AND COMMAS ARE REQUIRED.");
        this.userOreEntriesRaw = property.getStringList();
        propertyOrder.add(property.getName());
        property = this.config.get(category, "Custom Stone Entries", new String[0]);
        property.setComment("Format is:\nmodid:block:meta, min Y, max Y, chance to gen in chunk\nALL CLUSTERS ARE APPROX. THE SAME SIZE & AREN'T CONFIGURABLE.\nMETA, COLONS AND COMMAS ARE REQUIRED. Example:\nrustic:slate:0, 27, 54, 10");
        this.userStoneEntriesRaw = property.getStringList();
        propertyOrder.add(property.getName());
        this.UserEntries.setPropertyOrder((List)propertyOrder);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    @SubscribeEvent
    public void update(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("geolosys")) {
            this.loadConfiguration();
        }
    }
}

