/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.util;

import com.google.common.collect.Lists;
import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.util.HelperFunctions;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ConfigParser {
    private HashMap<Entry, IBlockState> userOreEntriesClean = new HashMap();
    private List<Entry> userStoneEntriesClean;

    public ConfigParser() {
        this.parseOres();
        this.userStoneEntriesClean = Lists.newArrayList();
        this.parseStones();
    }

    public void parseOres() {
        for (String s : Geolosys.getInstance().config.userOreEntriesRaw) {
            String[] parts = s.trim().replaceAll(" ", "").split("[\\W]");
            if (parts.length != 7 && parts.length != 10) {
                this.printFormattingError(s);
                continue;
            }
            try {
                Block oreBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0], parts[1]));
                if (oreBlock == null || oreBlock == Blocks.field_150350_a) {
                    this.printFormattingError(s);
                    continue;
                }
                IBlockState oreState = HelperFunctions.getStateFromMeta(oreBlock, this.toInt(parts[2]));
                Entry oreEntry = new Entry(oreState, this.toInt(parts[3]), this.toInt(parts[4]), this.toInt(parts[5]), this.toInt(parts[6]));
                if (parts.length == 7) {
                    this.userOreEntriesClean.put(oreEntry, oreState);
                    continue;
                }
                Block sampleBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[7], parts[8]));
                if (sampleBlock == null || sampleBlock == Blocks.field_150350_a) {
                    this.printFormattingError(s);
                    continue;
                }
                IBlockState sampleState = HelperFunctions.getStateFromMeta(sampleBlock, this.toInt(parts[9]));
                this.userOreEntriesClean.put(oreEntry, sampleState);
            }
            catch (NumberFormatException e) {
                this.printFormattingError(s);
            }
        }
    }

    public void parseStones() {
        for (String s : Geolosys.getInstance().config.userStoneEntriesRaw) {
            String[] parts = s.trim().replaceAll(" ", "").split("[\\W]");
            if (parts.length != 6) {
                this.printFormattingError(s);
                continue;
            }
            try {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(parts[0], parts[1]));
                if (block == null || block == Blocks.field_150350_a) {
                    this.printFormattingError(s);
                    continue;
                }
                IBlockState tempState = block.getStateForPlacement(null, null, null, 0.0f, 0.0f, 0.0f, this.toInt(parts[2]), null, null);
                this.userStoneEntriesClean.add(new Entry(tempState, 0, this.toInt(parts[3]), this.toInt(parts[4]), this.toInt(parts[5])));
            }
            catch (NumberFormatException e) {
                this.printFormattingError(s);
            }
        }
    }

    private int toInt(String s) {
        return Integer.parseInt(s);
    }

    private void printFormattingError(String s) {
        Geolosys.getInstance().LOGGER.info("Entry " + s + " is not valid and has been skipped. Please check your formatting.");
    }

    public HashMap<Entry, IBlockState> getUserOreEntries() {
        return this.userOreEntriesClean;
    }

    public boolean blockstateExistsInEntries(IBlockState state) {
        for (Entry e : this.userOreEntriesClean.keySet()) {
            if (e.getState() != state) continue;
            return true;
        }
        return false;
    }

    public IBlockState getSampleForState(IBlockState state) {
        for (Entry e : this.userOreEntriesClean.keySet()) {
            if (e.getState() != state) continue;
            return this.userOreEntriesClean.get(e);
        }
        return null;
    }

    public List<Entry> getUserStoneEntries() {
        return this.userStoneEntriesClean;
    }

    public class Entry {
        private IBlockState state;
        private int size;
        private int minY;
        private int maxY;
        private int chancePerChunk;

        public Entry(IBlockState state, int size, int minY, int maxY, int chancePerChunk) {
            this.state = state;
            this.size = size;
            this.minY = minY;
            this.maxY = maxY;
            this.chancePerChunk = chancePerChunk;
            this.sanitizeEntries();
        }

        private void sanitizeEntries() {
            if (this.minY < 0) {
                this.minY = 0;
            }
            if (this.maxY > 255) {
                this.maxY = 255;
            }
            if (this.chancePerChunk < 1) {
                this.chancePerChunk = 1;
            }
        }

        public IBlockState getState() {
            return this.state;
        }

        public int getSize() {
            return this.size;
        }

        public int getMinY() {
            return this.minY;
        }

        public int getMaxY() {
            return this.maxY;
        }

        public int getChancePerChunk() {
            return this.chancePerChunk;
        }
    }
}

