/*
 * Decompiled with CFR 0.152.
 */
package com.oitsjustjose.geolosys.world;

import com.oitsjustjose.geolosys.Geolosys;
import com.oitsjustjose.geolosys.world.WorldGenStonePluton;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;

public class StoneGenerator
implements IWorldGenerator {
    public static ArrayList<StoneGen> stonespawnList = new ArrayList();

    public static StoneGen addStoneGen(IBlockState state, int minY, int maxY, int weight) {
        StoneGen gen = new StoneGen(state, minY, maxY, weight);
        stonespawnList.add(gen);
        return gen;
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (!this.isDIMBlacklisted(world.field_73011_w.getDimension()) && stonespawnList.size() > 0) {
            stonespawnList.get(random.nextInt(stonespawnList.size())).generate(world, random, chunkX * 16, chunkZ * 16);
        }
    }

    public boolean isDIMBlacklisted(int dim) {
        for (int d : Geolosys.getInstance().config.blacklistedDIMs) {
            if (d != dim) continue;
            return true;
        }
        return false;
    }

    public static class StoneGen {
        WorldGenStonePluton pluton;
        IBlockState state;
        int minY;
        int maxY;
        int weight;

        public StoneGen(IBlockState state, int minY, int maxY, int weight) {
            this.pluton = new WorldGenStonePluton(state, 96);
            this.state = state;
            this.minY = minY;
            this.maxY = maxY;
            this.weight = weight;
        }

        public void generate(World world, Random rand, int x, int z) {
            if (!Geolosys.getInstance().chunkOreGen.canGenerateInChunk(new ChunkPos(x / 16, z / 16))) {
                return;
            }
            if (rand.nextInt(100) < this.weight) {
                this.pluton.func_180709_b(world, rand, new BlockPos(x + 8, this.minY + rand.nextInt(this.maxY - this.minY), z + 8));
            }
        }
    }
}

