/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest.common.tileentity.chest;

import cpw.mods.ironchest.IronChest;
import cpw.mods.ironchest.common.blocks.chest.BlockIronChest;
import cpw.mods.ironchest.common.blocks.chest.IronChestType;
import cpw.mods.ironchest.common.core.IronChestBlocks;
import cpw.mods.ironchest.common.gui.chest.ContainerIronChest;
import cpw.mods.ironchest.common.network.MessageCrystalChestSync;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TileEntityIronChest
extends TileEntityLockableLoot
implements ITickable {
    public NonNullList<ItemStack> chestContents;
    private NonNullList<ItemStack> topStacks;
    public float lidAngle;
    public float prevLidAngle;
    public int numPlayersUsing;
    private int ticksSinceSync;
    private EnumFacing facing;
    private boolean inventoryTouched;
    private boolean hadStuff;
    private String customName;
    private IronChestType chestType;

    public TileEntityIronChest() {
        this(IronChestType.IRON);
    }

    protected TileEntityIronChest(IronChestType type) {
        this.chestType = type;
        this.chestContents = NonNullList.func_191197_a((int)type.size, (Object)ItemStack.field_190927_a);
        this.topStacks = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
        this.facing = EnumFacing.NORTH;
    }

    public void setContents(NonNullList<ItemStack> contents) {
        this.chestContents = NonNullList.func_191197_a((int)this.getType().size, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < contents.size(); ++i) {
            if (i >= this.chestContents.size()) continue;
            this.func_190576_q().set(i, contents.get(i));
        }
        this.inventoryTouched = true;
    }

    public int func_70302_i_() {
        return this.func_190576_q().size();
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public IronChestType getType() {
        IBlockState state;
        IronChestType type = IronChestType.IRON;
        if (this.func_145830_o() && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == IronChestBlocks.ironChestBlock) {
            type = (IronChestType)((Object)state.func_177229_b(BlockIronChest.VARIANT_PROP));
        }
        return type;
    }

    public ItemStack func_70301_a(int index) {
        this.func_184281_d(null);
        this.inventoryTouched = true;
        return (ItemStack)this.func_190576_q().get(index);
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.sortTopStacks();
    }

    protected void sortTopStacks() {
        int i;
        if (!this.getType().isTransparent() || this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            return;
        }
        NonNullList tempCopy = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        boolean hasStuff = false;
        int compressedIdx = 0;
        block0: for (i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemStack = (ItemStack)this.func_190576_q().get(i);
            if (itemStack.func_190926_b()) continue;
            for (int j = 0; j < compressedIdx; ++j) {
                ItemStack tempCopyStack = (ItemStack)tempCopy.get(j);
                if (!ItemStack.func_185132_d((ItemStack)tempCopyStack, (ItemStack)itemStack)) continue;
                if (itemStack.func_190916_E() == tempCopyStack.func_190916_E()) continue block0;
                tempCopyStack.func_190917_f(itemStack.func_190916_E());
                continue block0;
            }
            tempCopy.set(compressedIdx, (Object)itemStack.func_77946_l());
            ++compressedIdx;
            hasStuff = true;
        }
        if (!hasStuff && this.hadStuff) {
            this.hadStuff = false;
            for (i = 0; i < this.getTopItems().size(); ++i) {
                this.getTopItems().set(i, (Object)ItemStack.field_190927_a);
            }
            if (this.field_145850_b != null) {
                IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
            }
            return;
        }
        this.hadStuff = true;
        Collections.sort(tempCopy, new Comparator<ItemStack>(){

            @Override
            public int compare(ItemStack stack1, ItemStack stack2) {
                if (stack1.func_190926_b()) {
                    return 1;
                }
                if (stack2.func_190926_b()) {
                    return -1;
                }
                return stack2.func_190916_E() - stack1.func_190916_E();
            }
        });
        int p = 0;
        for (ItemStack element : tempCopy) {
            if (element.func_190926_b() || element.func_190916_E() <= 0) continue;
            if (p == this.getTopItems().size()) break;
            this.getTopItems().set(p, (Object)element);
            ++p;
        }
        for (int i2 = p; i2 < this.getTopItems().size(); ++i2) {
            this.getTopItems().set(i2, (Object)ItemStack.field_190927_a);
        }
        if (this.field_145850_b != null) {
            IBlockState iblockstate = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, iblockstate, iblockstate, 3);
        }
        this.sendTopStacksPacket();
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : this.getType().name();
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void func_190575_a(String name) {
        this.customName = name;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.chestContents = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
        if (!this.func_184283_b(compound)) {
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.chestContents);
        }
        this.facing = EnumFacing.field_82609_l[compound.func_74771_c("facing")];
        this.sortTopStacks();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (!this.func_184282_c(compound)) {
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.chestContents);
        }
        compound.func_74774_a("facing", (byte)this.facing.ordinal());
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.numPlayersUsing != 0 && (this.ticksSinceSync + this.field_174879_c.func_177958_n() + this.field_174879_c.func_177956_o() + this.field_174879_c.func_177952_p()) % 200 == 0) {
            this.numPlayersUsing = 0;
            float f = 5.0f;
            for (EntityPlayer player : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - f), (double)((float)this.field_174879_c.func_177956_o() - f), (double)((float)this.field_174879_c.func_177952_p() - f), (double)((float)(this.field_174879_c.func_177958_n() + 1) + f), (double)((float)(this.field_174879_c.func_177956_o() + 1) + f), (double)((float)(this.field_174879_c.func_177952_p() + 1) + f)))) {
                if (!(player.field_71070_bA instanceof ContainerIronChest)) continue;
                ++this.numPlayersUsing;
            }
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.ticksSinceSync < 0) {
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChestBlocks.ironChestBlock, 3, this.numPlayersUsing << 3 & 0xF8 | this.facing.ordinal() & 7);
        }
        if (!this.field_145850_b.field_72995_K && this.inventoryTouched) {
            this.inventoryTouched = false;
            this.sortTopStacks();
        }
        ++this.ticksSinceSync;
        this.prevLidAngle = this.lidAngle;
        float angle = 0.1f;
        if (this.numPlayersUsing > 0 && this.lidAngle == 0.0f) {
            double x = (double)this.field_174879_c.func_177958_n() + 0.5;
            double y = (double)this.field_174879_c.func_177956_o() + 0.5;
            double z = (double)this.field_174879_c.func_177952_p() + 0.5;
            this.field_145850_b.func_184148_a(null, x, y, z, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing == 0 && this.lidAngle > 0.0f || this.numPlayersUsing > 0 && this.lidAngle < 1.0f) {
            float maxAngle;
            float currentAngle = this.lidAngle;
            this.lidAngle = this.numPlayersUsing > 0 ? (this.lidAngle += angle) : (this.lidAngle -= angle);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < (maxAngle = 0.5f) && currentAngle >= maxAngle) {
                double x = (double)this.field_174879_c.func_177958_n() + 0.5;
                double y = (double)this.field_174879_c.func_177956_o() + 0.5;
                double z = (double)this.field_174879_c.func_177952_p() + 0.5;
                this.field_145850_b.func_184148_a(null, x, y, z, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
        } else if (id == 2) {
            this.facing = EnumFacing.field_82609_l[type];
        } else if (id == 3) {
            this.facing = EnumFacing.field_82609_l[type & 7];
            this.numPlayersUsing = (type & 0xF8) >> 3;
        }
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.field_145850_b == null) {
                return;
            }
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChestBlocks.ironChestBlock, 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, (Block)IronChestBlocks.ironChestBlock, false);
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), (Block)IronChestBlocks.ironChestBlock, false);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.field_145850_b == null) {
                return;
            }
            --this.numPlayersUsing;
            this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChestBlocks.ironChestBlock, 1, this.numPlayersUsing);
            this.field_145850_b.func_175685_c(this.field_174879_c, (Block)IronChestBlocks.ironChestBlock, false);
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), (Block)IronChestBlocks.ironChestBlock, false);
        }
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("facing", (byte)this.facing.ordinal());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (pkt.func_148853_f() == 0) {
            NBTTagCompound compound = pkt.func_148857_g();
            this.facing = EnumFacing.field_82609_l[compound.func_74771_c("facing")];
        }
    }

    public NonNullList<ItemStack> buildItemStackDataList() {
        if (this.getType().isTransparent()) {
            NonNullList sortList = NonNullList.func_191197_a((int)this.getTopItems().size(), (Object)ItemStack.field_190927_a);
            int pos = 0;
            for (ItemStack is : this.topStacks) {
                if (!is.func_190926_b()) {
                    sortList.set(pos, (Object)is);
                } else {
                    sortList.set(pos, (Object)ItemStack.field_190927_a);
                }
                ++pos;
            }
            return sortList;
        }
        return NonNullList.func_191197_a((int)this.getTopItems().size(), (Object)ItemStack.field_190927_a);
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.getType().acceptsStack(stack);
    }

    public void rotateAround() {
        this.setFacing(this.facing.func_176746_e());
        this.field_145850_b.func_175641_c(this.field_174879_c, (Block)IronChestBlocks.ironChestBlock, 2, this.facing.ordinal());
    }

    public void wasPlaced(EntityLivingBase entityliving, ItemStack stack) {
    }

    public void removeAdornments() {
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        this.func_184281_d(playerIn);
        return new ContainerIronChest((IInventory)playerInventory, (IInventory)this, this.chestType, this.chestType.xSize, this.chestType.ySize);
    }

    public String func_174875_k() {
        return "IronChest:" + this.getType().name() + "_chest";
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.chestContents;
    }

    public NonNullList<ItemStack> getTopItems() {
        return this.topStacks;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.chestContents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    protected void sendTopStacksPacket() {
        NonNullList<ItemStack> stacks = this.buildItemStackDataList();
        IronChest.packetHandler.sendToAllAround((IMessage)new MessageCrystalChestSync(this, stacks), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 128.0));
    }

    public void receiveMessageFromServer(NonNullList<ItemStack> topStacks) {
        this.topStacks = topStacks;
    }
}

