/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.block;

import cofh.core.block.BlockCore;
import cofh.core.render.IModelRegister;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.block.ItemBlockOre;
import cofh.thermalfoundation.item.ItemMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockOre
extends BlockCore
implements IInitializer,
IModelRegister {
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"type", Type.class);
    public static ItemStack oreCopper;
    public static ItemStack oreTin;
    public static ItemStack oreSilver;
    public static ItemStack oreLead;
    public static ItemStack oreAluminum;
    public static ItemStack oreNickel;
    public static ItemStack orePlatinum;
    public static ItemStack oreIridium;
    public static ItemStack oreMithril;

    public BlockOre() {
        super(Material.field_151576_e, "thermalfoundation");
        this.func_149663_c("ore");
        this.func_149647_a(ThermalFoundation.tabCommon);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)Type.COPPER)));
        this.setHarvestLevel("pickaxe", 2);
        this.setHarvestLevel("pickaxe", 1, this.func_176203_a(Type.COPPER.getMetadata()));
        this.setHarvestLevel("pickaxe", 1, this.func_176203_a(Type.TIN.getMetadata()));
        this.setHarvestLevel("pickaxe", 1, this.func_176203_a(Type.ALUMINUM.getMetadata()));
        this.setHarvestLevel("pickaxe", 3, this.func_176203_a(Type.PLATINUM.getMetadata()));
        this.setHarvestLevel("pickaxe", 3, this.func_176203_a(Type.IRIDIUM.getMetadata()));
        this.setHarvestLevel("pickaxe", 3, this.func_176203_a(Type.MITHRIL.getMetadata()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.METADATA_LOOKUP.length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).getLight();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < Type.values().length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + this.name, "type=" + Type.byMetadata(i).func_176610_l()));
        }
    }

    public boolean initialize() {
        this.setRegistryName("ore");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlockOre itemBlock = new ItemBlockOre((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        oreCopper = new ItemStack((Block)this, 1, Type.COPPER.getMetadata());
        oreTin = new ItemStack((Block)this, 1, Type.TIN.getMetadata());
        oreSilver = new ItemStack((Block)this, 1, Type.SILVER.getMetadata());
        oreLead = new ItemStack((Block)this, 1, Type.LEAD.getMetadata());
        oreAluminum = new ItemStack((Block)this, 1, Type.ALUMINUM.getMetadata());
        oreNickel = new ItemStack((Block)this, 1, Type.NICKEL.getMetadata());
        orePlatinum = new ItemStack((Block)this, 1, Type.PLATINUM.getMetadata());
        oreIridium = new ItemStack((Block)this, 1, Type.IRIDIUM.getMetadata());
        oreMithril = new ItemStack((Block)this, 1, Type.MITHRIL.getMetadata());
        ItemHelper.registerWithHandlers((String)"oreCopper", (ItemStack)oreCopper);
        ItemHelper.registerWithHandlers((String)"oreTin", (ItemStack)oreTin);
        ItemHelper.registerWithHandlers((String)"oreSilver", (ItemStack)oreSilver);
        ItemHelper.registerWithHandlers((String)"oreLead", (ItemStack)oreLead);
        ItemHelper.registerWithHandlers((String)"oreAluminum", (ItemStack)oreAluminum);
        ItemHelper.registerWithHandlers((String)"oreNickel", (ItemStack)oreNickel);
        ItemHelper.registerWithHandlers((String)"orePlatinum", (ItemStack)orePlatinum);
        ItemHelper.registerWithHandlers((String)"oreIridium", (ItemStack)oreIridium);
        ItemHelper.registerWithHandlers((String)"oreMithril", (ItemStack)oreMithril);
        ThermalFoundation.proxy.addIModelRegister(this);
        return true;
    }

    public boolean register() {
        RecipeHelper.addSmelting((ItemStack)oreCopper, (ItemStack)ItemMaterial.ingotCopper, (float)0.6f);
        RecipeHelper.addSmelting((ItemStack)oreTin, (ItemStack)ItemMaterial.ingotTin, (float)0.7f);
        RecipeHelper.addSmelting((ItemStack)oreSilver, (ItemStack)ItemMaterial.ingotSilver, (float)0.9f);
        RecipeHelper.addSmelting((ItemStack)oreLead, (ItemStack)ItemMaterial.ingotLead, (float)0.8f);
        RecipeHelper.addSmelting((ItemStack)oreNickel, (ItemStack)ItemMaterial.ingotNickel, (float)1.0f);
        RecipeHelper.addSmelting((ItemStack)orePlatinum, (ItemStack)ItemMaterial.ingotPlatinum, (float)1.0f);
        if (!Loader.isModLoaded((String)"thermalexpansion")) {
            RecipeHelper.addSmelting((ItemStack)oreAluminum, (ItemStack)ItemMaterial.ingotAluminum, (float)0.6f);
            RecipeHelper.addSmelting((ItemStack)oreIridium, (ItemStack)ItemMaterial.ingotIridium, (float)1.2f);
            RecipeHelper.addSmelting((ItemStack)oreMithril, (ItemStack)ItemMaterial.ingotMithril, (float)1.5f);
        }
        return true;
    }

    public static enum Type implements IStringSerializable
    {
        COPPER(0, "copper"),
        TIN(1, "tin"),
        SILVER(2, "silver", 4),
        LEAD(3, "lead"),
        ALUMINUM(4, "aluminum"),
        NICKEL(5, "nickel"),
        PLATINUM(6, "platinum", 4, EnumRarity.UNCOMMON),
        IRIDIUM(7, "iridium", 4, EnumRarity.UNCOMMON),
        MITHRIL(8, "mithril", 8, EnumRarity.RARE);

        private static final Type[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final int light;
        private final EnumRarity rarity;

        private Type(int metadata, String name, int light, EnumRarity rarity) {
            this.metadata = metadata;
            this.name = name;
            this.light = light;
            this.rarity = rarity;
        }

        private Type(int metadata, String name, int light) {
            this(metadata, name, light, EnumRarity.COMMON);
        }

        private Type(int metadata, String name) {
            this(metadata, name, 0, EnumRarity.COMMON);
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getLight() {
            return this.light;
        }

        public EnumRarity getRarity() {
            return this.rarity;
        }

        public static Type byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        static {
            METADATA_LOOKUP = new Type[Type.values().length];
            Type[] typeArray = Type.values();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type;
                Type.METADATA_LOOKUP[type.getMetadata()] = type = typeArray[i];
            }
        }
    }
}

