/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.fluid;

import cofh.core.fluid.BlockFluidCore;
import cofh.core.util.CoreUtils;
import cofh.core.util.helpers.ServerHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFFluids;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockFluidEnder
extends BlockFluidCore {
    public static final int LEVELS = 4;
    public static final Material materialFluidEnder = new MaterialLiquid(MapColor.field_151651_C);
    private static boolean effect = true;

    public BlockFluidEnder(Fluid fluid) {
        super(fluid, materialFluidEnder, "thermalfoundation", "ender");
        this.setQuantaPerBlock(4);
        this.setTickRate(20);
        this.func_149711_c(2000.0f);
        this.func_149713_g(7);
        this.setParticleColor(0.05f, 0.2f, 0.2f);
    }

    public static void config() {
        String category = "Fluid.Ender";
        String comment = "If TRUE, Fluid Ender will randomly teleport entities on contact.";
        effect = ThermalFoundation.CONFIG.getConfiguration().getBoolean("Effect", category, effect, comment);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        BlockPos randPos;
        if (!effect || ServerHelper.isClientWorld((World)world)) {
            return;
        }
        if (world.func_82737_E() % 8L == 0L && !world.func_180495_p(randPos = pos.func_177982_a(-8 + world.field_73012_v.nextInt(17), world.field_73012_v.nextInt(8), -8 + world.field_73012_v.nextInt(17))).func_185904_a().func_76220_a()) {
            if (entity instanceof EntityLivingBase) {
                CoreUtils.teleportEntityTo((Entity)entity, (BlockPos)randPos);
            } else {
                entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                entity.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
            }
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return TFFluids.fluidEnder.getLuminosity();
    }

    public boolean initialize() {
        this.setRegistryName("fluid_ender");
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ItemBlock itemBlock = new ItemBlock((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        BlockFluidEnder.config();
        return true;
    }
}

