/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.init;

import cofh.core.gui.CreativeTabCore;
import cofh.core.init.CoreProps;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.init.TFEquipment;
import cofh.thermalfoundation.item.ItemWrench;
import java.io.File;
import java.io.InputStream;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.core.util.Loader;

public class TFProps {
    public static boolean disableAllTools = false;
    public static boolean disableAllArmor = false;
    public static boolean disableVanillaTools = false;
    public static boolean disableAllBows = false;
    public static boolean disableAllFishingRods = false;
    public static boolean disableAllShears = false;
    public static boolean disableAllShields = false;
    public static boolean showDisabledEquipment = false;
    public static final String LEXICON_TIMER = "thermalfoundation.lexicon_timer";
    public static final String LEXICON_DATA = "thermalfoundation.lexicon_data";
    public static final int MAX_LEVEL = 100;
    public static final int MAX_EXP = 30970;
    public static boolean dropSulfurFireImmuneMobs = true;
    public static boolean enablePyrotheumCrafting = true;
    public static boolean enablePetrotheumCrafting = true;
    public static boolean enableCryotheumCrafting = true;
    public static boolean enableHorseArmorCrafting = true;
    public static boolean enableSaddleCrafting = true;
    public static int fuelCokeFuel = 3200;
    public static int globRosinFuel = 800;
    public static int globTarFuel = 800;
    public static int dustPyrotheumFuel = 24000;
    public static boolean iconBlazePowder = true;
    public static boolean renderStarfieldCage = false;

    private TFProps() {
    }

    public static void preInit() {
        TFProps.configCommon();
        TFProps.configClient();
        TFProps.addWorldGeneration();
    }

    private static void configCommon() {
        String category = "General";
        String comment = "If TRUE, Fire-Immune mobs have a chance to drop Sulfur.";
        dropSulfurFireImmuneMobs = ThermalFoundation.CONFIG.getConfiguration().getBoolean("FireImmuneMobsDropSulfur", category, dropSulfurFireImmuneMobs, comment);
        comment = "If TRUE, Pyrotheum Dust can be used to smelt Ores into Ingots.";
        enablePyrotheumCrafting = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnablePyrotheumCrafting", category, enablePyrotheumCrafting, comment);
        comment = "If TRUE, Petrotheum Dust can be used to break Ores into Dusts and Gems.";
        enablePetrotheumCrafting = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnablePetrotheumCrafting", category, enablePetrotheumCrafting, comment);
        comment = "If TRUE, Cryotheum Dust can be used to create Ice and solidify Clathrates.";
        enableCryotheumCrafting = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnableCryotheumCrafting", category, enableCryotheumCrafting, comment);
        comment = "If TRUE, Horse Armor will be craftable.";
        enableHorseArmorCrafting = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnableHorseArmorCrafting", category, enableHorseArmorCrafting, comment);
        comment = "If TRUE, Saddles will be craftable.";
        enableSaddleCrafting = ThermalFoundation.CONFIG.getConfiguration().getBoolean("EnableSaddleCrafting", category, enableSaddleCrafting, comment);
        category = "Equipment";
        comment = "If TRUE, recipes for all Armor Sets are disabled.";
        disableAllArmor = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllArmorRecipes", category, disableAllArmor, comment);
        comment = "If TRUE, recipes for all Tools are disabled.";
        disableAllTools = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllToolRecipes", category, disableAllTools, comment);
        comment = "If TRUE, recipes for new Vanilla material (Wood, Stone, Iron, Gold, Diamond) Tools are disabled.";
        disableVanillaTools = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableVanillaToolRecipes", category, disableVanillaTools, comment);
        comment = "If TRUE, recipes for all new Bows will be disabled, leaving only the Vanilla Bow";
        disableAllBows = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllBows", category, disableAllBows, comment);
        comment = "If TRUE, recipes for all new Shears will be disabled, leaving only the Vanilla (Iron) Shears.";
        disableAllShears = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllShears", category, disableAllShears, comment);
        comment = "If TRUE, recipes for all new Fishing Rods will be disabled, leaving only the Vanilla (Wood) Fishing Rod";
        disableAllFishingRods = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllFishingRods", category, disableAllFishingRods, comment);
        comment = "If TRUE, recipes for all new Shields will be disabled, leaving only the Vanilla (Wood) Shield";
        disableAllShields = ThermalFoundation.CONFIG.getConfiguration().getBoolean("DisableAllShields", category, disableAllShields, comment);
        comment = "If TRUE, items which have had their recipes disabled will show in the Creative Tab and JEI.";
        showDisabledEquipment = ThermalFoundation.CONFIG.getConfiguration().getBoolean("ShowDisabledEquipment", category, showDisabledEquipment, comment);
    }

    private static void configClient() {
        String category = "Render";
        String comment = "If TRUE, Ender devices will be a bit more Cagey year-round.";
        renderStarfieldCage = ThermalFoundation.CONFIG_CLIENT.getConfiguration().getBoolean("CageyEnder", category, renderStarfieldCage, comment);
        category = "Interface";
        boolean armorTabCommon = false;
        boolean toolTabCommon = false;
        comment = "If TRUE, Thermal Foundation Armor Sets appear under the general \"Thermal Foundation\" Creative Tab.";
        armorTabCommon = ThermalFoundation.CONFIG_CLIENT.getConfiguration().getBoolean("ArmorInCommonTab", category, armorTabCommon, comment);
        comment = "If TRUE, Thermal Foundation Tools appear under the general \"Thermal Foundation\" Creative Tab.";
        toolTabCommon = ThermalFoundation.CONFIG_CLIENT.getConfiguration().getBoolean("ToolsInCommonTab", category, toolTabCommon, comment);
        ThermalFoundation.tabCommon = new CreativeTabCore("thermalfoundation"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_151244_d() {
                return ItemWrench.wrenchBasic;
            }
        };
        ThermalFoundation.tabArmor = armorTabCommon ? ThermalFoundation.tabCommon : new CreativeTabCore("thermalfoundation", "Armor"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_151244_d() {
                return TFEquipment.ArmorSet.INVAR.armorChestplate;
            }
        };
        ThermalFoundation.tabTools = toolTabCommon ? ThermalFoundation.tabCommon : new CreativeTabCore("thermalfoundation", "Tools"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_151244_d() {
                return TFEquipment.ToolSet.INVAR.toolPickaxe;
            }
        };
    }

    private static void addWorldGeneration() {
        String worldGenPath = "assets/thermalfoundation/world/";
        String worldGenOre = "01_thermalfoundation_ores.json";
        String worldGenOil = "02_thermalfoundation_oil.json";
        String worldGenClathrates = "03_thermalfoundation_clathrates.json";
        if (!ThermalFoundation.CONFIG.getConfiguration().getBoolean("GenerateDefaultFiles", "World", true, "If TRUE, Thermal Foundation will create default world generation files if it cannot find existing ones. Only disable if you know what you are doing.")) {
            return;
        }
        File worldGenFile = new File(CoreProps.configDir, "/cofh/world/" + worldGenOre);
        if (!worldGenFile.exists()) {
            try {
                worldGenFile.createNewFile();
                FileUtils.copyInputStreamToFile((InputStream)Loader.getResource((String)(worldGenPath + worldGenOre), null).openStream(), (File)worldGenFile);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!(worldGenFile = new File(CoreProps.configDir, "/cofh/world/" + worldGenOil)).exists()) {
            try {
                worldGenFile.createNewFile();
                FileUtils.copyInputStreamToFile((InputStream)Loader.getResource((String)(worldGenPath + worldGenOil), null).openStream(), (File)worldGenFile);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!(worldGenFile = new File(CoreProps.configDir, "/cofh/world/" + worldGenClathrates)).exists()) {
            try {
                worldGenFile.createNewFile();
                FileUtils.copyInputStreamToFile((InputStream)Loader.getResource((String)(worldGenPath + worldGenClathrates), null).openStream(), (File)worldGenFile);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }
}

