/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item;

import cofh.api.block.IBlockConfigGui;
import cofh.api.block.IBlockInfo;
import cofh.api.tileentity.ITileInfo;
import cofh.core.item.ItemMulti;
import cofh.core.render.IModelRegister;
import cofh.core.util.StateMapper;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ChatHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.item.ItemMaterial;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMeter
extends ItemMulti
implements IInitializer {
    public static ItemStack multimeter;

    public ItemMeter() {
        super("thermalfoundation");
        this.setUnlocalizedName("util", "meter");
        this.func_77637_a(ThermalFoundation.tabCommon);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    private boolean doMultimeterUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        player.func_184609_a(hand);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        ArrayList info = new ArrayList();
        if (ServerHelper.isClientWorld((World)world)) {
            if (block instanceof IBlockConfigGui || block instanceof IBlockInfo) {
                ServerHelper.sendItemUsePacket((World)world, (BlockPos)pos, (EnumFacing)side, (EnumHand)hand, (float)hitX, (float)hitY, (float)hitZ);
                return true;
            }
            TileEntity tile = world.func_175625_s(pos);
            return tile instanceof ITileInfo;
        }
        if (player.func_70093_af() && block instanceof IBlockConfigGui && ((IBlockConfigGui)block).openConfigGui((IBlockAccess)world, pos, side, player)) {
            return true;
        }
        if (block instanceof IBlockInfo) {
            ((IBlockInfo)block).getBlockInfo(info, (IBlockAccess)world, pos, side, player, false);
            ChatHelper.sendIndexedChatMessagesToPlayer((EntityPlayer)player, info);
            info.clear();
            return true;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof ITileInfo) {
            if (ServerHelper.isServerWorld((World)world)) {
                ((ITileInfo)tile).getTileInfo(info, side, player, false);
                ChatHelper.sendIndexedChatMessagesToPlayer((EntityPlayer)player, info);
            }
            info.clear();
            return true;
        }
        info.clear();
        return false;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        switch (Type.values()[ItemHelper.getItemDamage((ItemStack)stack)]) {
            case MULTIMETER: {
                tooltip.add(StringHelper.getInfoText((String)"info.thermalfoundation.util.multimeter.0"));
                tooltip.add(StringHelper.getNoticeText((String)"info.thermalfoundation.util.multimeter.1"));
                break;
            }
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        switch (Type.values()[ItemHelper.getItemDamage((ItemStack)stack)]) {
            case MULTIMETER: {
                return EnumRarity.COMMON;
            }
        }
        return EnumRarity.COMMON;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        boolean ret = false;
        switch (Type.values()[ItemHelper.getItemDamage((ItemStack)stack)]) {
            case MULTIMETER: {
                ret = this.doMultimeterUseFirst(stack, player, world, pos, side, hitX, hitY, hitZ, hand);
                break;
            }
        }
        return ret ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper(this.modName, "util", this.name);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)mapper);
        for (Map.Entry entry : this.itemMap.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)entry.getKey()), (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + "util", "type=" + ((ItemMulti.ItemEntry)entry.getValue()).name));
        }
    }

    public boolean initialize() {
        multimeter = this.addItem(Type.MULTIMETER.ordinal(), "multimeter");
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean register() {
        RecipeHelper.addShapedRecipe((ItemStack)multimeter, (Object[])new Object[]{"C C", "LPL", " G ", Character.valueOf('C'), "ingotCopper", Character.valueOf('L'), "ingotLead", Character.valueOf('P'), ItemMaterial.powerCoilElectrum, Character.valueOf('G'), "gearElectrum"});
        return true;
    }

    static enum Type {
        MULTIMETER,
        DEBUGGER;

    }
}

