/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalfoundation.item;

import cofh.api.item.IInventoryContainerItem;
import cofh.api.item.IMultiModeItem;
import cofh.core.item.ItemMulti;
import cofh.core.key.KeyBindingItemMultiMode;
import cofh.core.render.IModelRegister;
import cofh.core.util.CoreUtils;
import cofh.core.util.StateMapper;
import cofh.core.util.core.IInitializer;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.RecipeHelper;
import cofh.core.util.helpers.ServerHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.thermalfoundation.ThermalFoundation;
import cofh.thermalfoundation.util.LexiconManager;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTome
extends ItemMulti
implements IInitializer,
IInventoryContainerItem,
IMultiModeItem {
    public static ItemStack tomeLexicon;
    public static ItemStack tomeExperience;

    public ItemTome() {
        super("thermalfoundation");
        this.func_77625_d(1);
        this.func_77655_b("tome");
        this.func_77637_a(ThermalFoundation.tabCommon);
    }

    protected boolean isEmpowered(ItemStack stack) {
        return this.getMode(stack) == 1;
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        switch (Type.values()[ItemHelper.getItemDamage((ItemStack)stack)]) {
            case LEXICON: {
                tooltip.add(StringHelper.getInfoText((String)"info.thermalfoundation.tome.lexicon.a.0"));
                if (this.isEmpowered(stack)) {
                    tooltip.add(StringHelper.localize((String)"info.thermalfoundation.tome.lexicon.c.0") + "\u00a7r");
                    tooltip.add(StringHelper.localizeFormat((String)"info.thermalfoundation.tome.lexicon.c.1", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
                    break;
                }
                tooltip.add(StringHelper.localize((String)"info.thermalfoundation.tome.lexicon.b.0") + "\u00a7r");
                tooltip.add(StringHelper.localizeFormat((String)"info.thermalfoundation.tome.lexicon.b.1", (Object[])new Object[]{StringHelper.getKeyName((int)KeyBindingItemMultiMode.INSTANCE.getKey())}));
                break;
            }
            case EXPERIENCE: {
                tooltip.add(StringHelper.getInfoText((String)"info.thermalfoundation.tome.experience.a.0"));
                tooltip.add(StringHelper.formatNumber((long)this.getExperience(stack)));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isCurrentItem) {
        if (!this.isEmpowered(stack)) {
            return;
        }
        switch (Type.values()[ItemHelper.getItemDamage((ItemStack)stack)]) {
            case LEXICON: {
                NBTTagCompound tag = entity.getEntityData();
                tag.func_74772_a("thermalfoundation.lexicon_timer", entity.field_70170_p.func_82737_E());
                break;
            }
        }
    }

    public boolean func_77662_d() {
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        if (this.isEmpowered(stack)) {
            return EnumRarity.RARE;
        }
        return EnumRarity.UNCOMMON;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (CoreUtils.isFakePlayer((Entity)player) || hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        switch (Type.values()[ItemHelper.getItemDamage((ItemStack)stack)]) {
            case LEXICON: {
                if (!ServerHelper.isServerWorld((World)world) || LexiconManager.getSortedOreNames().size() <= 0) break;
                if (this.isEmpowered(stack)) {
                    player.openGui((Object)ThermalFoundation.instance, 2, world, 0, 0, 0);
                    break;
                }
                player.openGui((Object)ThermalFoundation.instance, 1, world, 0, 0, 0);
                break;
            }
            case EXPERIENCE: {
                if (player.field_71068_ca <= 0 || this.getExperience(stack) >= 30970) break;
                --player.field_71068_ca;
                this.modifyExperience(stack, player.func_71050_bK());
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    private int modifyExperience(ItemStack stack, int exp) {
        int storedExp = this.getExperience(stack) + exp;
        if (storedExp > 30970) {
            storedExp = 30970;
        } else if (storedExp < 0) {
            storedExp = 0;
        }
        stack.func_77978_p().func_74768_a("Experience", storedExp);
        return storedExp;
    }

    private int getExperience(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p().func_74762_e("Experience");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        StateMapper mapper = new StateMapper(this.modName, "util", this.name);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)mapper);
        for (Map.Entry entry : this.itemMap.entrySet()) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)((Integer)entry.getKey()), (ModelResourceLocation)new ModelResourceLocation(this.modName + ":" + "util", "type=" + ((ItemMulti.ItemEntry)entry.getValue()).name));
        }
    }

    public int getSizeInventory(ItemStack container) {
        switch (Type.values()[ItemHelper.getItemDamage((ItemStack)container)]) {
            case LEXICON: {
                return 3;
            }
        }
        return 0;
    }

    public int getMode(ItemStack stack) {
        return !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("Mode");
    }

    public boolean setMode(ItemStack stack, int mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("Mode", mode);
        return false;
    }

    public boolean incrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (++curMode >= this.getNumModes(stack)) {
            curMode = 0;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public boolean decrMode(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        int curMode = this.getMode(stack);
        if (--curMode <= 0) {
            curMode = this.getNumModes(stack) - 1;
        }
        stack.func_77978_p().func_74768_a("Mode", curMode);
        return true;
    }

    public int getNumModes(ItemStack stack) {
        return 2;
    }

    public void onModeChange(EntityPlayer player, ItemStack stack) {
        if (this.isEmpowered(stack)) {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.4f, 1.0f);
        } else {
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.6f);
        }
    }

    public boolean initialize() {
        tomeLexicon = this.addItem(0, "lexicon");
        ThermalFoundation.proxy.addIModelRegister((IModelRegister)this);
        return true;
    }

    public boolean register() {
        RecipeHelper.addShapedRecipe((ItemStack)tomeLexicon, (Object[])new Object[]{" D ", "GBI", " R ", Character.valueOf('D'), "gemLapis", Character.valueOf('G'), "ingotGold", Character.valueOf('B'), Items.field_151122_aG, Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"});
        return true;
    }

    static enum Type {
        LEXICON,
        EXPERIENCE;

    }
}

