/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLever;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.block.BlockBase;

public class BlockCaminiteLever
extends BlockBase {
    public static final PropertyEnum<BlockLever.EnumOrientation> FACING = PropertyEnum.func_177709_a((String)"facing", BlockLever.EnumOrientation.class);
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    protected static final AxisAlignedBB LEVER_NORTH_AABB = new AxisAlignedBB(0.3125, (double)0.2f, 0.625, 0.6875, (double)0.8f, 1.0);
    protected static final AxisAlignedBB LEVER_SOUTH_AABB = new AxisAlignedBB(0.3125, (double)0.2f, 0.0, 0.6875, (double)0.8f, 0.375);
    protected static final AxisAlignedBB LEVER_WEST_AABB = new AxisAlignedBB(0.625, (double)0.2f, 0.3125, 1.0, (double)0.8f, 0.6875);
    protected static final AxisAlignedBB LEVER_EAST_AABB = new AxisAlignedBB(0.0, (double)0.2f, 0.3125, 0.375, (double)0.8f, 0.6875);
    protected static final AxisAlignedBB LEVER_UP_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, (double)0.6f, 0.75);
    protected static final AxisAlignedBB LEVER_DOWN_AABB = new AxisAlignedBB(0.25, (double)0.4f, 0.25, 0.75, 1.0, 0.75);

    public BlockCaminiteLever(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return BlockCaminiteLever.canAttachTo(worldIn, pos, side.func_176734_d());
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockCaminiteLever.canAttachTo(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canAttachTo(World worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        return worldIn.func_180495_p(blockpos).isSideSolid((IBlockAccess)worldIn, blockpos, direction.func_176734_d());
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState iblockstate = this.func_176223_P().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        if (BlockCaminiteLever.canAttachTo(worldIn, pos, facing.func_176734_d())) {
            return iblockstate.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.func_176856_a((EnumFacing)facing, (EnumFacing)placer.func_174811_aO()));
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (enumfacing == facing || !BlockCaminiteLever.canAttachTo(worldIn, pos, enumfacing.func_176734_d())) continue;
            return iblockstate.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.func_176856_a((EnumFacing)enumfacing, (EnumFacing)placer.func_174811_aO()));
        }
        if (worldIn.func_180495_p(pos.func_177977_b()).func_185914_p()) {
            return iblockstate.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.func_176856_a((EnumFacing)EnumFacing.UP, (EnumFacing)placer.func_174811_aO()));
        }
        return iblockstate;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkCanSurvive(worldIn, pos, state) && !BlockCaminiteLever.canAttachTo(worldIn, pos, ((BlockLever.EnumOrientation)state.func_177229_b(FACING)).func_176852_c().func_176734_d())) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean checkCanSurvive(World p_181091_1_, BlockPos p_181091_2_, IBlockState p_181091_3_) {
        if (this.func_176196_c(p_181091_1_, p_181091_2_)) {
            return true;
        }
        this.func_176226_b(p_181091_1_, p_181091_2_, p_181091_3_, 0);
        p_181091_1_.func_175698_g(p_181091_2_);
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((BlockLever.EnumOrientation)state.func_177229_b(FACING)) {
            default: {
                return LEVER_EAST_AABB;
            }
            case WEST: {
                return LEVER_WEST_AABB;
            }
            case SOUTH: {
                return LEVER_SOUTH_AABB;
            }
            case NORTH: {
                return LEVER_NORTH_AABB;
            }
            case UP_Z: 
            case UP_X: {
                return LEVER_UP_AABB;
            }
            case DOWN_X: 
            case DOWN_Z: 
        }
        return LEVER_DOWN_AABB;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        state = state.func_177231_a((IProperty)POWERED);
        worldIn.func_180501_a(pos, state, 3);
        float f = (Boolean)state.func_177229_b((IProperty)POWERED) != false ? 0.6f : 0.5f;
        worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, f);
        worldIn.func_175685_c(pos, (Block)this, false);
        EnumFacing enumfacing = ((BlockLever.EnumOrientation)state.func_177229_b(FACING)).func_176852_c();
        worldIn.func_175685_c(pos.func_177972_a(enumfacing.func_176734_d()), (Block)this, false);
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            worldIn.func_175685_c(pos, (Block)this, false);
            EnumFacing enumfacing = ((BlockLever.EnumOrientation)state.func_177229_b(FACING)).func_176852_c();
            worldIn.func_175685_c(pos.func_177972_a(enumfacing.func_176734_d()), (Block)this, false);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) != false ? 15 : 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)POWERED) == false ? 0 : (((BlockLever.EnumOrientation)blockState.func_177229_b(FACING)).func_176852_c() == side ? 15 : 0);
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.func_176853_a((int)(meta & 7))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((BlockLever.EnumOrientation)state.func_177229_b(FACING)).func_176855_a();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((BlockLever.EnumOrientation)state.func_177229_b(FACING)) {
                    case EAST: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.WEST);
                    }
                    case WEST: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.EAST);
                    }
                    case SOUTH: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.NORTH);
                    }
                    case NORTH: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.SOUTH);
                    }
                }
                return state;
            }
            case COUNTERCLOCKWISE_90: {
                switch ((BlockLever.EnumOrientation)state.func_177229_b(FACING)) {
                    case EAST: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.NORTH);
                    }
                    case WEST: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.SOUTH);
                    }
                    case SOUTH: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.EAST);
                    }
                    case NORTH: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.WEST);
                    }
                    case UP_Z: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.UP_X);
                    }
                    case UP_X: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.UP_Z);
                    }
                    case DOWN_X: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.DOWN_Z);
                    }
                    case DOWN_Z: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.DOWN_X);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((BlockLever.EnumOrientation)state.func_177229_b(FACING)) {
                    case EAST: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.SOUTH);
                    }
                    case WEST: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.NORTH);
                    }
                    case SOUTH: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.WEST);
                    }
                    case NORTH: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.EAST);
                    }
                    case UP_Z: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.UP_X);
                    }
                    case UP_X: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.UP_Z);
                    }
                    case DOWN_X: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.DOWN_Z);
                    }
                    case DOWN_Z: {
                        return state.func_177226_a(FACING, (Comparable)BlockLever.EnumOrientation.DOWN_X);
                    }
                }
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a(((BlockLever.EnumOrientation)state.func_177229_b(FACING)).func_176852_c()));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, POWERED});
    }

    private boolean canAttach(World world, BlockPos pos, EnumFacing side) {
        return world.isSideSolid(pos, side);
    }
}

